/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.handler;

import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbEnv;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.Bridge;
import MITI.util.text.BridgeSpecificationLiteral;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class RequestHandler<I, O> {
    private MimbEnv env;
    private I request;
    private O response;
    private MimbExecutable.MIMBReturnCode returnCode = MimbExecutable.MIMBReturnCode.SUCCESS;

    protected RequestHandler(MimbEnv mimbEnv, I i) {
        this.env = mimbEnv;
        this.request = i;
    }

    public MimbEnv getEnv() {
        return this.env;
    }

    public I getRequest() {
        return this.request;
    }

    public O getResponse() {
        return this.response;
    }

    public MimbExecutable.MIMBReturnCode getReturnCode() {
        return this.returnCode;
    }

    public abstract String getRequestText();

    public abstract String getLanguage();

    public abstract String getResponseText();

    public abstract List<Action> generateActions();

    public boolean buildResponse(MimbExecutable.MIMBReturnCode mIMBReturnCode) {
        this.returnCode = mIMBReturnCode;
        if (mIMBReturnCode.getCode() > 0) {
            this.response = this.buildErrorResponse(mIMBReturnCode);
            return false;
        }
        this.response = this.buildMimbResponse(mIMBReturnCode);
        return true;
    }

    public boolean buildResponse(Map<BridgeSpecificationLiteral, BridgeLibrary> map) {
        if (map == null || map.isEmpty()) {
            return this.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
        }
        this.response = this.buildBridgeSpecsResponse(map);
        return true;
    }

    public boolean buildResponse(Collection<BridgeLibrary> collection) {
        if (collection == null || collection.isEmpty()) {
            return this.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
        }
        this.response = this.buildBridgeListResponse(collection);
        return true;
    }

    public boolean buildResponse(Bridge bridge, BridgeSpecification bridgeSpecification, Parameters parameters) {
        if (bridge == null || bridgeSpecification == null || parameters == null) {
            return this.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
        }
        this.response = this.buildBridgeInfoResponse(bridge, bridgeSpecification, parameters);
        return true;
    }

    protected abstract O buildErrorResponse(MimbExecutable.MIMBReturnCode var1);

    protected abstract O buildMimbResponse(MimbExecutable.MIMBReturnCode var1);

    protected abstract O buildBridgeSpecsResponse(Map<BridgeSpecificationLiteral, BridgeLibrary> var1);

    protected abstract O buildBridgeListResponse(Collection<BridgeLibrary> var1);

    protected abstract O buildBridgeInfoResponse(Bridge var1, BridgeSpecification var2, Parameters var3);

    protected void setLogLevel(int n) {
        if (this.env.getTroubleshootingPackage() == null && n >= 1 && n <= 6) {
            this.getEnv().getLogger().setLocalLevel(n);
            MIMB.LOG_LEVEL.log(this.getEnv().getLogger(), n);
        }
    }
}

