/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.handler;

import MITI.bridges.cache.MIMBCache;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.mimb.executable.MimbEnv;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BrowseAction;
import MITI.mimb.executable.actions.ExportAction;
import MITI.mimb.executable.actions.GetBridgeInformationAction;
import MITI.mimb.executable.actions.GetBridgeListAction;
import MITI.mimb.executable.actions.GetBridgeSpecsAction;
import MITI.mimb.executable.actions.ImportAction;
import MITI.mimb.executable.actions.ImportGenericOperationAction;
import MITI.mimb.executable.actions.InvalidAction;
import MITI.mimb.executable.actions.TestAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.BrowseRequest;
import MITI.mimb.executable.requests.DataQualityRequest;
import MITI.mimb.executable.requests.GenericOperationRequest;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.requests.TestRequest;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.BridgeListResponse;
import MITI.mimb.executable.responses.BridgeSpecsResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.text.BridgeSpecificationLiteral;
import MITI.util.xml.SoapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MimbExeRequestHandler
extends RequestHandler<Request, Response> {
    public MimbExeRequestHandler(MimbEnv mimbEnv, Request request) {
        super(mimbEnv, request);
    }

    @Override
    public String getRequestText() {
        return ((Request)this.getRequest()).toString();
    }

    @Override
    public String getLanguage() {
        return ((Request)this.getRequest()).getLanguage();
    }

    @Override
    public String getResponseText() {
        return ((Response)this.getResponse()).toXmlString(this.getEnv().getLogger().getEvents());
    }

    @Override
    public List<Action> generateActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Request request = (Request)this.getRequest();
        if (request != null) {
            if (request instanceof GetBridgeListRequest) {
                GetBridgeListAction getBridgeListAction = new GetBridgeListAction(this, (GetBridgeListRequest)request);
                arrayList.add(getBridgeListAction);
            } else if (request instanceof GetBridgeSpecsRequest) {
                GetBridgeSpecsAction getBridgeSpecsAction = new GetBridgeSpecsAction(this, (GetBridgeSpecsRequest)request);
                arrayList.add(getBridgeSpecsAction);
            } else if (request instanceof GetBridgeInformationRequest) {
                GetBridgeInformationAction getBridgeInformationAction = new GetBridgeInformationAction(this, (GetBridgeInformationRequest)request);
                arrayList.add(getBridgeInformationAction);
            } else if (request instanceof BrowseRequest) {
                this.setLogLevel(SoapUtil.getInt(((BrowseRequest)request).getLogLevel()));
                BrowseAction browseAction = new BrowseAction(this, (BrowseRequest)request, MIRValidationLevel.getDefaultLevel());
                arrayList.add(browseAction);
            } else if (request instanceof TestRequest) {
                this.setLogLevel(SoapUtil.getInt(((TestRequest)request).getLogLevel()));
                TestAction testAction = new TestAction(this, (TestRequest)request);
                arrayList.add(testAction);
            } else if (request instanceof RunMimbExtendedRequest) {
                Object object;
                RunMimbExtendedRequest runMimbExtendedRequest = (RunMimbExtendedRequest)request;
                String string = runMimbExtendedRequest.getLogLevel();
                this.setLogLevel(SoapUtil.getInt(string));
                String string2 = runMimbExtendedRequest.getLanguage();
                String string3 = runMimbExtendedRequest.getResetCache();
                if ("CLEAN_XMI_ONLY".equals(string3)) {
                    MIMBCache.setResetXmiCache((boolean)true);
                } else if ("CLEAN_ALL".equals(string3)) {
                    MIMBCache.setResetXmiCache((boolean)true);
                    MIMBCache.setResetNativeCache((boolean)true);
                }
                BridgeRunRequest bridgeRunRequest = runMimbExtendedRequest.getImportRequest();
                if (bridgeRunRequest != null) {
                    object = new ImportAction(this, bridgeRunRequest, runMimbExtendedRequest.getValidationLevel(), string, string2);
                    arrayList.add((Action)object);
                }
                if ((object = runMimbExtendedRequest.getExportRequest()) != null) {
                    ExportAction exportAction = new ExportAction(this, (BridgeRunRequest)object, runMimbExtendedRequest.getValidationLevel(), string, string2);
                    arrayList.add(exportAction);
                }
            } else if (request instanceof DataQualityRequest || request instanceof GenericOperationRequest) {
                ImportGenericOperationAction importGenericOperationAction = new ImportGenericOperationAction(this, (GenericOperationRequest)request);
                arrayList.add(importGenericOperationAction);
            } else {
                InvalidAction invalidAction = new InvalidAction(this);
                arrayList.add(invalidAction);
            }
        }
        return arrayList;
    }

    @Override
    protected Response buildErrorResponse(MimbExecutable.MIMBReturnCode mIMBReturnCode) {
        return new ErrorResponse(mIMBReturnCode);
    }

    @Override
    protected Response buildMimbResponse(MimbExecutable.MIMBReturnCode mIMBReturnCode) {
        return new RunMimbResponse(mIMBReturnCode);
    }

    @Override
    protected Response buildBridgeSpecsResponse(Map<BridgeSpecificationLiteral, BridgeLibrary> map) {
        BridgeSpecsResponse bridgeSpecsResponse = new BridgeSpecsResponse();
        bridgeSpecsResponse.setSpecs(map);
        return bridgeSpecsResponse;
    }

    @Override
    protected Response buildBridgeListResponse(Collection<BridgeLibrary> collection) {
        boolean bl = ((GetBridgeListRequest)this.getRequest()).isExport();
        boolean bl2 = ((GetBridgeListRequest)this.getRequest()).withSpecification();
        BridgeListResponse bridgeListResponse = new BridgeListResponse();
        for (BridgeLibrary bridgeLibrary : collection) {
            if (!bridgeLibrary.isEnabled()) continue;
            BridgeSpecificationLiteral bridgeSpecificationLiteral = MIRModelBridges.getBridgeSpecificationLiteral((String)bridgeLibrary.getBridgeId(), (boolean)bl);
            if (!this.getEnv().getOemCode().isValidBridge(bridgeSpecificationLiteral, bl)) continue;
            bridgeListResponse.addBridge(bridgeLibrary, bl2 ? bridgeSpecificationLiteral : null);
        }
        bridgeListResponse.setIsExport(bl);
        bridgeListResponse.setWithSpecification(bl2);
        return bridgeListResponse;
    }

    @Override
    protected Response buildBridgeInfoResponse(Bridge bridge, BridgeSpecification bridgeSpecification, Parameters parameters) {
        BridgeInformationResponse bridgeInformationResponse = new BridgeInformationResponse();
        bridgeInformationResponse.setBridgeId(bridge.getBridgeId());
        bridgeInformationResponse.setBridgeDisplayName(bridge.getDisplayName());
        bridgeInformationResponse.setIsExport(bridge.isExport());
        bridgeInformationResponse.setSpecification(bridgeSpecification);
        bridgeInformationResponse.setParameters(parameters);
        bridgeInformationResponse.setLanguage(((Request)this.getRequest()).getLanguage());
        bridgeInformationResponse.setUserIdentity(((Request)this.getRequest()).getUserIdentity());
        return bridgeInformationResponse;
    }
}

