/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.handler;

import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeInfo;
import MITI.mimb.bridge.BridgeParameter;
import MITI.mimb.bridge.BridgeParameterValue;
import MITI.mimb.bridge.BridgeSpecification;
import MITI.mimb.driver.ValidationLevel;
import MITI.mimb.executable.MimbEnv;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.BrowseAction;
import MITI.mimb.executable.actions.ExportAction;
import MITI.mimb.executable.actions.GetBridgeInformationAction;
import MITI.mimb.executable.actions.GetBridgeListAction;
import MITI.mimb.executable.actions.GetBridgeSpecsAction;
import MITI.mimb.executable.actions.ImportAction;
import MITI.mimb.executable.actions.ImportGenericOperationAction;
import MITI.mimb.executable.actions.InvalidAction;
import MITI.mimb.executable.actions.TestAction;
import MITI.mimb.executable.handler.BridgeDescription;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.message.mimb.request.BridgeConfig;
import MITI.mimb.message.mimb.request.BrowseRequest;
import MITI.mimb.message.mimb.request.GetBridgeInformationRequest;
import MITI.mimb.message.mimb.request.GetBridgeListRequest;
import MITI.mimb.message.mimb.request.GetBridgeSpecsRequest;
import MITI.mimb.message.mimb.request.MimbRequest;
import MITI.mimb.message.mimb.request.RunMimbExtendedRequest;
import MITI.mimb.message.mimb.request.RunMimbGenericOperationRequest;
import MITI.mimb.message.mimb.request.StartMimbRequest;
import MITI.mimb.message.mimb.request.TestRequest;
import MITI.mimb.message.mimb.response.BridgeInformationResponse;
import MITI.mimb.message.mimb.response.BridgeListResponse;
import MITI.mimb.message.mimb.response.BridgeSpecsResponse;
import MITI.mimb.message.mimb.response.MimbErrorResponse;
import MITI.mimb.message.mimb.response.MimbResponse;
import MITI.mimb.message.mimb.response.RunMimbResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.text.BridgeSpecificationLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DriverRequestHandler
extends RequestHandler<MimbRequest, MimbResponse> {
    public DriverRequestHandler(MimbEnv mimbEnv, MimbRequest mimbRequest) {
        super(mimbEnv, mimbRequest);
    }

    @Override
    public String getRequestText() {
        return ((MimbRequest)this.getRequest()).toXml();
    }

    @Override
    public String getLanguage() {
        return ((MimbRequest)this.getRequest()).getLanguage();
    }

    @Override
    public String getResponseText() {
        return ((MimbResponse)this.getResponse()).toXml();
    }

    @Override
    public List<Action> generateActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        MimbRequest mimbRequest = (MimbRequest)this.getRequest();
        if (mimbRequest != null) {
            if (mimbRequest instanceof StartMimbRequest) {
                this.setLogLevel(((StartMimbRequest)mimbRequest).getLogLevel());
            }
            if (mimbRequest instanceof GetBridgeListRequest) {
                GetBridgeListAction getBridgeListAction = new GetBridgeListAction(this, (GetBridgeListRequest)mimbRequest);
                arrayList.add(getBridgeListAction);
            } else if (mimbRequest instanceof GetBridgeSpecsRequest) {
                GetBridgeSpecsAction getBridgeSpecsAction = new GetBridgeSpecsAction(this, (GetBridgeSpecsRequest)mimbRequest);
                arrayList.add(getBridgeSpecsAction);
            } else if (mimbRequest instanceof GetBridgeInformationRequest) {
                GetBridgeInformationAction getBridgeInformationAction = new GetBridgeInformationAction(this, (GetBridgeInformationRequest)mimbRequest);
                arrayList.add(getBridgeInformationAction);
            } else if (mimbRequest instanceof BrowseRequest) {
                BrowseAction browseAction = new BrowseAction(this, (BrowseRequest)mimbRequest, MIRValidationLevel.getDefaultLevel());
                arrayList.add(browseAction);
            } else if (mimbRequest instanceof TestRequest) {
                TestAction testAction = new TestAction(this, (TestRequest)mimbRequest);
                arrayList.add(testAction);
            } else if (mimbRequest instanceof RunMimbExtendedRequest) {
                Object object;
                RunMimbExtendedRequest runMimbExtendedRequest = (RunMimbExtendedRequest)mimbRequest;
                String string = String.valueOf(runMimbExtendedRequest.getLogLevel());
                String string2 = runMimbExtendedRequest.getLanguage();
                BridgeConfig bridgeConfig = runMimbExtendedRequest.getImportBridge();
                if (bridgeConfig != null) {
                    object = new ImportAction(this, bridgeConfig, this.convert(runMimbExtendedRequest.getValidationLevel()), String.valueOf(string), string2);
                    arrayList.add((Action)object);
                }
                if ((object = runMimbExtendedRequest.getExportBridge()) != null) {
                    ExportAction exportAction = new ExportAction((RequestHandler<?, ?>)this, (BridgeConfig)object, this.convert(runMimbExtendedRequest.getValidationLevel()), String.valueOf(string), string2);
                    arrayList.add(exportAction);
                }
            } else if (mimbRequest instanceof RunMimbGenericOperationRequest) {
                ImportGenericOperationAction importGenericOperationAction = new ImportGenericOperationAction(this, (RunMimbGenericOperationRequest)mimbRequest);
                arrayList.add(importGenericOperationAction);
            } else {
                InvalidAction invalidAction = new InvalidAction(this);
                arrayList.add(invalidAction);
            }
        }
        return arrayList;
    }

    private MIRValidationLevel.Enum convert(ValidationLevel validationLevel) {
        if (validationLevel == ValidationLevel.ADVANCED) {
            return MIRValidationLevel.ADVANCED;
        }
        if (validationLevel == ValidationLevel.NONE) {
            return MIRValidationLevel.NONE;
        }
        return MIRValidationLevel.BASIC;
    }

    @Override
    protected MimbResponse buildErrorResponse(MimbExecutable.MIMBReturnCode mIMBReturnCode) {
        MimbErrorResponse mimbErrorResponse = new MimbErrorResponse();
        mimbErrorResponse.setErrorCode(mIMBReturnCode.getCode());
        mimbErrorResponse.setErrorMessage("MIMB failed with " + mIMBReturnCode.getMessage());
        return mimbErrorResponse;
    }

    @Override
    protected MimbResponse buildMimbResponse(MimbExecutable.MIMBReturnCode mIMBReturnCode) {
        RunMimbResponse runMimbResponse = new RunMimbResponse();
        return runMimbResponse;
    }

    @Override
    protected MimbResponse buildBridgeSpecsResponse(Map<BridgeSpecificationLiteral, BridgeLibrary> map) {
        BridgeSpecsResponse bridgeSpecsResponse = new BridgeSpecsResponse();
        for (Map.Entry<BridgeSpecificationLiteral, BridgeLibrary> entry : map.entrySet()) {
            BridgeSpecificationLiteral bridgeSpecificationLiteral = entry.getKey();
            BridgeLibrary bridgeLibrary = entry.getValue();
            MITI.mimb.bridge.BridgeSpecification bridgeSpecification = new MITI.mimb.bridge.BridgeSpecification();
            bridgeSpecification.setBridgeId(new BridgeId(bridgeSpecificationLiteral.getBridge_Id(), "Export".equals(bridgeSpecificationLiteral.getBridge_Direction()) ? BridgeId.Direction.EXPORT : BridgeId.Direction.IMPORT));
            bridgeSpecification.setDisplayName(bridgeLibrary != null ? bridgeLibrary.getDisplayName() : "");
            bridgeSpecification.setEnabled(bridgeLibrary != null);
            bridgeSpecification.setWindowsOnly(bridgeSpecificationLiteral.isBridge_IsWindowsOnly());
            bridgeSpecification.setAlias(bridgeSpecificationLiteral.isBridge_IsAlias());
            bridgeSpecification.setToolRequired(bridgeSpecificationLiteral.isBridge_IsToolRequired());
            bridgeSpecification.setRepositoryMultiModel(bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel());
            bridgeSpecification.setRepositoryBrowsable(bridgeSpecificationLiteral.isBridge_IsRepositoryBrowsable());
            bridgeSpecification.setIncrementallyHarvestable(bridgeSpecificationLiteral.isBridge_IsIncrementallyHarvestable());
            bridgeSpecification.setDataProfile(bridgeSpecificationLiteral.isBridge_IsDataProfile());
            bridgeSpecification.setMimbOemEnabled(bridgeSpecificationLiteral.isBridge_IsMimbOemEnabled());
            bridgeSpecification.setPartnershipLevel(bridgeSpecificationLiteral.getBridge_PartnershipLevel());
            bridgeSpecification.setVendor(new BridgeSpecification.Vendor(bridgeSpecificationLiteral.getVendor_Id(), bridgeSpecificationLiteral.getVendor_Name(), bridgeSpecificationLiteral.getVendor_Web()));
            bridgeSpecification.setTool(new BridgeSpecification.Tool(bridgeSpecificationLiteral.getTool_Name(), bridgeSpecificationLiteral.getTool_PreviousName(), bridgeSpecificationLiteral.getTool_Versions(), bridgeSpecificationLiteral.getTool_Web()));
            bridgeSpecification.setMethodology(new BridgeSpecification.Methodology(bridgeSpecificationLiteral.getMethodology_Summary(), bridgeSpecificationLiteral.getMethodology_ToolCategory()));
            bridgeSpecification.setToolInterface(new BridgeSpecification.ToolInterface(bridgeSpecificationLiteral.getToolInterface_Summary(), bridgeSpecificationLiteral.getToolInterface_Api(), bridgeSpecificationLiteral.getToolInterface_File()));
            bridgeSpecsResponse.addBridgeSpec(bridgeSpecification);
        }
        return bridgeSpecsResponse;
    }

    @Override
    protected MimbResponse buildBridgeListResponse(Collection<BridgeLibrary> collection) {
        boolean bl = ((GetBridgeListRequest)this.getRequest()).isExport();
        boolean bl2 = ((GetBridgeListRequest)this.getRequest()).withSpecification();
        BridgeListResponse bridgeListResponse = new BridgeListResponse();
        bridgeListResponse.setIsExport(((GetBridgeListRequest)this.getRequest()).isExport());
        for (BridgeLibrary bridgeLibrary : collection) {
            if (!bridgeLibrary.isEnabled()) continue;
            BridgeSpecificationLiteral bridgeSpecificationLiteral = MIRModelBridges.getBridgeSpecificationLiteral((String)bridgeLibrary.getBridgeId(), (boolean)bl);
            if (!this.getEnv().getOemCode().isValidBridge(bridgeSpecificationLiteral, bl)) continue;
            Bridge bridge = new Bridge(new BridgeId(bridgeLibrary.getBridgeId(), bl ? BridgeId.Direction.EXPORT : BridgeId.Direction.IMPORT));
            bridge.setDisplayName(bridgeLibrary.getDisplayName());
            bridge.setDescription("");
            if (bl2) {
                BridgeInfo bridgeInfo = new BridgeInfo();
                bridgeInfo.setVersion(bridgeSpecificationLiteral.getTool_Versions());
                bridgeInfo.setMethodology(bridgeSpecificationLiteral.getMethodology_Summary());
                bridgeInfo.setProductName(bridgeSpecificationLiteral.getTool_Name());
                bridgeInfo.setProductVersion(bridgeSpecificationLiteral.getTool_Versions());
                bridgeInfo.setProductCompany(bridgeSpecificationLiteral.getVendor_Name());
                bridgeInfo.setProductWeb(bridgeSpecificationLiteral.getTool_Web());
                bridgeInfo.setMultiModel(bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel());
                bridge.setInfo(bridgeInfo);
            }
            bridgeListResponse.addBridge(bridge);
        }
        return bridgeListResponse;
    }

    @Override
    protected MimbResponse buildBridgeInfoResponse(MITI.mimb.executable.actions.Bridge bridge, BridgeSpecification bridgeSpecification, Parameters parameters) {
        Object object;
        Bridge bridge2 = new Bridge(new BridgeId(bridge.getBridgeId(), bridge.isExport() ? BridgeId.Direction.EXPORT : BridgeId.Direction.IMPORT));
        bridge2.setDisplayName(bridge.getDisplayName());
        bridge2.setDescription(BridgeDescription.build(bridge.getBridgeId(), bridgeSpecification));
        if (bridgeSpecification != null) {
            object = new BridgeInfo();
            object.setVersion(bridgeSpecification.getBridgeVersion());
            object.setMethodology(bridgeSpecification.getProductMethodology());
            object.setProductName(bridgeSpecification.getProductName());
            object.setProductVersion(bridgeSpecification.getProductVersion());
            object.setProductCompany(bridgeSpecification.getProductCompany());
            object.setProductWeb(bridgeSpecification.getProductWeb());
            object.setMultiModel(bridgeSpecification.getMultiModel());
            bridge2.setInfo((BridgeInfo)object);
        }
        object = new ArrayList();
        for (Parameter parameter : parameters) {
            BridgeParameter bridgeParameter = new BridgeParameter();
            bridgeParameter.setBridgeParameterIdentifier(parameter.getName());
            bridgeParameter.setDisplayName(parameter.getDisplayName());
            bridgeParameter.setDescription(parameter.getDescription());
            bridgeParameter.setType(BridgeParameter.ParameterType.valueOf((String)parameter.getType().name()));
            bridgeParameter.setMandatory(parameter.isMandatory());
            bridgeParameter.setDeprecated(parameter.isDeprecated());
            bridgeParameter.setTransferable(parameter.isTransferable());
            bridgeParameter.setOpenMode(BridgeParameter.OpenMode.valueOf((String)parameter.getOpenMode().name()));
            bridgeParameter.setFileExtensions((Collection)parameter.getFileExtensions());
            bridgeParameter.setDefaultValue(new BridgeParameterValue(parameter.getDefaultValue()));
            if (!parameter.getPossibleValues().isEmpty()) {
                ArrayList<BridgeParameterValue> arrayList = new ArrayList<BridgeParameterValue>();
                for (Map.Entry entry : parameter.getPossibleValues().entrySet()) {
                    arrayList.add(new BridgeParameterValue((String)entry.getKey(), (String)entry.getValue()));
                }
                bridgeParameter.setPossibleValues(arrayList);
            }
            ((ArrayList)object).add(bridgeParameter);
        }
        bridge2.setBridgeParameters((Collection)object);
        Iterator iterator = new BridgeInformationResponse();
        iterator.setBridge(bridge2);
        return iterator;
    }
}

