/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.debug;

import MITI.mimb.executable.MimbExecutable;
import MITI.util.DateUtil;
import MITI.util.StringUtil;
import MITI.util.VersionInfo;
import MITI.util.file.FileUtil;
import MITI.util.file.Zip;
import MITI.util.log.LogEventHandler;
import MITI.util.log.PrintStreamLogEventHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.zip.ZipOutputStream;

public class TroubleshootingPackage {
    private File dir;
    private File tmpDir;
    private LogEventHandler log;
    private String prefix;
    private long time;
    private ArrayList<String> bridgeIds;
    private LinkedHashSet<File> importFiles;
    private LinkedHashSet<File> exportFiles;

    public TroubleshootingPackage(File file, File file2) {
        this.dir = file;
        this.tmpDir = file2;
        this.prefix = "MIMB";
        this.time = System.currentTimeMillis();
        this.bridgeIds = new ArrayList();
        this.importFiles = new LinkedHashSet();
        this.exportFiles = new LinkedHashSet();
    }

    public File getBackupFolder() {
        return this.getDir("bkp");
    }

    public File getLogFile() {
        return this.getFile("log.txt");
    }

    public File getRequestFile() {
        return this.getFile("request.xml");
    }

    public File getResponseFile() {
        return this.getFile("response.xml");
    }

    public File getXmiFolder() {
        return this.getDir("xmi");
    }

    private File getDir(String string) {
        File file = new File(this.tmpDir, string);
        file.mkdirs();
        return file;
    }

    private File getFile(String string) {
        File file = new File(this.tmpDir, string);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public LogEventHandler getLogHandler() {
        if (this.log == null) {
            try {
                this.log = new PrintStreamLogEventHandler(new PrintStream((OutputStream)new FileOutputStream(this.getLogFile()), false, StandardCharsets.UTF_8.name()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.log;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void addBridgeId(String string) {
        this.bridgeIds.add(string);
    }

    public void addImportFile(File file) {
        this.importFiles.add(file);
    }

    public void addExportFile(File file) {
        this.exportFiles.add(file);
    }

    public void close() {
        if (this.log != null) {
            this.log.close();
        }
        try {
            File file = new File(this.dir, this.getZipName());
            if (file.createNewFile()) {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
                    File file22;
                    this.addToZip(zipOutputStream, "", this.getRequestFile());
                    this.addToZip(zipOutputStream, "", this.getResponseFile());
                    this.addToZip(zipOutputStream, "", this.getLogFile());
                    this.addToZip(zipOutputStream, "xmi", this.getXmiFolder());
                    Iterator iterator = this.importFiles.iterator();
                    while (iterator.hasNext() && !this.addToZip(zipOutputStream, "import", file22 = (File)iterator.next())) {
                    }
                    for (File file22 : this.exportFiles) {
                        if (!this.addToZip(zipOutputStream, "export", file22)) continue;
                        break;
                    }
                }
            }
            FileUtil.delete(this.tmpDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean addToZip(ZipOutputStream zipOutputStream, String string, File file) throws IOException {
        Collection<Object> collection = Collections.emptyList();
        if (file.isDirectory()) {
            collection = FileUtil.list(file);
        } else if (file.isFile()) {
            collection = Collections.singleton(file);
        }
        for (File file2 : collection) {
            Zip.zip(zipOutputStream, string, new File[]{file2});
        }
        return !collection.isEmpty();
    }

    private String getZipName() {
        return this.prefix + "-" + VersionInfo.loadMitiJar(MimbExecutable.class).getVersionString() + "-" + (this.bridgeIds.isEmpty() ? "" : StringUtil.join(this.bridgeIds, "-") + "-") + DateUtil.formatDate(this.time, new SimpleDateFormat("yyyyMMdd-HHmmss")) + ".zip";
    }
}

