/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.debug;

import MITI.mimb.executable.MimbEnv;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class Conversation {
    private static AtomicInteger globalRequestSeq = new AtomicInteger(0);

    public static void write(MimbEnv mimbEnv, RequestHandler<?, ?> requestHandler) {
        File file = Conversation.getDirectory(mimbEnv);
        if (file != null) {
            int n = globalRequestSeq.incrementAndGet();
            Conversation.writeContent(Conversation.getFile(file, requestHandler.getRequest().getClass().getSimpleName(), n), requestHandler.getRequestText());
            Conversation.writeContent(Conversation.getFile(file, requestHandler.getResponse().getClass().getSimpleName(), n), requestHandler.getResponseText());
        }
        if (mimbEnv.getTroubleshootingPackage() != null) {
            Conversation.writeContent(mimbEnv.getTroubleshootingPackage().getRequestFile(), requestHandler.getRequestText());
            Conversation.writeContent(mimbEnv.getTroubleshootingPackage().getResponseFile(), requestHandler.getResponseText());
        }
    }

    private static File getDirectory(MimbEnv mimbEnv) {
        File file;
        String string = mimbEnv.getSetup().getModelBridgeXmlConversationDirectory();
        if (string != null && !string.isEmpty() && (file = new File(string)).isDirectory()) {
            return file;
        }
        return null;
    }

    private static File getFile(File file, String string, int n) {
        try {
            return File.createTempFile(string + "_" + n + "_", ".xml", file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void writeContent(File file, String string) {
        if (file != null) {
            FileUtil.writeContent(file, string, FileUtil.UTF8);
        }
    }
}

