/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.AccessHistoryOptions;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbGenericKeyValueOptions;
import MITI.bridges.javabridgeinterface.MimbGenericOperationBridgeInterface;
import MITI.bridges.javabridgeinterface.MimbGenericOperationOptions;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BridgeAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.GenericOperationRequest;
import MITI.mimb.message.mimb.request.RunMimbGenericOperationRequest;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;

public class ImportGenericOperationAction
extends BridgeAction {
    MimbGenericOperationOptions opOptions;

    public ImportGenericOperationAction(RequestHandler<?, ?> requestHandler, GenericOperationRequest genericOperationRequest) {
        super(requestHandler, genericOperationRequest.getImportRequest(), MIRValidationLevel.BASIC);
        this.opOptions = genericOperationRequest.getOptions();
    }

    public ImportGenericOperationAction(RequestHandler<?, ?> requestHandler, RunMimbGenericOperationRequest runMimbGenericOperationRequest) {
        super(requestHandler, runMimbGenericOperationRequest.getImportBridge(), MIRValidationLevel.BASIC, runMimbGenericOperationRequest.getLanguage());
        this.opOptions = "DataQuality".equals(runMimbGenericOperationRequest.getGenericOperatioName()) ? new DataQualityOptions() : ("AccessHistory".equals(runMimbGenericOperationRequest.getGenericOperatioName()) ? new AccessHistoryOptions() : new MimbGenericKeyValueOptions(runMimbGenericOperationRequest.getGenericOperatioName()));
        this.opOptions.valueOf(runMimbGenericOperationRequest.getGenericOperationOptions());
        this.opOptions.setOutputPath(runMimbGenericOperationRequest.getGenericOperationOutputPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean run() {
        try (Bridge bridge = Bridge.load(this.env, this.bridgeId, false, this.bridgeDisplayName);){
            if (bridge == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl;
            }
            if (bridge.getInterface() == null) {
                MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(this.bridgeId, MachineInfo.getOsInfo().getName());
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl;
            }
            MimbOptions mimbOptions = this.buildOptions(bridge);
            if (mimbOptions == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl;
            }
            this.displayBridgeInfo(bridge, mimbOptions);
            MIMB.TOOL_BRIDGE_PARAMETER.log("Options", this.opOptions.toString());
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.env.getSetup(), this.getOemToken(), MIRValidationLevel.BASIC);
            if (bridge.getInterface() instanceof MimbGenericOperationBridgeInterface) {
                MIMB.CALLING_DATAPROFILE_METHOD.log(new Object[0]);
                MimbGenericOperationBridgeInterface mimbGenericOperationBridgeInterface = (MimbGenericOperationBridgeInterface)bridge.getInterface();
                mimbGenericOperationBridgeInterface.runGenericOperation(this.bridgeId, mimbOptions, bridgeEnvironment, this.opOptions, MIRLogger.getLogger());
            } else {
                MIMB.WRN_DATAPROFILING_NOTSUPPORTED.log(new Object[0]);
            }
            MIMB.TOOL_MODEL_IMPORTED.log(this.getCurrentDate());
            boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
            return bl;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(throwable, throwable.getMessage());
            return this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
        }
    }
}

