/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.executable.MimbCpp;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BridgeAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.message.mimb.request.BridgeConfig;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;

public class ImportAction
extends BridgeAction {
    private String logLevel;

    public ImportAction(RequestHandler<?, ?> requestHandler, BridgeRunRequest bridgeRunRequest, MIRValidationLevel.Enum enum_, String string, String string2) {
        super(requestHandler, bridgeRunRequest, enum_);
        this.logLevel = string;
        this.language = string2;
    }

    public ImportAction(RequestHandler<?, ?> requestHandler, BridgeConfig bridgeConfig, MIRValidationLevel.Enum enum_, String string, String string2) {
        super(requestHandler, bridgeConfig, enum_, string2);
        this.logLevel = string;
    }

    public BridgeSpecificationLiteral getBridgeSpec() {
        return MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run() {
        try (Bridge bridge = Bridge.load(this.env, this.bridgeId, false, this.bridgeDisplayName);){
            Object object;
            if (bridge == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl;
            }
            if (this.isMIMBIntermediateStep()) {
                File file;
                boolean bl = false;
                MimbOption mimbOption = this.userOptions.getOption("File");
                if (mimbOption != null) {
                    file = new File(mimbOption.getValue());
                    File file2 = MIRMixManager.getModelFile(this.dir);
                    MIMB.DBG_MOVING_FILES.log(file.getPath(), file2.getPath());
                    bl = FileUtil.copy(file, file2);
                } else {
                    mimbOption = this.userOptions.getOption("Directory");
                    if (mimbOption != null) {
                        file = new File(mimbOption.getValue());
                        MIMB.DBG_MOVING_FILES.log(file.getPath(), this.dir.getPath());
                        bl = FileUtil.copy(file, this.dir);
                    }
                }
                boolean bl2 = this.handler.buildResponse(bl ? MimbExecutable.MIMBReturnCode.SUCCESS : MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl2;
            }
            if (bridge.getInterface() == null) {
                if (!MachineInfo.isWindows()) {
                    MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(this.bridgeId, MachineInfo.getOsInfo().getName());
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                    return bl;
                }
                object = new BridgeRunRequest();
                ((Request)object).setLanguage("");
                ((BridgeRunRequest)object).setBridgeId(this.bridgeId);
                ((BridgeRunRequest)object).setBridgeDisplayName(this.bridgeDisplayName);
                ((BridgeRunRequest)object).setUserOptions(this.userOptions.get());
                ((BridgeRunRequest)object).setDisableLog(this.disableLog);
                BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
                bridgeRunRequest.setLanguage("");
                bridgeRunRequest.setBridgeId("MetaIntegrationMultiModelXml");
                bridgeRunRequest.setBridgeDisplayName("MIMB Intermediate Step");
                MimbOptions mimbOptions = new MimbOptions();
                mimbOptions.addOption("Directory", this.dir.getPath(), "");
                mimbOptions.addOption("Verboseness Level", "Low", "");
                mimbOptions.addOption("Remove textual information", "False", "");
                bridgeRunRequest.setUserOptions(mimbOptions);
                bridgeRunRequest.setDisableLog(true);
                RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
                runMimbExtendedRequest.setLanguage(this.language);
                runMimbExtendedRequest.setImportRequest((BridgeRunRequest)object);
                runMimbExtendedRequest.setExportRequest(bridgeRunRequest);
                runMimbExtendedRequest.setValidationLevel(this.validationLevel);
                runMimbExtendedRequest.setCommandLineFile("");
                runMimbExtendedRequest.setLogLevel(this.logLevel);
                Response response = MimbCpp.execute(runMimbExtendedRequest, this.env.getSetup(), MIRLogger.getLogger(), this.getOemToken());
                if (response != null && !(response instanceof ErrorResponse)) {
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
                    return bl;
                }
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl;
            }
            object = this.buildOptions(bridge);
            if (object == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl;
            }
            this.displayBridgeInfo(bridge, (MimbOptions)object);
            MIMB.CALLING_RUN_METHOD.log(new Object[0]);
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.env.getSetup(), this.getOemToken(), this.validationLevel);
            boolean bl = bridge.getInterface().run(this.bridgeId, this.dir, (MimbOptions)object, bridgeEnvironment, MIRLogger.getLogger());
            if (!bl) {
                boolean bl3 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
                return bl3;
            }
            MIMB.TOOL_MODEL_IMPORTED.log(this.getCurrentDate());
            boolean bl4 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
            return bl4;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(throwable, throwable.getMessage());
            return this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_IMPORT);
        }
    }
}

