/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.executable.MimbCpp;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.Response;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import java.util.Iterator;

public class GetBridgeInformationAction
extends Action {
    protected String bridgeId;
    protected String bridgeDisplayName;
    protected boolean isExport;
    protected String language;

    public GetBridgeInformationAction(RequestHandler<?, ?> requestHandler, GetBridgeInformationRequest getBridgeInformationRequest) {
        super(requestHandler);
        this.bridgeId = getBridgeInformationRequest.getBridgeId();
        this.bridgeDisplayName = getBridgeInformationRequest.getBridgeDisplayName();
        this.isExport = getBridgeInformationRequest.isExport();
        this.language = getBridgeInformationRequest.getLanguage();
    }

    public GetBridgeInformationAction(RequestHandler<?, ?> requestHandler, MITI.mimb.message.mimb.request.GetBridgeInformationRequest getBridgeInformationRequest) {
        super(requestHandler);
        this.bridgeId = getBridgeInformationRequest.getBridgeId().getId();
        this.bridgeDisplayName = getBridgeInformationRequest.getBridgeDisplayName();
        this.isExport = getBridgeInformationRequest.getBridgeId().getDirection() == BridgeId.Direction.EXPORT;
        this.language = getBridgeInformationRequest.getLanguage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run() {
        try (Bridge bridge = Bridge.load(this.env, this.bridgeId, this.isExport, this.bridgeDisplayName);){
            Parameters parameters;
            GetBridgeInformationRequest getBridgeInformationRequest;
            if (bridge == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                return bl;
            }
            if (bridge.getInterface() == null) {
                if (!MachineInfo.isWindows()) {
                    MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(this.bridgeId, MachineInfo.getOsInfo().getName());
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                    return bl;
                }
                getBridgeInformationRequest = new GetBridgeInformationRequest();
                getBridgeInformationRequest.setLanguage(this.language);
                getBridgeInformationRequest.setBridgeId(this.bridgeId);
                getBridgeInformationRequest.setBridgeDisplayName(this.bridgeDisplayName);
                getBridgeInformationRequest.setIsExport(this.isExport);
                Response response = MimbCpp.execute(getBridgeInformationRequest, this.env.getSetup(), MIRLogger.getLogger(), this.getOemToken());
                if (response instanceof BridgeInformationResponse) {
                    BridgeInformationResponse bridgeInformationResponse = (BridgeInformationResponse)response;
                    boolean bl = this.handler.buildResponse(bridge, bridgeInformationResponse.getSpecification(), bridgeInformationResponse.getParameters());
                    return bl;
                }
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                return bl;
            }
            try {
                getBridgeInformationRequest = bridge.getInterface().getSpecification(this.bridgeId);
            }
            catch (Throwable throwable) {
                MIMB.TOOL_CANNOT_GET_SPECS.log(throwable, this.bridgeId, throwable.getMessage());
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                if (bridge == null) return bl;
                if (var2_3 == null) {
                    bridge.close();
                    return bl;
                }
                try {
                    bridge.close();
                    return bl;
                }
                catch (Throwable throwable2) {
                    var2_3.addSuppressed(throwable2);
                    return bl;
                }
            }
            try {
                parameters = bridge.getInterface().getParameters();
            }
            catch (Throwable throwable) {
                MIMB.TOOL_CANNOT_GET_OPTS.log(throwable, this.bridgeId, throwable.getMessage());
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
                if (bridge == null) return bl;
                if (var2_3 == null) {
                    bridge.close();
                    return bl;
                }
                try {
                    bridge.close();
                    return bl;
                }
                catch (Throwable throwable3) {
                    var2_3.addSuppressed(throwable3);
                    return bl;
                }
            }
            if (this.env.getOemCode() != OEMCode.MIR_WEB) {
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    if (!((Parameter)iterator.next()).getName().startsWith("__")) continue;
                    iterator.remove();
                }
            }
            boolean bl = this.handler.buildResponse(bridge, (BridgeSpecification)getBridgeInformationRequest, parameters);
            return bl;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(throwable, throwable.getMessage());
            return this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_EXE);
        }
    }
}

