/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.messages.Mimb.MIMB;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.executable.MimbCpp;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.actions.Bridge;
import MITI.mimb.executable.actions.BridgeAction;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.message.mimb.request.BrowseRequest;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import java.io.File;

public class BrowseAction
extends BridgeAction {
    protected boolean isExport;
    private String browseParameterIdentifier;
    private File browseFile;
    private String logLevel;

    public BrowseAction(RequestHandler<?, ?> requestHandler, MITI.mimb.executable.requests.BrowseRequest browseRequest, MIRValidationLevel.Enum enum_) {
        super(requestHandler, browseRequest, enum_);
        this.isExport = browseRequest.isExport();
        this.browseParameterIdentifier = browseRequest.getBrowseParameterIdentifier();
        this.browseFile = new File(browseRequest.getBrowseFile());
        this.logLevel = browseRequest.getLogLevel();
    }

    public BrowseAction(RequestHandler<?, ?> requestHandler, BrowseRequest browseRequest, MIRValidationLevel.Enum enum_) {
        super(requestHandler, browseRequest.getBridge(), enum_, browseRequest.getLanguage());
        this.isExport = browseRequest.getBridge().getBridgeId().getDirection() == BridgeId.Direction.EXPORT;
        this.browseParameterIdentifier = browseRequest.getBrowseParameterIdentifier();
        this.browseFile = new File(browseRequest.getBrowseFile());
        this.logLevel = String.valueOf(browseRequest.getLogLevel());
    }

    public boolean isExport() {
        return this.isExport;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run() {
        try (Bridge bridge = Bridge.load(this.env, this.bridgeId, this.isExport, this.bridgeDisplayName);){
            Object object;
            if (bridge == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return bl;
            }
            if (bridge.getInterface() == null) {
                if (!MachineInfo.isWindows()) {
                    MIMB.BRIDGE_NOT_AVAILABLE_FOR_OPERATING_SYSTEM.log(this.bridgeId, MachineInfo.getOsInfo().getName());
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                    return bl;
                }
                object = new MITI.mimb.executable.requests.BrowseRequest();
                ((Request)object).setLanguage(this.language);
                ((BridgeRunRequest)object).setBridgeId(this.bridgeId);
                ((BridgeRunRequest)object).setBridgeDisplayName(this.bridgeDisplayName);
                ((BridgeRunRequest)object).setDisableLog(this.disableLog);
                ((BridgeRunRequest)object).setUserOptions(this.userOptions.get());
                ((MITI.mimb.executable.requests.BrowseRequest)object).setIsExport(this.isExport);
                ((MITI.mimb.executable.requests.BrowseRequest)object).setLogLevel(this.logLevel);
                ((MITI.mimb.executable.requests.BrowseRequest)object).setBrowseFile(this.browseFile.getPath());
                ((MITI.mimb.executable.requests.BrowseRequest)object).setBowseParameterIdentifier(this.browseParameterIdentifier);
                ((MITI.mimb.executable.requests.BrowseRequest)object).setValidationLevel(this.validationLevel);
                Response response = MimbCpp.execute((Request)object, this.env.getSetup(), MIRLogger.getLogger(), this.getOemToken());
                if (response != null && !(response instanceof ErrorResponse)) {
                    boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
                    return bl;
                }
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return bl;
            }
            object = this.buildOptions(bridge);
            if (object == null) {
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return bl;
            }
            MimbOption mimbOption = object.getOption(this.browseParameterIdentifier);
            if (mimbOption == null || mimbOption.getParameter().getType() != Parameter.Type.REPOSITORY_MODEL && mimbOption.getParameter().getType() != Parameter.Type.REPOSITORY_SUBSET) {
                MIMB.TOOL_INVALID_BROWSE_PARAMETER.log(this.browseParameterIdentifier);
                boolean bl = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return bl;
            }
            this.displayBridgeInfo(bridge, (MimbOptions)object);
            MIMB.CALLING_BROWSE_METHOD.log(this.browseParameterIdentifier);
            BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(this.env.getSetup(), this.getOemToken(), MIRValidationLevel.BROWSE);
            boolean bl = bridge.getInterface().browse(this.bridgeId, this.browseFile, this.browseParameterIdentifier, (MimbOptions)object, bridgeEnvironment, MIRLogger.getLogger());
            if (!bl) {
                boolean bl2 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
                return bl2;
            }
            boolean bl3 = this.handler.buildResponse(MimbExecutable.MIMBReturnCode.SUCCESS);
            return bl3;
        }
        catch (Throwable throwable) {
            MIMB.GENERAL_ERROR.log(throwable, throwable.getMessage());
            return this.handler.buildResponse(MimbExecutable.MIMBReturnCode.ERROR_BROWSE);
        }
    }
}

