/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.actions;

import MITI.MIRException;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.mimb.executable.MimbEnv;
import MITI.util.text.BridgeSpecificationLiteral;

public class Bridge
implements AutoCloseable {
    private MimbEnv env;
    private String bridgeId;
    private boolean isExport;
    private String displayName;
    private BridgeInterface bridgeInterface;
    private BridgeSpecificationLiteral spec;

    private Bridge(MimbEnv mimbEnv, String string, boolean bl, String string2, BridgeInterface bridgeInterface) {
        this.env = mimbEnv;
        this.bridgeId = string;
        this.isExport = bl;
        this.displayName = string2;
        this.bridgeInterface = bridgeInterface;
    }

    public static Bridge load(MimbEnv mimbEnv, String string, boolean bl, String string2) throws MIRException {
        BridgeLibrary bridgeLibrary = mimbEnv.getModelBridges().loadBridgeLibrary(string, bl);
        if (bridgeLibrary != null) {
            return new Bridge(mimbEnv, string, bl, string2.isEmpty() ? bridgeLibrary.getDisplayName() : string2, mimbEnv.getBridgeLoader().loadBridge(string, bl));
        }
        return null;
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BridgeInterface getInterface() {
        return this.bridgeInterface;
    }

    public BridgeSpecificationLiteral getBridgeSpecs() {
        if (this.spec == null) {
            this.spec = MIRModelBridges.getBridgeSpecificationLiteral((String)this.bridgeId, (boolean)this.isExport);
        }
        return this.spec;
    }

    @Override
    public void close() {
        if (this.bridgeInterface != null) {
            this.env.getBridgeLoader().unloadBridge(this.bridgeInterface);
        }
    }
}

