/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.javabridge.JavaBridge;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.maven.PomDb;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.messages.Mimb.MIMB;
import MITI.messages.Mimb.MMGR;
import MITI.mimb.executable.LicenseKey;
import MITI.mimb.executable.MimbEnv;
import MITI.mimb.executable.Platform;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.BridgeAction;
import MITI.mimb.executable.actions.BrowseAction;
import MITI.mimb.executable.actions.ExportAction;
import MITI.mimb.executable.actions.GetBridgeInformationAction;
import MITI.mimb.executable.actions.GetBridgeListAction;
import MITI.mimb.executable.actions.GetBridgeSpecsAction;
import MITI.mimb.executable.actions.ImportAction;
import MITI.mimb.executable.actions.ImportGenericOperationAction;
import MITI.mimb.executable.actions.TestAction;
import MITI.mimb.executable.debug.Conversation;
import MITI.mimb.executable.debug.TroubleshootingPackage;
import MITI.mimb.executable.handler.CommandLineRequestHandler;
import MITI.mimb.executable.handler.DriverRequestHandler;
import MITI.mimb.executable.handler.MimbExeRequestHandler;
import MITI.mimb.executable.handler.RequestHandler;
import MITI.mimb.executable.oem.OEM;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.message.mimb.request.MimbRequest;
import MITI.mimb.message.mimb.response.MimbResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.DateUtil;
import MITI.util.Shutdown;
import MITI.util.VersionInfo;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.FlagOption;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.HiddenOption;
import MITI.util.cmd.Option;
import MITI.util.cmd.RepeatableOption;
import MITI.util.cmd.TypedOption;
import MITI.util.config.MimbConfiguration;
import MITI.util.config.MitiDebug;
import MITI.util.config.MitiLocale;
import MITI.util.file.FileUtil;
import MITI.util.file.Zip;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MIRLogger;
import MITI.util.log.PrintStreamLogEventHandler;
import MITI.util.log.XmlLogEventHandler;
import MITI.util.os.MachineInfo;
import MITI.util.os.OsInfo;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MimbExecutable {
    private static HelpOption helpOption = new HelpOption();
    private static Option logOption = new Option(new String[]{"-l", "--logFile"}, MIMB.PARAM_DESCR_L.getText());
    private static Option requestOption = new Option(new String[]{"-r", "--request"}, MIMB.PARAM_DESCR_R.getText());
    private static Option replyOption = new Option(new String[]{"-y", "--reply"}, MIMB.PARAM_DESCR_Y.getText());
    private static Option importBridgeOption = new Option(new String[]{"-i", "--import"}, MIMB.PARAM_DESCR_I.getText());
    private static Option exportBridgeOption = new Option(new String[]{"-e", "--export"}, MIMB.PARAM_DESCR_E.getText());
    private static Option importPathOption = new Option(new String[]{"-f", "--from"}, MIMB.PARAM_DESCR_F.getText());
    private static Option exportPathOption = new Option(new String[]{"-t", "--to"}, MIMB.PARAM_DESCR_T.getText());
    private static RepeatableOption importBridgeParameterOption = new RepeatableOption(new String[]{"-o", "--importOption"}, MIMB.PARAM_DESCR_O.getText());
    private static RepeatableOption exportBridgeParameterOption = new RepeatableOption(new String[]{"-p", "--exportOption"}, MIMB.PARAM_DESCR_P.getText());
    private static Option consistencyOption = new Option(new String[]{"-c", "--consistency"}, MIMB.PARAM_DESCR_C.getText(), TypedOption.Type.INT);
    private static Option validationOption = new Option(new String[]{"-v", "--validation"}, MIMB.PARAM_DESCR_V.getText());
    private static FlagOption processIDOption = new FlagOption(new String[]{"-X", "--pid"}, MIMB.PARAM_DESCR_X.getText());
    private static FlagOption downloadOption = new FlagOption(new String[]{"-d", "--download"}, MIMB.PARAM_DESCR_D.getText());
    private static Option troubleshootingOption = new Option(new String[]{"-ts", "--troubleshooting"}, MIMB.PARAM_DESCR_TS.getText());
    private static HiddenOption shutdownOption = new HiddenOption(new String[]{"-s", "--shutdown"});
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, logOption, requestOption, replyOption, importBridgeOption, importPathOption, importBridgeParameterOption, exportBridgeOption, exportPathOption, exportBridgeParameterOption, consistencyOption, validationOption, processIDOption, downloadOption, troubleshootingOption, shutdownOption};

    private static void printUsage() {
        CommandLineParser.printUsage(options, System.out);
    }

    private static void printJavaInfo() {
        MBCM.MSG_STARTING_JVM.log(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions());
    }

    private static boolean validateActions(List<Action> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Action action = list.get(i);
            if (!(action instanceof BrowseAction || action instanceof TestAction || action instanceof GetBridgeListAction || action instanceof GetBridgeSpecsAction || action instanceof GetBridgeInformationAction ? n != 1 : (action instanceof ImportAction ? i != 0 : action instanceof ExportAction && i != n - 1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        FileOutputStream fileOutputStream;
        File file;
        Object object;
        Object object2;
        MIMBReturnCode mIMBReturnCode = MIMBReturnCode.SUCCESS;
        int n = 0;
        OEMCode oEMCode = OEM.getEnvOemCode();
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(MBCM.MSG_STARTING_JVM.getMessage(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions()));
            MimbExecutable.printUsage();
            System.err.println(illegalArgumentException.toString());
            mIMBReturnCode = MIMBReturnCode.ERROR_EXE;
            System.exit(mIMBReturnCode.getCode());
        }
        if (helpOption.isSet()) {
            MimbExecutable.printUsage();
            System.exit(mIMBReturnCode.getCode());
        }
        if (shutdownOption.isSet()) {
            Shutdown.listen(shutdownOption.getFileValue());
        }
        if (processIDOption.isSet()) {
            System.out.println("PID=" + MachineInfo.getJavaProcessId());
        }
        TroubleshootingPackage troubleshootingPackage = null;
        if (troubleshootingOption.isSet()) {
            object2 = troubleshootingOption.getFileValue();
            ((File)object2).mkdirs();
            object = null;
            try {
                object = MIRBridgeLib.makeTempDir((String)"troubleshooting");
            }
            catch (MIRException mIRException) {
                // empty catch block
            }
            if (((File)object2).isDirectory() && object != null) {
                troubleshootingPackage = new TroubleshootingPackage((File)object2, (File)object);
            }
        }
        object2 = System.out;
        object = requestOption.isSet() ? new XmlLogEventHandler(System.err) : new PrintStreamLogEventHandler(System.err);
        BufferedLogEventHandler bufferedLogEventHandler = null;
        if (oEMCode != OEMCode.MIMB_WEB && oEMCode != OEMCode.MIR_WEB && oEMCode != OEMCode.MIMB_CLOUD_TEST && oEMCode != OEMCode.OEM_MICROSOFT_DATACATALOG) {
            bufferedLogEventHandler = new BufferedLogEventHandler();
        }
        MIRLogger mIRLogger = MIRLogger.init(new LogEventHandler[]{object, bufferedLogEventHandler, troubleshootingPackage != null ? troubleshootingPackage.getLogHandler() : null});
        if (logOption.isSet()) {
            file = logOption.getFileValue();
            try {
                fileOutputStream = new FileOutputStream(file, requestOption.isSet() && replyOption.isSet());
                object = requestOption.isSet() ? new XmlLogEventHandler(fileOutputStream) : new PrintStreamLogEventHandler(new PrintStream((OutputStream)fileOutputStream, false, "utf-8"));
                mIRLogger = MIRLogger.init(new LogEventHandler[]{object, bufferedLogEventHandler, troubleshootingPackage != null ? troubleshootingPackage.getLogHandler() : null});
            }
            catch (IOException iOException) {
                MIMB.TOOL_CANNOT_OPEN_LOG_FILE.log(mIRLogger, iOException, logOption.getStringValue());
                ++n;
            }
        }
        if (troubleshootingOption.isSet()) {
            mIRLogger.setLocalLevel(6);
        }
        MIMB.DBG_MIMB_COMMAND_LINE_OPTIONS_PROCESSED.log(mIRLogger, new Object[0]);
        try {
            file = MimbConfiguration.getMimbHome();
            fileOutputStream = MIRSetup.loadSetup((File)file);
            MimbEnv mimbEnv = new MimbEnv((MIRSetup)fileOutputStream, mIRLogger, oEMCode);
            mimbEnv.setTroubleshootingPackage(troubleshootingPackage);
            RequestHandler requestHandler = null;
            if (requestOption.isSet()) {
                Object object3;
                Document document;
                if ("stdin".equalsIgnoreCase(requestOption.getStringValue())) {
                    document = MIRBridgeLib.parseXmlStream((InputStream)System.in, (MIRLogger)mIRLogger);
                } else {
                    object3 = new File(requestOption.getStringValue());
                    document = MIRBridgeLib.parseXmlFile((File)object3, (boolean)true, (MIRLogger)mIRLogger);
                }
                object3 = document.getDocumentElement();
                requestHandler = "driver".equals(object3.getAttribute("format")) ? new DriverRequestHandler(mimbEnv, MimbRequest.fromXml((Element)object3)) : new MimbExeRequestHandler(mimbEnv, Request.decodeXmlRequest((Element)object3));
            } else {
                requestHandler = new CommandLineRequestHandler(mimbEnv, MimbExecutable.decodeCommandLineRequest());
            }
            MIMB.DBG_MIMB_REQUEST_PARSED.log(mIRLogger, new Object[0]);
            if (replyOption.isSet() && !"stdout".equalsIgnoreCase(replyOption.getStringValue())) {
                try {
                    object2 = new PrintStream(new File(replyOption.getStringValue()), "UTF-8");
                }
                catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                    MIMB.TOOL_CANNOT_OPEN_REPLY_FILE.log(mIRLogger, replyOption.getStringValue());
                    ++n;
                }
            }
            if (n > 0) {
                requestHandler.buildResponse(MIMBReturnCode.ERROR_USAGE);
            } else if (downloadOption.isSet()) {
                if (importBridgeOption.isSet()) {
                    MimbExecutable.downloadDrivers(file, mIRLogger, true, importBridgeOption.getStringValue(), MimbExecutable.getBridgeOptions(importBridgeParameterOption));
                } else if (exportBridgeOption.isSet()) {
                    MimbExecutable.downloadDrivers(file, mIRLogger, false, exportBridgeOption.getStringValue(), MimbExecutable.getBridgeOptions(exportBridgeParameterOption));
                } else {
                    MimbExecutable.downloadDrivers(file, mIRLogger, null, null, null);
                }
                requestHandler.buildResponse(MIMBReturnCode.SUCCESS);
            } else {
                MimbExecutable.executeRequest(mimbEnv, requestHandler);
            }
            MIMB.DBG_MIMB_PRINTING_REPLY.log(mIRLogger, new Object[0]);
            if (requestHandler.getResponse() == null) {
                requestHandler.buildResponse(MIMBReturnCode.ERROR_USAGE);
            }
            ((PrintStream)object2).print(requestHandler.getResponseText());
            ((PrintStream)object2).flush();
            mIMBReturnCode = requestHandler.getReturnCode();
            MIMB.DBG_MIMB_PRINTED_REPLY.log(mIRLogger, new Object[0]);
        }
        catch (Exception exception) {
            MIMB.GENERAL_ERROR.log(mIRLogger, exception, exception.getMessage());
        }
        catch (Throwable throwable) {
            MIMB.TOOL_UNEXPECTED_ERROR.log(mIRLogger, throwable, "MIMB");
        }
        finally {
            ((LogEventHandler)object).close();
            ((PrintStream)object2).close();
            if (troubleshootingPackage != null) {
                troubleshootingPackage.close();
            }
        }
        System.exit(mIMBReturnCode.getCode());
    }

    public static Response executeRequest(Request request, MIRLogger mIRLogger, File file) throws MIRException {
        MIRSetup mIRSetup = MIRSetup.loadSetup((File)file);
        MimbEnv mimbEnv = new MimbEnv(mIRSetup, mIRLogger, OEM.getEnvOemCode());
        MimbExeRequestHandler mimbExeRequestHandler = new MimbExeRequestHandler(mimbEnv, request);
        MimbExecutable.executeRequest(mimbEnv, mimbExeRequestHandler);
        return (Response)mimbExeRequestHandler.getResponse();
    }

    @Deprecated
    public static Response executeRequest(Request request, MIRLogger mIRLogger, File file, String string) throws MIRException {
        MIRSetup mIRSetup = MIRSetup.loadSetup((File)file);
        MimbEnv mimbEnv = new MimbEnv(mIRSetup, mIRLogger, OEM.getOemCode(string));
        MimbExeRequestHandler mimbExeRequestHandler = new MimbExeRequestHandler(mimbEnv, request);
        MimbExecutable.executeRequest(mimbEnv, mimbExeRequestHandler);
        return (Response)mimbExeRequestHandler.getResponse();
    }

    public static MimbResponse executeRequest(MimbRequest mimbRequest, MIRLogger mIRLogger, File file, String string) throws MIRException {
        MIRSetup mIRSetup = MIRSetup.loadSetup((File)file);
        MimbEnv mimbEnv = new MimbEnv(mIRSetup, mIRLogger, OEM.getOemCode(string));
        DriverRequestHandler driverRequestHandler = new DriverRequestHandler(mimbEnv, mimbRequest);
        MimbExecutable.executeRequest(mimbEnv, driverRequestHandler);
        return (MimbResponse)driverRequestHandler.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeRequest(MimbEnv mimbEnv, RequestHandler<?, ?> requestHandler) throws MIRException {
        String string = requestHandler.getLanguage();
        if (string != null && !string.isEmpty()) {
            MitiLocale.setLocale(string);
        }
        List<Action> list = requestHandler.generateActions();
        try {
            MimbExecutable.executeRequest(mimbEnv, requestHandler, list);
        }
        catch (MIRException mIRException) {
            if (requestHandler.getResponse() == null) {
                requestHandler.buildResponse(MIMBReturnCode.ERROR_EXE);
            }
        }
        finally {
            Conversation.write(mimbEnv, requestHandler);
        }
    }

    private static void executeRequest(MimbEnv mimbEnv, RequestHandler<?, ?> requestHandler, List<Action> list) throws MIRException {
        VersionInfo versionInfo;
        long l = MachineInfo.getJavaProcessId();
        MIMB.MSG_PID.log(mimbEnv.getLogger(), (int)l);
        if (OEM.isDebugOem()) {
            MimbExecutable.printJavaInfo();
        }
        if ((versionInfo = VersionInfo.loadPatch(mimbEnv.getSetup().getHomeDirectory(), "MIMB-OEM")) != null) {
            MIMB.PATCH_INFO.log(mimbEnv.getLogger(), versionInfo.getComponent(), versionInfo.getVersionNumber(), versionInfo.getDate());
        }
        OsInfo osInfo = MachineInfo.getOsInfo();
        String string = String.valueOf(MachineInfo.getAvailableProcessors()) + " CPU(s)/Core(s)";
        MIMB.TOOL_USER_INFO.log(mimbEnv.getLogger(), Platform.isRunningAsService() ? "a service" : "an application", MachineInfo.getUsername());
        MIMB.TOOL_HARDWARE_INFO.log(mimbEnv.getLogger(), MachineInfo.getHardwareProcessorId(), string, MachineInfo.getHardwareMemory());
        MIMB.TOOL_SOFTWARE_INFO.log(mimbEnv.getLogger(), osInfo.getName(), osInfo.getVersion(), osInfo.getArch(), MachineInfo.getHostName(), "");
        MIMB.TOOL_ENCODING_INFO.log(mimbEnv.getLogger(), MachineInfo.getEncoding());
        MIMB.TOOL_DATA_DIRECTORY.log(mimbEnv.getLogger(), mimbEnv.getSetup().getDataDirectory().getAbsolutePath());
        MIMB.DBG_MIMB_VALIDATING_REQUEST.log(mimbEnv.getLogger(), new Object[0]);
        if (!MimbExecutable.validateActions(list)) {
            requestHandler.buildResponse(MIMBReturnCode.ERROR_USAGE);
            return;
        }
        MIMB.DBG_MIMB_CHECKING_LICENSE.log(mimbEnv.getLogger(), new Object[0]);
        if (!MimbExecutable.checkLicenseKey(mimbEnv, list)) {
            requestHandler.buildResponse(MIMBReturnCode.ERROR_LICENSE);
            return;
        }
        MIMB.DBG_MIMB_IS_READY_TO_EXECUTE.log(mimbEnv.getLogger(), new Object[0]);
        File file = null;
        Action action = null;
        for (Action action2 : list) {
            if (action2 instanceof BridgeAction && mimbEnv.getTroubleshootingPackage() != null) {
                mimbEnv.getTroubleshootingPackage().addBridgeId(((BridgeAction)action2).getBridgeId());
            }
            if (action2 instanceof ImportAction) {
                if (mimbEnv.getTroubleshootingPackage() != null) {
                    file = mimbEnv.getTroubleshootingPackage().getXmiFolder();
                } else if (file == null) {
                    file = MIRBridgeLib.makeTempDir((File)mimbEnv.getSetup().getTempDirectory(), (String)((ImportAction)action2).getBridgeId());
                    MIMB.DBG_CREATED_TMP_DIR.log(file.getPath());
                }
                action2.setDirectory(file);
            } else if (action != null) {
                action2.setDirectory(action.getDirectory());
                action2.setMiscParams(action.getMiscParams());
            }
            boolean bl = action2.execute();
            if (!bl) break;
            action = action2;
        }
        MIMB.DBG_MIMB_EXECUTED.log(mimbEnv.getLogger(), new Object[0]);
        JavaBridge.printVersionInfos((MIRLogger)mimbEnv.getLogger());
        if (mimbEnv.getTroubleshootingPackage() == null && file != null && file.exists()) {
            if (MitiDebug.getFlag(MitiDebug.Flag.KEEP_TEMP_FILES)) {
                MIMB.WRN_KEPT_TEMP_EXPORT_FILES.log(mimbEnv.getLogger(), file.getPath());
            } else {
                MIMB.DBG_REMOVING_TMP_DIR.log(mimbEnv.getLogger(), file.getPath());
                FileUtil.delete(file);
            }
        }
    }

    private static Request decodeCommandLineRequest() {
        MimbOptions mimbOptions;
        BridgeRunRequest bridgeRunRequest;
        String string = "";
        String string2 = "";
        if ("list".equals(importBridgeOption.getStringValue())) {
            GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
            getBridgeListRequest.setIsExport(false);
            getBridgeListRequest.setWithSpecification(false);
            getBridgeListRequest.setUserIdentity(string);
            getBridgeListRequest.setLanguage(string2);
            return getBridgeListRequest;
        }
        if (importBridgeOption.isSet() && "specs".equals(importPathOption.getStringValue())) {
            GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
            getBridgeInformationRequest.setBridgeId(importBridgeOption.getStringValue());
            getBridgeInformationRequest.setBridgeDisplayName("");
            getBridgeInformationRequest.setIsExport(false);
            getBridgeInformationRequest.setUserIdentity(string);
            getBridgeInformationRequest.setLanguage(string2);
            return getBridgeInformationRequest;
        }
        if ("list".equals(exportBridgeOption.getStringValue())) {
            GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
            getBridgeListRequest.setIsExport(true);
            getBridgeListRequest.setWithSpecification(false);
            getBridgeListRequest.setUserIdentity(string);
            getBridgeListRequest.setLanguage(string2);
            return getBridgeListRequest;
        }
        if (exportBridgeOption.isSet() && "specs".equals(exportPathOption.getStringValue())) {
            GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
            getBridgeInformationRequest.setBridgeId(exportBridgeOption.getStringValue());
            getBridgeInformationRequest.setBridgeDisplayName("");
            getBridgeInformationRequest.setIsExport(true);
            getBridgeInformationRequest.setUserIdentity(string);
            getBridgeInformationRequest.setLanguage(string2);
            return getBridgeInformationRequest;
        }
        RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
        runMimbExtendedRequest.setLanguage(string2);
        runMimbExtendedRequest.setLogLevel("");
        runMimbExtendedRequest.setUserIdentity(string);
        MIRValidationLevel.Enum enum_ = MIRValidationLevel.BASIC;
        if (validationOption.isSet()) {
            enum_ = MIRValidationLevel.getByName(validationOption.getStringValue());
        } else if (consistencyOption.isSet()) {
            enum_ = consistencyOption.getIntValue() == 0 ? MIRValidationLevel.NONE : (consistencyOption.getIntValue() == 2 ? MIRValidationLevel.ADVANCED : MIRValidationLevel.BASIC);
        }
        runMimbExtendedRequest.setValidationLevel(enum_);
        if (importBridgeOption.isSet()) {
            bridgeRunRequest = new BridgeRunRequest();
            bridgeRunRequest.setBridgeId(importBridgeOption.getStringValue());
            bridgeRunRequest.setBridgeDisplayName("");
            bridgeRunRequest.setDisableLog(false);
            mimbOptions = new MimbOptions();
            if (importPathOption.isSet()) {
                mimbOptions.addOption("File/Directory", importPathOption.getStringValue(), "");
            }
            for (Map.Entry<String, String> entry : MimbExecutable.getBridgeOptions(importBridgeParameterOption).entrySet()) {
                mimbOptions.addOption(entry.getKey(), entry.getValue(), "");
            }
            bridgeRunRequest.setUserOptions(mimbOptions);
            runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
        }
        if (exportBridgeOption.isSet()) {
            bridgeRunRequest = new BridgeRunRequest();
            bridgeRunRequest.setBridgeId(exportBridgeOption.getStringValue());
            bridgeRunRequest.setBridgeDisplayName("");
            bridgeRunRequest.setDisableLog(false);
            mimbOptions = new MimbOptions();
            if (exportPathOption.isSet()) {
                mimbOptions.addOption("File/Directory", exportPathOption.getStringValue(), "");
            }
            for (Map.Entry<String, String> entry : MimbExecutable.getBridgeOptions(exportBridgeParameterOption).entrySet()) {
                mimbOptions.addOption(entry.getKey(), entry.getValue(), "");
            }
            bridgeRunRequest.setUserOptions(mimbOptions);
            runMimbExtendedRequest.setExportRequest(bridgeRunRequest);
        }
        return runMimbExtendedRequest;
    }

    private static Map<String, String> getBridgeOptions(RepeatableOption repeatableOption) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : repeatableOption.getValues()) {
            int n = string.indexOf("=");
            if (n < 1) {
                throw new IllegalArgumentException(MBCM.INVALID_PARAM_FORMAT.getMessage(string));
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            linkedHashMap.put(string2, string3);
        }
        return linkedHashMap;
    }

    private static boolean checkLicenseKey(MimbEnv mimbEnv, Collection<Action> collection) {
        String string = MachineInfo.getHostId();
        MIMB.DBG_HOSTID.log(mimbEnv.getLogger(), string);
        if (mimbEnv.getLogger().getLevel() >= 6) {
            String string2 = MachineInfo.getMacAddress();
            MIMB.DBG_MAC_ADDRESS.log(mimbEnv.getLogger(), string2);
        }
        if (!OEM.isDebugOem()) {
            MIMB.OEM_CODE.log(mimbEnv.getLogger(), mimbEnv.getOemCode().toString());
        }
        int n = 0;
        File file = new File(mimbEnv.getSetup().getConfDirectory(), "mimb.lic");
        if (!LicenseKey.isValid(mimbEnv.getOemCode(), file)) {
            ++n;
        } else {
            int n2 = 0;
            int n3 = 0;
            BridgeAction bridgeAction = null;
            BridgeAction bridgeAction2 = null;
            BrowseAction browseAction = null;
            BridgeAction bridgeAction3 = null;
            for (Action action : collection) {
                String string3;
                if (action instanceof GetBridgeListAction || action instanceof GetBridgeSpecsAction || action instanceof GetBridgeInformationAction || action instanceof TestAction) continue;
                if (action instanceof ImportAction) {
                    bridgeAction = (ImportAction)action;
                    ++n2;
                    if (bridgeAction.isMIMBIntermediateStep()) continue;
                    string3 = BridgeLoader.getBridgeId((String)bridgeAction.getBridgeId());
                    if (LicenseKey.isValidBridge(mimbEnv.getOemCode(), file, string3, false)) continue;
                    ++n;
                    continue;
                }
                if (action instanceof ExportAction) {
                    bridgeAction2 = (ExportAction)action;
                    ++n3;
                    if (bridgeAction2.isMIMBIntermediateStep()) continue;
                    string3 = BridgeLoader.getBridgeId((String)bridgeAction2.getBridgeId());
                    if (LicenseKey.isValidBridge(mimbEnv.getOemCode(), file, string3, true)) continue;
                    ++n;
                    continue;
                }
                if (action instanceof BrowseAction) {
                    browseAction = (BrowseAction)action;
                    string3 = BridgeLoader.getBridgeId((String)browseAction.getBridgeId());
                    if (LicenseKey.isValidBridge(mimbEnv.getOemCode(), file, string3, browseAction.isExport())) continue;
                    ++n;
                    continue;
                }
                if (action instanceof ImportGenericOperationAction) {
                    bridgeAction3 = (BridgeAction)action;
                    if (bridgeAction3.isMIMBIntermediateStep()) continue;
                    string3 = BridgeLoader.getBridgeId((String)bridgeAction3.getBridgeId());
                    if (LicenseKey.isValidBridge(mimbEnv.getOemCode(), file, string3, false)) continue;
                    ++n;
                    continue;
                }
                if (mimbEnv.getOemCode() == OEMCode.NOT_OEM) continue;
                ++n;
            }
            if (mimbEnv.getOemCode() != OEMCode.NOT_OEM && (n2 > 0 || n3 > 0)) {
                if (n2 != 1 || n3 != 1 || bridgeAction == null || bridgeAction2 == null) {
                    ++n;
                } else if (OEM.isInternalMimb()) {
                    if (!Action.isMitiBridge(bridgeAction.getBridgeId()) && !Action.isMitiBridge(bridgeAction2.getBridgeId())) {
                        ++n;
                    }
                } else {
                    boolean bl = mimbEnv.getOemCode().isOemBridge(bridgeAction.getBridgeId(), false);
                    boolean bl2 = mimbEnv.getOemCode().isOemBridge(bridgeAction2.getBridgeId(), true);
                    if (!bl && !bl2) {
                        ++n;
                    }
                    if (bl && !mimbEnv.getOemCode().isValidBridge(((ExportAction)bridgeAction2).getBridgeSpec(), true)) {
                        ++n;
                    }
                    if (bl2 && !mimbEnv.getOemCode().isValidBridge(((ImportAction)bridgeAction).getBridgeSpec(), false)) {
                        ++n;
                    }
                }
            }
            if (!OEM.isDebugOem()) {
                if (bridgeAction != null) {
                    MIMB.TOOL_IMPORT_BRIDGE.log(mimbEnv.getLogger(), bridgeAction.getBridgeId(), "");
                }
                if (bridgeAction2 != null) {
                    MIMB.TOOL_EXPORT_BRIDGE.log(mimbEnv.getLogger(), bridgeAction2.getBridgeId(), "");
                }
            }
        }
        if (n != 0) {
            MIMB.GENERAL_ERROR.log(mimbEnv.getLogger(), MMGR.MANAGER_LICENSE_UNSPECIFIED.getText());
            return false;
        }
        return true;
    }

    private static void downloadDrivers(File file, MIRLogger mIRLogger, Boolean bl, String string, Map<String, String> map) throws MIRException {
        boolean[] blArray;
        MIRSetup mIRSetup = MIRSetup.loadSetup((File)file);
        BridgeLoader bridgeLoader = new BridgeLoader(mIRSetup.getJavaDirectory());
        BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(mIRSetup, null, MIRValidationLevel.NONE);
        MIRModelBridges mIRModelBridges = MIRModelBridges.load((File)file);
        if (bl == null) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[1];
            blArray = blArray3;
            blArray3[0] = bl == false;
        }
        for (boolean bl2 : blArray) {
            for (BridgeLibrary bridgeLibrary : string == null ? mIRModelBridges.getBridges(bl2) : Collections.singleton(mIRModelBridges.loadBridgeLibrary(string, bl2))) {
                BridgeSpecificationLiteral bridgeSpecificationLiteral = bridgeLibrary != null ? MIRModelBridges.getBridgeSpecificationLiteral((String)bridgeLibrary.getBridgeId(), (boolean)bl2) : null;
                if (bridgeSpecificationLiteral == null || bridgeSpecificationLiteral.isBridge_IsAlias() || !bridgeSpecificationLiteral.isBridge_IsDriverLiveDownloadEnabled()) continue;
                try {
                    MBCM.MSG_MAVEN_DOWNLOADING_FILE.log("drivers for " + bridgeLibrary.getBridgeId());
                    ArrayList<MimbOptions> arrayList = new ArrayList<MimbOptions>();
                    BridgeInterface bridgeInterface = bridgeLoader.loadBridge(bridgeLibrary.getBridgeId(), bl2);
                    if (bridgeInterface != null) {
                        MimbOptions object;
                        if (map != null && !map.isEmpty()) {
                            object = new MimbOptions();
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                object.addOption(entry.getKey(), entry.getValue(), "");
                            }
                            arrayList.add(object);
                        } else {
                            object = null;
                            for (Parameter parameter : bridgeInterface.getParameters()) {
                                if (!parameter.getName().toLowerCase().contains("version")) continue;
                                object = parameter;
                                break;
                            }
                            if (object != null) {
                                if (object.getType() == Parameter.Type.ENUMERATED) {
                                    for (String string2 : object.getPossibleValues().keySet()) {
                                        MimbOptions mimbOptions = new MimbOptions();
                                        mimbOptions.addOption(object.getName(), string2, "");
                                        arrayList.add(mimbOptions);
                                    }
                                } else if (!object.getDefaultValue().isEmpty()) {
                                    MimbOptions mimbOptions = new MimbOptions();
                                    mimbOptions.addOption(object.getName(), object.getDefaultValue(), "");
                                    arrayList.add(mimbOptions);
                                }
                            }
                        }
                        if (arrayList.isEmpty()) {
                            arrayList.add(new MimbOptions());
                        }
                        bridgeLoader.unloadBridge(bridgeInterface);
                    }
                    for (MimbOptions mimbOptions : arrayList) {
                        bridgeInterface = bridgeLoader.loadBridge(bridgeLibrary.getBridgeId(), bl2);
                        bridgeInterface.configureClassPath(new ClassPath(bridgeEnvironment, mIRLogger, mimbOptions), mimbOptions, bridgeEnvironment, MIRLogger.getLogger());
                        bridgeLoader.unloadBridge(bridgeInterface);
                    }
                }
                catch (MIRException mIRException) {
                    MIMB.TOOL_FAILED.log(mIRException.getMessage());
                }
            }
        }
        PomDb.build((File)mIRSetup.getDownloadDirectory());
        Object object = VersionInfo.loadMitiJar(MimbExecutable.class).getVersionString();
        String string2 = DateUtil.formatSimpleDate(System.currentTimeMillis(), false).substring(0, 10).replace("-", "");
        File file2 = new File(mIRSetup.getDownloadDirectory().getParent());
        File file3 = new File(mIRSetup.getHomeDirectory(), "MIMB-ThirdParty-Patch-" + ((String)object).replace(".", "") + "-" + string2 + ".zip");
        try {
            file3.delete();
            Zip.zip(file3, (String)object, "data", file2);
            MIMB.TOOL_DOWNLOADED_DRIVERS.log(file3.getAbsolutePath());
        }
        catch (IOException iOException) {
            MIMB.TOOL_DOWNLOADED_DRIVERS.log(file2.getAbsolutePath());
        }
    }

    public static enum MIMBReturnCode {
        SUCCESS(0, "success"),
        ERROR_EXE(1, "general error"),
        ERROR_USAGE(2, "usage error"),
        ERROR_IMPORT(3, "import error"),
        ERROR_EXPORT(4, "export error"),
        ERROR_VALIDATION(5, "validation error"),
        ERROR_SUBSET(6, "subset error"),
        ERROR_LICENSE(7, "license error"),
        ERROR_REPORT(8, "report error"),
        ERROR_TRANSFORM(9, "tranform error"),
        ERROR_BROWSE(10, "browse error"),
        ERROR_TEST(11, "test error");

        private int code;
        private String message;

        private MIMBReturnCode(int n2, String string2) {
            this.code = n2;
            this.message = string2;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

