/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.concurrent;

import MITI.MIRException;
import MITI.bridges.concurrent.Task;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.util.log.MIRLogger;
import MITI.util.os.MachineInfo;
import MITI.util.thread.SimpleThreadPool;
import java.util.Collection;

public class MIRThreadPoolManager
extends SimpleThreadPool {
    private static final int WORKER_THREADS_AUTO = -1;
    private static final int DEFAULT_PRINT_STEP = 10;
    private static final int MAX_DEFAULT_WORKERS = 6;
    private MIRLogger mainLogger;
    private long tasksCount = 0L;
    private boolean displayProgress = true;
    private int statusPrintStep = 10;
    private static boolean jvm64 = MachineInfo.is64Bits();
    private static int numCpus = MachineInfo.getAvailableProcessors();

    private static int getNumWorkerThreads(int n, boolean bl) {
        int n2 = n;
        if (n == -1) {
            n2 = bl && !jvm64 ? 1 : Math.max(1, Math.min(numCpus - 1, 6));
        }
        return n2;
    }

    private void setStatusPrintStep(Collection<? extends Task> collection) {
        if (this.statusPrintStep != 10) {
            return;
        }
        int n = collection.size();
        this.statusPrintStep = n < 200 ? 10 : (n < 500 ? 15 : (n < 1000 ? 20 : (n < 2000 ? 25 : (n < 3000 ? 30 : (n < 4000 ? 50 : 100)))));
    }

    public static int computeWorkerThreadsCount(String string, boolean bl) throws MIRException {
        int n = 0;
        boolean bl2 = false;
        if (string == null || string.isEmpty()) {
            n = -1;
        } else {
            try {
                n = Integer.parseInt(string);
                if (n < 1) {
                    bl2 = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = true;
            }
        }
        if (bl2) {
            BLIB.INVALID_WORKER_THREADS.log(string);
            n = 1;
        }
        int n2 = MIRThreadPoolManager.getNumWorkerThreads(n, bl);
        if (n == -1) {
            BLIB.AUTO_WORKER_THREADS.log(n2);
        } else {
            BLIB.NUM_WORKER_THREADS.log(n2);
        }
        return n2;
    }

    public MIRThreadPoolManager(String string, int n, MIRLogger mIRLogger) {
        super(string, n);
        this.mainLogger = mIRLogger;
    }

    public void setStatusPrintStep(int n) {
        this.statusPrintStep = n;
    }

    public void setDisplayProgress(boolean bl) {
        this.displayProgress = bl;
    }

    public void invokeTasks(Collection<? extends Task> collection) {
        try {
            this.tasksCount = collection.size();
            this.setStatusPrintStep(collection);
            this.invokeAll(collection);
        }
        catch (InterruptedException interruptedException) {
            BLIB.DBG_DEBUG.log(this.mainLogger, interruptedException, "Parallel execution was interrupted!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        boolean bl;
        super.afterExecute(runnable, throwable);
        long l = this.getCompletedTaskCount() + 1L;
        boolean bl2 = bl = l == this.tasksCount;
        if (this.displayProgress && (l % (long)this.statusPrintStep == 0L || bl)) {
            MIRLogger mIRLogger = this.mainLogger;
            synchronized (mIRLogger) {
                BLIB.STS_TASKS_PROGRESS_INDICATOR.log(this.mainLogger, String.valueOf(l), String.valueOf(this.tasksCount));
            }
        }
    }
}

