/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.concurrent;

import MITI.MIRException;
import MITI.bridges.cache.MIMBCacheResourceFile;
import MITI.bridges.concurrent.Task;
import java.io.IOException;

public abstract class DownloadTask
extends Task {
    protected MIMBCacheResourceFile nativeResource = null;
    protected long downloadTime = 0L;

    public DownloadTask() {
    }

    public DownloadTask(MIMBCacheResourceFile mIMBCacheResourceFile) {
        this.nativeResource = mIMBCacheResourceFile;
    }

    public void prepareParameters() throws MIRException {
    }

    public abstract boolean download() throws Exception;

    @Override
    public Boolean internalCall() {
        try {
            this.prepareParameters();
            this.displayStartMessage();
            long l = System.currentTimeMillis();
            this.success = this.download();
            this.downloadTime = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {
            this.exception = exception;
            this.success = false;
        }
        if (this.isSuccessful() && this.nativeResource != null) {
            try {
                this.nativeResource.setWritten();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                this.success = false;
            }
        }
        if (!this.isSuccessful()) {
            this.displayErrorMessage();
        }
        return this.success;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }
}

