/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.omr.client;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserIdentityInterface;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class OtpCallbackHandler
implements CallbackHandler {
    private ServerInterface server;
    private String userid;

    public OtpCallbackHandler(ServerInterface server) {
        this.server = server;
    }

    public OtpCallbackHandler(ServerInterface server, String userid) {
        this.server = server;
        this.userid = userid;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        try {
            UserIdentityInterface generatedIdentity = this.server.generatePassword(this.userid);
            String user = generatedIdentity.getPrincipal().toString();
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(user);
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                ((PasswordCallback)callback).setPassword(generatedIdentity.getCredential().toString().toCharArray());
            }
        }
        catch (ServiceException e) {
            throw new IOException("Error generating one-time password", e);
        }
    }
}

