/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.data.SSRDataAdapter;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.util.ImageMap;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.SILKParserFactory;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.BMPWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SilkSSR {
    public static final byte BMP = 1;
    public static final byte PNG = 2;
    Vector v = new Vector();
    private String xmlFile = "SilkGraph.xml";
    private String xmlDataFile = "SilkGraphData.xml";
    private String outFile = "SilkGraph.png";
    private String mapFile = null;
    private String styleFile = null;
    private Dimension size = new Dimension(640, 480);
    private int dpi = -1;
    private int maxobs = 0;
    private byte type = 1;
    private boolean timing = false;
    private boolean mvshost = false;
    private boolean utf8 = false;
    private Vector datamodels = null;
    private File imageFile = null;
    private FileOutputStream imageOutStream = null;
    private BufferedOutputStream imageBOS = null;
    private File imagemapFile = null;
    private FileOutputStream mapOutStream = null;
    private PrintStream mapPrintStream = null;

    public String getXmlDataFile() {
        return this.xmlDataFile;
    }

    public void setXmlDataFile(String file) {
        this.xmlDataFile = file;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String file) {
        this.xmlFile = file;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String fileName) {
        this.outFile = fileName;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public int getMaxObs() {
        return this.maxobs;
    }

    public void setMaxObs(int obs) {
        this.maxobs = obs;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getMapFile() {
        return this.mapFile;
    }

    public void setMapFile(String fileName) {
        this.mapFile = fileName;
    }

    public String getStyleFile() {
        return this.styleFile;
    }

    public void setStyleFile(String fileName) {
        this.styleFile = fileName;
    }

    public boolean getTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public boolean isMvsHost() {
        return this.mvshost;
    }

    public void setMvsHost(boolean mvshost) {
        this.mvshost = mvshost;
    }

    public int getDPI() {
        return this.dpi;
    }

    public void setDPI(int aInt) {
        this.dpi = aInt;
    }

    public boolean isUTF8() {
        return this.utf8;
    }

    public void setUTF8(boolean utf8) {
        this.utf8 = utf8;
    }

    private double getScale() {
        double mx = 1.0;
        if (this.dpi > 0) {
            mx = (double)this.dpi / 96.0;
        }
        return mx;
    }

    private boolean isScaled() {
        return this.dpi > 0;
    }

    private int getScaledWidth() {
        return (int)((double)this.size.width * this.getScale() + 0.5);
    }

    private int getScaledHeight() {
        return (int)((double)this.size.height * this.getScale() + 0.5);
    }

    public void addChartModel(SSRDataAdapter model) {
        if (model == null) {
            return;
        }
        if (this.datamodels == null) {
            this.datamodels = new Vector();
        }
        this.datamodels.addElement(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render() {
        NodeList list;
        Element HTML;
        JComponent panel;
        block43: {
            block44: {
                block41: {
                    block42: {
                        Graphics2D g = null;
                        panel = null;
                        try {
                            SILKGlobal.getInstance().setPropertyValue(56, (Object)Boolean.TRUE);
                            SILKGlobal.getInstance().setPropertyValue(54, (Object)new Double((double)this.getDPI() / 96.0));
                            SILKParserFactory.addToParserLookup((String)"ControlChartLayout", (String)"com.sas.analytics.qc.graphics.xml.parsers.ShewhartParser");
                            SILKParserFactory.addToReverseParserLookup((String)"com.sas.analytics.qc.graphics.ShewhartComponent", (String)"ControlChartLayout");
                            if (this.getStyleFile() != null) {
                                SILKParser.parse((File)new File(this.getStyleFile()));
                            }
                            Hashtable context = new Hashtable();
                            if (this.datamodels != null) {
                                for (int i = 0; i < this.datamodels.size(); ++i) {
                                    SSRDataAdapter data = (SSRDataAdapter)this.datamodels.elementAt(i);
                                    context.put(data.getName(), data.getDataModel());
                                    SILKParser.addData((Hashtable)context, (String)data.getName());
                                }
                            }
                            context = SILKParser.parse(context, (File)new File(this.getXmlDataFile()));
                            Object[] charts = SILKParser.getCharts((Hashtable)(context = SILKParser.parse((Hashtable)context, (File)new File(this.getXmlFile()))));
                            if (charts != null && charts.length > 0 && charts[0] != null && charts[0] instanceof JComponent) {
                                panel = (JComponent)charts[0];
                            }
                            if (panel == null) {
                                if (this.getMapFile() == null) break block41;
                                break block42;
                            }
                            if (panel instanceof SILKComponent) {
                                ((SILKComponent)panel).setBackBufferDrawEnabled(false);
                            }
                            panel.addNotify();
                            panel.setSize(this.size);
                            panel.invalidate();
                            panel.validate();
                            BufferedImage bi = new BufferedImage(this.size.width, this.size.height, 1);
                            g = bi.createGraphics();
                            panel.setDoubleBuffered(false);
                            panel.paint(g);
                            g.dispose();
                            this.imageFile = new File(this.outFile);
                            this.imageOutStream = new FileOutputStream(this.imageFile);
                            this.imageBOS = new BufferedOutputStream(this.imageOutStream);
                            if (this.type == 1) {
                                BMPWriter bmpWriter = new BMPWriter();
                                bmpWriter.saveBitmap(this.imageBOS, (Image)bi, this.size.width, this.size.height);
                            } else if (this.type == 2) {
                                ImageIO.setUseCache(false);
                                ImageIO.write((RenderedImage)bi, "png", this.imageBOS);
                            }
                            if (this.getMapFile() == null) break block43;
                            break block44;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e.toString());
                            return;
                        }
                    }
                    ImageMap imageMap = ImageMap.generateImageMap((Component)panel, (int)-1, (int)-1, (String)"SILK_IMAGE_MAP");
                    Element HTML2 = imageMap.getHTML();
                    if (HTML2 != null) {
                        this.imagemapFile = new File(this.mapFile);
                        try {
                            this.mapOutStream = new FileOutputStream(this.imagemapFile);
                            this.mapPrintStream = new PrintStream(this.mapOutStream);
                            NodeList list2 = HTML2.getChildNodes();
                            for (int i = 0; i < list2.getLength(); ++i) {
                                Node n = list2.item(i);
                                if (n.getNodeType() != 1) continue;
                                this.mapPrintStream.print(ParserUtils.toString((Node)n, (boolean)false));
                            }
                            this.mapPrintStream.flush();
                            this.mapPrintStream.close();
                            this.mapOutStream.close();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (panel != null && panel instanceof BaseComponentInterface) {
                    ((BaseComponentInterface)panel).dispose();
                }
                if (this.imageOutStream == null) return;
                try {
                    this.imageBOS.close();
                    this.imageOutStream.close();
                    return;
                }
                catch (IOException imageMap) {
                    // empty catch block
                }
                return;
            }
            ImageMap imageMap = ImageMap.generateImageMap((Component)panel, (int)-1, (int)-1, (String)"SILK_IMAGE_MAP");
            HTML = imageMap.getHTML();
            if (HTML != null) {
                this.imagemapFile = new File(this.mapFile);
                try {
                    this.mapOutStream = new FileOutputStream(this.imagemapFile);
                    this.mapPrintStream = new PrintStream(this.mapOutStream);
                    list = HTML.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node n = list.item(i);
                        if (n.getNodeType() != 1) continue;
                        this.mapPrintStream.print(ParserUtils.toString((Node)n, (boolean)false));
                    }
                    this.mapPrintStream.flush();
                    this.mapPrintStream.close();
                    this.mapOutStream.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (panel != null && panel instanceof BaseComponentInterface) {
            ((BaseComponentInterface)panel).dispose();
        }
        if (this.imageOutStream == null) return;
        try {
            this.imageBOS.close();
            this.imageOutStream.close();
            return;
        }
        catch (IOException imageMap) {
            return;
        }
        finally {
            if (this.getMapFile() != null && (HTML = (imageMap = ImageMap.generateImageMap(panel, (int)-1, (int)-1, (String)"SILK_IMAGE_MAP")).getHTML()) != null) {
                this.imagemapFile = new File(this.mapFile);
                try {
                    this.mapOutStream = new FileOutputStream(this.imagemapFile);
                    this.mapPrintStream = new PrintStream(this.mapOutStream);
                    list = HTML.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node n = list.item(i);
                        if (n.getNodeType() != 1) continue;
                        this.mapPrintStream.print(ParserUtils.toString((Node)n, (boolean)false));
                    }
                    this.mapPrintStream.flush();
                    this.mapPrintStream.close();
                    this.mapOutStream.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (panel != null && panel instanceof BaseComponentInterface) {
                ((BaseComponentInterface)panel).dispose();
            }
            if (this.imageOutStream != null) {
                try {
                    this.imageBOS.close();
                    this.imageOutStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void abort() {
        if (this.imageFile != null) {
            try {
                this.imageBOS.close();
                this.imageOutStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.imageFile.delete();
        }
        if (this.imagemapFile != null) {
            try {
                this.mapPrintStream.close();
                this.mapOutStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.imagemapFile.delete();
        }
    }

    public SilkSSR() {
        this(null);
    }

    public SilkSSR(String[] args) {
        if (args == null) {
            return;
        }
        this.setXmlDataFile(args[0]);
        this.setXmlFile(args[1]);
        this.setOutFile(args[2]);
        this.setSize(new Dimension(Integer.parseInt(args[3].trim()), Integer.parseInt(args[4].trim())));
        for (int i = 5; i < args.length; ++i) {
            if (args[i].equals("-timing")) {
                this.setTiming(true);
                continue;
            }
            if (args[i].equals("-mvs")) {
                this.setMvsHost(true);
                continue;
            }
            if (args[i].equals("-utf8")) {
                this.setUTF8(true);
                continue;
            }
            if (args[i].equals("-imagetype")) {
                String imagetype;
                if ((imagetype = args[++i]).equalsIgnoreCase("BMP")) {
                    this.setType((byte)1);
                    continue;
                }
                if (!imagetype.equalsIgnoreCase("PNG")) continue;
                this.setType((byte)2);
                continue;
            }
            if (args[i].equals("-style")) {
                this.setStyleFile(args[++i]);
                continue;
            }
            if (args[i].equals("-mapfile")) {
                this.setMapFile(args[++i]);
                continue;
            }
            if (!args[i].equals("-dpi")) continue;
            this.setDPI(Integer.parseInt(args[++i].trim()));
        }
    }

    public static void main(String[] args) {
        SilkSSR silkSSR = new SilkSSR(args);
        silkSSR.setXmlDataFile(args[0]);
        silkSSR.setXmlFile(args[1]);
        silkSSR.setOutFile(args[2]);
        silkSSR.getSize().setSize(new Integer(args[3].trim()), new Integer(args[4].trim()));
        for (int i = 5; i < args.length; ++i) {
            if (args[i].equals("-timing")) continue;
            if (args[i].equals("-mvs")) {
                silkSSR.setMvsHost(true);
                continue;
            }
            if (args[i].equals("-utf8")) {
                silkSSR.setUTF8(true);
                continue;
            }
            if (args[i].equals("-imagetype")) {
                String imagetype;
                if ((imagetype = args[++i]).equalsIgnoreCase("BMP")) {
                    silkSSR.setType((byte)1);
                    continue;
                }
                if (!imagetype.equalsIgnoreCase("PNG")) continue;
                silkSSR.setType((byte)2);
                continue;
            }
            if (args[i].equals("-mapfile")) {
                silkSSR.setMapFile(args[++i]);
                continue;
            }
            if (args[i].equals("-dpi")) {
                silkSSR.setDPI(Integer.parseInt(args[++i].trim()));
                continue;
            }
            if (!args[i].equals("-style")) continue;
            silkSSR.setStyleFile(args[++i]);
        }
        try {
            silkSSR.render();
        }
        catch (OutOfMemoryError ome) {
            silkSSR.abort();
        }
    }
}

