/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;

public class ParserFilterInputStream {
    private static Object lock = new byte[0];
    private static Boolean parserIsBroken;

    private ParserFilterInputStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream filter(InputStream stream) throws IOException {
        Object object = lock;
        synchronized (object) {
            if (parserIsBroken == null) {
                ParserFilterInputStream.analyzeParser();
            }
        }
        if (parserIsBroken.booleanValue()) {
            stream = new BOMFilterInputStream(stream);
        }
        return stream;
    }

    private static void analyzeParser() {
        try {
            String XML_TEXT_WITH_BOM = "\ufeff<?xml version=\"1.0\"?><xml/>";
            byte[] bytes = XML_TEXT_WITH_BOM.getBytes("UTF-8");
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            parserIsBroken = Boolean.FALSE;
        }
        catch (Exception e) {
            parserIsBroken = Boolean.TRUE;
        }
    }

    static class BOMFilterInputStream
    extends FilterInputStream {
        private static byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
        private static final int BOM_NUM_BYTES = UTF_8_BOM.length;

        BOMFilterInputStream(InputStream in) throws IOException {
            super(BOMFilterInputStream.markableInputStream(in));
            this.skipUTF8BOM();
        }

        private static InputStream markableInputStream(InputStream in) {
            if (!in.markSupported()) {
                in = new PushbackInputStream(in, BOM_NUM_BYTES);
            }
            return in;
        }

        private void skipUTF8BOM() throws IOException {
            this.in.mark(BOM_NUM_BYTES);
            byte[] bom = new byte[UTF_8_BOM.length];
            int nBytes = this.in.read(bom, 0, bom.length);
            if (nBytes != BOM_NUM_BYTES || !Arrays.equals(bom, UTF_8_BOM)) {
                this.in.reset();
            }
        }
    }
}

