/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.applets.ContourAppletComponent;
import com.sas.graphics.applets.GraphAppletComponent;
import com.sas.graphics.applets.MapAppComponent;
import com.sas.graphics.util.BMPWriter;
import com.sas.graphics.util.ods.xml.XmlContourHandler;
import com.sas.graphics.util.ods.xml.XmlHandler;
import com.sas.graphics.util.ods.xml.XmlHandlerInterface;
import com.sas.graphics.util.ods.xml.XmlParseHandler;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class GraphSSR {
    public static final int BMP = 1;
    public static final int GRAPH = 1;
    public static final int MAP = 2;
    public static final int CONTOUR = 3;
    private Dimension size = new Dimension(640, 480);
    private String xmlFile = "chart.xml";
    private String outFile = "chart.bmp";
    private String mapFile = null;
    private int type = 1;
    private int chartType = 1;
    private boolean utf8 = false;
    private boolean mvshost = false;
    protected ResourceBundle appRB = null;
    protected Locale locale = Locale.getDefault();
    private BufferedImage image;
    private ServerInterface server = null;
    private Frame frame = null;
    private Graphics g = null;
    private boolean showOSM = false;
    private boolean OSMAutoProject = false;
    private String OSMTileset = "";

    public GraphSSR() {
        this.UpdateResourceBundle(this.locale);
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String file) {
        this.xmlFile = file;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String file) {
        this.outFile = file;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isMvsHost() {
        return this.mvshost;
    }

    public void setMvsHost(boolean mvshost) {
        this.mvshost = mvshost;
    }

    public boolean isUTF8() {
        return this.utf8;
    }

    public void setUTF8(boolean b) {
        this.utf8 = b;
    }

    public String getMapFile() {
        return this.mapFile;
    }

    public void setMapFile(String fileName) {
        this.mapFile = fileName;
    }

    public boolean isShowOSM() {
        return this.showOSM;
    }

    public void setShowOSM(boolean b) {
        this.showOSM = b;
    }

    public boolean isOSMAutoProject() {
        return this.OSMAutoProject;
    }

    public void setOSMAutoProject(boolean b) {
        this.OSMAutoProject = b;
    }

    private void setLocale(Locale loc) {
        this.locale = loc;
        this.UpdateResourceBundle(loc);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getOSMTileset() {
        return this.OSMTileset;
    }

    public void setOSMTileset(String oSMTileset) {
        this.OSMTileset = oSMTileset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        this.image = new BufferedImage(this.size.width, this.size.height, 1);
        this.g = this.image.createGraphics();
        this.g.setClip(0, 0, this.size.width, this.size.height);
        try {
            if (this.getChartType() == 1) {
                this.server = new GraphServer();
            } else if (this.getChartType() == 2) {
                this.server = new MapServer();
            } else if (this.getChartType() == 3) {
                this.server = new ContourServer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.server == null) {
            return;
        }
        this.server.start(this.g);
        this.server.paint(this.g);
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(this.getOutFile());
            this.encode(outStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.g.dispose();
        this.server = null;
        this.g = null;
        this.image = null;
    }

    public void parse(XmlHandlerInterface handler) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        spf.setNamespaceAware(false);
        XmlParseHandler documentHandler = null;
        try {
            spf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SAXParser parser = spf.newSAXParser();
            ParserAdapter pa = new ParserAdapter(parser.getParser());
            documentHandler = new XmlParseHandler(handler);
            pa.setContentHandler((ContentHandler)documentHandler);
            parser.parse(new InputSource(new FileInputStream(this.getXmlFile())), (DefaultHandler)documentHandler);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        handler = null;
    }

    public void encode(OutputStream out) {
        if (this.getType() == 1) {
            BMPWriter bmpWriter = new BMPWriter();
            bmpWriter.saveBitmap(this.getOutFile(), (Image)this.image, this.image.getWidth(null), this.image.getHeight(null));
        }
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    private void UpdateResourceBundle(Locale loc) {
        try {
            this.appRB = loc != null ? ResourceBundle.getBundle("xmlssr", loc) : ResourceBundle.getBundle("xmlssr");
        }
        catch (MissingResourceException e) {
            this.appRB = null;
        }
    }

    public static void main(String[] args) {
        String language = null;
        String country = null;
        if (args.length < 4) {
            return;
        }
        GraphSSR graphSSR = new GraphSSR();
        graphSSR.setXmlFile(args[0]);
        graphSSR.setOutFile(args[1]);
        graphSSR.setSize(new Dimension(new Integer(args[2].trim()), new Integer(args[3].trim())));
        for (int i = 4; i < args.length; ++i) {
            if (args[i].equals("-utf8")) {
                graphSSR.setUTF8(true);
                continue;
            }
            if (args[i].equals("-mvs")) {
                graphSSR.setMvsHost(true);
                continue;
            }
            if (args[i].equals("-mapfile")) {
                graphSSR.setMapFile(args[++i]);
                continue;
            }
            if (args[i].equals("-showOSM")) {
                graphSSR.setShowOSM(true);
                graphSSR.setOSMTileset(args[++i]);
                continue;
            }
            if (args[i].equals("-OSMAutoProject")) {
                graphSSR.setOSMAutoProject(true);
                continue;
            }
            if (args[i].equals("-langid")) {
                language = args[++i];
                continue;
            }
            if (args[i].equals("-locid")) {
                country = args[++i];
                continue;
            }
            graphSSR.setChartType(new Integer(args[i].trim()));
        }
        try {
            if (language != null) {
                if (country != null) {
                    graphSSR.setLocale(new Locale(language, country));
                } else {
                    graphSSR.setLocale(new Locale(language));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            graphSSR.setLocale(Locale.getDefault());
        }
        graphSSR.render();
    }

    class MapServer
    implements ServerInterface {
        MapAppComponent map = new MapAppComponent();

        MapServer() {
        }

        @Override
        public void start(Graphics g) {
            RepaintManager repaintManager = RepaintManager.currentManager((JComponent)this.map);
            repaintManager.setDoubleBufferingEnabled(false);
            this.map.asApplication = true;
            this.map.setMapFile(GraphSSR.this.getMapFile());
            this.map.setSize(((GraphSSR)GraphSSR.this).size.width, ((GraphSSR)GraphSSR.this).size.height);
            this.map.setLocale(GraphSSR.this.getLocale());
            this.map.setAutoProject(GraphSSR.this.OSMAutoProject);
            this.map.setShowOSM(GraphSSR.this.showOSM);
            this.map.setOSMTileset(GraphSSR.this.OSMTileset);
            this.map.setBatchMode(true);
            this.map.init();
            this.map.SetHoldDisplay(true);
            this.map.start();
            XmlHandler handler = new XmlHandler((Object)this.map);
            GraphSSR.this.parse((XmlHandlerInterface)handler);
            this.map.SetHoldDisplay(false);
        }

        @Override
        public void paint(Graphics g) {
            this.map.ssrpaint(g);
        }
    }

    class GraphServer
    implements ServerInterface {
        GraphAppletComponent graph = new GraphAppletComponent();

        GraphServer() {
        }

        @Override
        public void start(Graphics g) {
            this.graph.asApplication = true;
            RepaintManager repaintManager = RepaintManager.currentManager((JComponent)this.graph);
            repaintManager.setDoubleBufferingEnabled(false);
            this.graph.setGraphics(g);
            this.graph.setMapFile(GraphSSR.this.getMapFile());
            this.graph.setSize(((GraphSSR)GraphSSR.this).size.width, ((GraphSSR)GraphSSR.this).size.height);
            this.graph.setLocale(GraphSSR.this.getLocale());
            this.graph.init();
            this.graph.SetHoldDisplay(true);
            this.graph.start();
            XmlHandler handler = new XmlHandler((Object)this.graph);
            GraphSSR.this.parse((XmlHandlerInterface)handler);
            this.graph.SetHoldDisplay(false);
        }

        @Override
        public void paint(Graphics g) {
            this.graph.paint(g);
        }
    }

    class ContourServer
    implements ServerInterface {
        ContourAppletComponent contour = new ContourAppletComponent();

        ContourServer() {
        }

        @Override
        public void start(Graphics g) {
            this.contour.asApplication = true;
            RepaintManager repaintManager = RepaintManager.currentManager((JComponent)this.contour);
            repaintManager.setDoubleBufferingEnabled(false);
            this.contour.setSize(((GraphSSR)GraphSSR.this).size.width, ((GraphSSR)GraphSSR.this).size.height);
            this.contour.setLocale(GraphSSR.this.getLocale());
            this.contour.init();
            this.contour.setGraphics(g);
            this.contour.SetHoldDisplay(true);
            XmlContourHandler handler = new XmlContourHandler((Object)this.contour);
            GraphSSR.this.parse((XmlHandlerInterface)handler);
            this.contour.SetHoldDisplay(false);
        }

        @Override
        public void paint(Graphics g) {
            this.contour.paint(g);
        }
    }

    public static interface ServerInterface {
        public void start(Graphics var1);

        public void paint(Graphics var1);
    }
}

