/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GTMLStreamSSR {
    private StatGraphPanel panel = null;
    private String gtmlString = null;
    private BufferedImage bi = null;
    private boolean outputImagemap = true;

    public GTMLStreamSSR(String gtmlString, BufferedImage bi) {
        this(gtmlString, bi, true);
    }

    public GTMLStreamSSR(String gtmlString, BufferedImage bi, boolean imagemap) {
        if (gtmlString == null || bi == null) {
            throw new IllegalArgumentException("GTML String and BufferedImage may not be null.");
        }
        this.gtmlString = gtmlString;
        this.bi = bi;
        this.outputImagemap = imagemap;
        this.panel = new StatGraphPanel();
        this.panel.setServer(true);
        this.panel.separateData = true;
        StatGraph cfr_ignored_0 = this.panel.graph;
        StatGraph.systemLocale = Locale.getDefault();
    }

    public DataModel addChartModel(String name) {
        DataModel chartModel = new DataModel();
        chartModel.name = name;
        this.panel.addData(chartModel);
        return chartModel;
    }

    public void addChartModel(DataModel model) {
        this.panel.addData(model);
    }

    public String render() {
        ArrayList maps;
        String imagemapString = null;
        RepaintManager repaintM = RepaintManager.currentManager((JComponent)this.panel);
        boolean doubleBufferingEnabled = repaintM.isDoubleBufferingEnabled();
        repaintM.setDoubleBufferingEnabled(false);
        Document doc = this.createGTMLDOM();
        if (doc == null) {
            return null;
        }
        StatGraph cfr_ignored_0 = this.panel.graph;
        StatGraph.sessionLocale = StatGraph.getSessionLocale((Document)doc);
        StatGraph.setSessionLocale();
        this.panel.addNotify();
        int width = this.bi.getWidth();
        int height = this.bi.getHeight();
        this.panel.setSize(new Dimension(width, height));
        this.panel.load(doc);
        doc = null;
        this.panel.invalidate();
        this.panel.validate();
        if (StatGraph.textWrapped) {
            if (this.panel.getComponent(0) instanceof TrellisPlot) {
                this.panel.getComponent(0).invalidate();
            }
            this.panel.invalidate();
            this.panel.validate();
        }
        Graphics2D g = this.bi.createGraphics();
        this.panel.paint((Graphics)g);
        g.dispose();
        if (this.outputImagemap && this.panel.graph.isImagemapEnabled() && (maps = this.panel.getImageMap()).size() > 0) {
            imagemapString = this.writeImageMap(maps);
        }
        this.gtmlString = null;
        this.bi = null;
        StatGraph.setSystemLocale();
        repaintM.setDoubleBufferingEnabled(doubleBufferingEnabled);
        return imagemapString;
    }

    private Document createGTMLDOM() {
        if (this.gtmlString.length() == 0) {
            return null;
        }
        DocumentBuilder parser = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            parser = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            System.out.println("pce=" + pce);
            return null;
        }
        Document document = null;
        try {
            StringReader fis = new StringReader(this.gtmlString);
            InputSource src = new InputSource(fis);
            document = parser.parse(src);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return document;
    }

    private String writeImageMap(ArrayList maps) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int cnt = 0; cnt < maps.size(); ++cnt) {
                ImageMap imageMap = (ImageMap)maps.get(cnt);
                if (imageMap == null) continue;
                ImageMap.Region[] regions = imageMap.getRegions();
                for (int i = 0; i < regions.length; ++i) {
                    sb.append("<Area shape=\"poly\" ");
                    sb.append("alt=\"" + regions[i].getALT() + "\" ");
                    sb.append("title=\"" + regions[i].getALT() + "\" ");
                    if (regions[i].getHREF() != null) {
                        sb.append("href=\"" + regions[i].getHREF() + "\" ");
                        sb.append("target=\"_BLANK\" ");
                    }
                    sb.append("coords=\"");
                    Shape shape = regions[i].getCoords();
                    if (shape instanceof Polygon) {
                        Polygon polygon = (Polygon)shape;
                        for (int j = 0; j < polygon.npoints; ++j) {
                            sb.append(polygon.xpoints[j] + "," + polygon.ypoints[j]);
                            if (j > polygon.npoints) continue;
                            sb.append(",");
                        }
                    }
                    sb.append("\"");
                    sb.append("/>");
                    sb.append("\n");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

