/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BirdGTMLResolver {
    private Boolean _dataFileSet = false;
    private HashMap _hashMap;
    private Document _document;
    private int _dpi = -1;
    private static String[] _charts = new String[]{"LayoutDataMatrix", "BarChartParm", "LineChart", "BubblePlot", "KPIParm", "PieChart", "PieChartParm", "ScatterPlot", "TimeSeriesPlot", "TreeMap", "BarChart", "WaterfallChart"};
    private static String[] _roles = new String[]{"x", "y", "group", "responseVars", "rowVars", "columnVars", "target", "size", "tileBy", "colorResponse", "category", "response", "time", "value"};

    public BirdGTMLResolver(Document document) throws Exception {
        this(document, false, -1);
    }

    public BirdGTMLResolver(Document document, Boolean dataFileSet, int dpi) throws Exception {
        this._document = document;
        this._dataFileSet = dataFileSet;
        this._dpi = dpi;
        this._hashMap = new HashMap();
    }

    private double getScalingFactor() {
        double mx = 1.0;
        if (this._dpi > 0) {
            mx = (double)this._dpi / 96.0;
        }
        return mx;
    }

    public String getResolvedGTML() {
        if (this._document == null) {
            return null;
        }
        ByteArrayOutputStream gtmlBos = new ByteArrayOutputStream();
        NodeList dynVarNodeList = this._document.getElementsByTagName("DynVar");
        for (int i = 0; i < dynVarNodeList.getLength(); ++i) {
            NodeList valueNodeList;
            Element dynVarElement = (Element)dynVarNodeList.item(i);
            if (dynVarElement.getAttribute("name") == null || (valueNodeList = dynVarElement.getElementsByTagName("Value")).getLength() <= 0) continue;
            this._hashMap.put(dynVarElement.getAttribute("name"), valueNodeList);
        }
        for (String chart : _charts) {
            this.resolveXml(this._document, chart, _roles);
        }
        Element metaElement = (Element)this._document.getElementsByTagName("Meta").item(0);
        if (metaElement != null) {
            metaElement.getParentNode().removeChild(metaElement);
        }
        Element statGraphElement = (Element)this._document.getElementsByTagName("StatGraph").item(0);
        statGraphElement.setAttribute("style:style", "StatGraphStyle");
        statGraphElement.setAttribute("gapScalingFactor", "" + this.getScalingFactor());
        statGraphElement.setAttribute("dataDPIScalingFactor", "" + this.getScalingFactor());
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(statGraphElement), new StreamResult(gtmlBos));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        int index = gtmlBos.toString().indexOf("<StatGraph");
        return gtmlBos.toString().substring(index);
    }

    private void resolveXml(Document document, String chart, String[] roleList) {
        NodeList nl = document.getElementsByTagName(chart);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element = (Element)nl.item(i);
            for (String role : roleList) {
                if ("".equals(element.getAttribute(role))) continue;
                Object obj = this._hashMap.get(element.getAttribute(role));
                if (obj == null) {
                    element.setAttribute(role, "");
                    continue;
                }
                if (obj instanceof String) {
                    element.setAttribute(role, this.getResolvedValue((String)obj));
                    continue;
                }
                if (!(obj instanceof NodeList)) continue;
                NodeList valueNodeList = (NodeList)obj;
                if (valueNodeList.getLength() > 1 || role.equalsIgnoreCase("responseVars") || role.equalsIgnoreCase("rowVars") || role.equalsIgnoreCase("columnVars")) {
                    String varsTag = role.equalsIgnoreCase("columnVars") ? "ColumnVars" : (role.equalsIgnoreCase("rowVars") ? "RowVars" : "ResponseVars");
                    Element responseVarsElement = element.getOwnerDocument().createElement(varsTag);
                    element.appendChild(responseVarsElement);
                    for (int j = 0; j < valueNodeList.getLength(); ++j) {
                        Element valueElement = responseVarsElement.getOwnerDocument().createElement("Value");
                        valueElement.setTextContent(this.getResolvedValue(valueNodeList.item(j).getTextContent()));
                        responseVarsElement.appendChild(valueElement);
                    }
                    element.removeAttribute(role);
                    continue;
                }
                element.setAttribute(role, this.getResolvedValue(valueNodeList.item(0).getTextContent()));
            }
        }
    }

    private String getResolvedValue(String value) {
        String newValue = value.replace(".", "#");
        if (this._dataFileSet.booleanValue()) {
            return newValue;
        }
        return "statgraphdata1" + newValue.substring(newValue.indexOf("#"));
    }
}

