/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.app.StatGraphSSR;
import com.sas.graphics.applets.statgraph.StatGraph;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class AccessibilitySSR {
    private String htmlFile = null;
    private String baseImageName = null;
    private String imageType = "PNG";
    private String width = "640";
    private String height = "480";
    private String dpi = "-1";
    private String backupStyleName = "HTMLBLUE";
    private String extension = null;
    private boolean debug = false;
    private String encoding = "UTF-8";
    private String styleFile = null;

    public AccessibilitySSR(String[] args) {
        if (args.length < 1) {
            System.out.println("Needs at least the path to the html file!");
            return;
        }
        this.htmlFile = args[0];
        for (int i = 1; i < args.length; ++i) {
            String str;
            if (args[i].equals("-basename")) {
                this.baseImageName = args[++i];
                continue;
            }
            if (args[i].equals("-type")) {
                this.imageType = args[++i].toUpperCase();
                if (this.imageType.equals("PNG") || this.imageType.equals("BMP") || this.imageType.equals("SVG")) continue;
                System.out.println("Invalid type: " + this.imageType);
                this.imageType = "PNG";
                continue;
            }
            if (args[i].equals("-ext")) {
                this.extension = args[++i];
                continue;
            }
            if (args[i].equals("-width")) {
                if (StatGraph.isNumber((String)(str = args[++i].trim()))) {
                    this.width = str;
                    continue;
                }
                System.out.println("Invalid width: " + str);
                continue;
            }
            if (args[i].equals("-height")) {
                if (StatGraph.isNumber((String)(str = args[++i].trim()))) {
                    this.height = str;
                    continue;
                }
                System.out.println("Invalid height: " + str);
                continue;
            }
            if (args[i].equals("-dpi")) {
                if (StatGraph.isNumber((String)(str = args[++i].trim()))) {
                    this.dpi = str;
                    continue;
                }
                System.out.println("Invalid DPI: " + str);
                continue;
            }
            if (args[i].equals("-styleName") || args[i].equals("-style")) {
                this.backupStyleName = args[++i].trim().toUpperCase();
                continue;
            }
            if (args[i].equals("-styleFile")) {
                this.styleFile = args[++i].trim();
                continue;
            }
            if (args[i].equals("-encoding")) {
                this.encoding = args[++i].trim();
                continue;
            }
            if (args[i].equals("-debug")) {
                this.debug = true;
                continue;
            }
            System.out.println("Invalid option: " + args[i]);
        }
    }

    public void render() {
        if (this.htmlFile == null) {
            return;
        }
        InputStreamReader isr = null;
        String directoryName = null;
        String fileName = null;
        try {
            FileInputStream fis = new FileInputStream(this.htmlFile);
            isr = new InputStreamReader((InputStream)fis, this.encoding);
            File file = new File(this.htmlFile);
            directoryName = file.getParent();
            fileName = file.getName().toUpperCase();
            if (fileName.endsWith(".HTML")) {
                fileName = fileName.replaceAll(".HTML", "");
            } else if (fileName.endsWith(".HTM")) {
                fileName = fileName.replaceAll(".HTM", "");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getLocalizedMessage());
            return;
        }
        catch (UnsupportedEncodingException use) {
            System.out.println(use.getLocalizedMessage());
            return;
        }
        BufferedReader br = new BufferedReader(isr);
        String oneLine = null;
        boolean readingSASReport = false;
        int graphCount = 0;
        String ext = this.extension == null ? this.imageType.toLowerCase() : this.extension;
        OutputStreamWriter osr = null;
        String dataXML = this.htmlFile + "_data.xml";
        String viewXML = this.htmlFile + "_view.xml";
        String xmlTag = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        try {
            while ((oneLine = br.readLine()) != null) {
                FileOutputStream fos;
                if ((oneLine = oneLine.trim()).startsWith("<?xml version=")) {
                    xmlTag = oneLine;
                }
                if (oneLine.startsWith("<SASReport ")) {
                    readingSASReport = true;
                    fos = new FileOutputStream(dataXML);
                    osr = new OutputStreamWriter((OutputStream)fos, this.encoding);
                    osr.write(xmlTag + "\n");
                }
                if (!readingSASReport) continue;
                if (this.debug) {
                    System.out.println(oneLine);
                }
                osr.write(oneLine + "\n");
                if (oneLine.equals("</Data>")) {
                    osr.write("</SASReport>\n");
                    osr.close();
                    fos = new FileOutputStream(viewXML);
                    osr = new OutputStreamWriter((OutputStream)fos, this.encoding);
                    osr.write(xmlTag + "\n");
                    osr.write("<SASReport>\n");
                    if (this.styleFile != null) {
                        FileInputStream sfis = new FileInputStream(this.styleFile);
                        InputStreamReader style_isr = new InputStreamReader((InputStream)sfis, this.encoding);
                        BufferedReader style_br = new BufferedReader(style_isr);
                        String styleLine = null;
                        while ((styleLine = style_br.readLine()) != null) {
                            osr.write(styleLine + "\n");
                        }
                        style_isr.close();
                    }
                }
                if (!oneLine.equalsIgnoreCase("</SASReport>")) continue;
                osr.close();
                readingSASReport = false;
                String outputFileName = directoryName != null ? directoryName + File.separator : "";
                String finalBaseImageName = this.baseImageName;
                if (this.baseImageName != null && ext.equalsIgnoreCase("grf")) {
                    finalBaseImageName = this.baseImageName.substring(0, 1) + this.baseImageName.substring(3, 7);
                }
                String string = outputFileName = finalBaseImageName == null ? outputFileName + fileName : outputFileName + finalBaseImageName;
                if (graphCount > 0) {
                    outputFileName = outputFileName + graphCount;
                }
                outputFileName = outputFileName + "." + ext;
                if (this.debug) {
                    System.out.println("Output file: " + outputFileName);
                }
                String modifiedType = this.imageType.equals("SVG") ? "VGF" : this.imageType;
                String[] ssrArgs = this.styleFile == null ? new String[]{viewXML, outputFileName, this.width, this.height, "-imagetype", modifiedType, "-dpi", this.dpi, "-datafile", dataXML, "-backupstyle", this.backupStyleName} : new String[]{viewXML, outputFileName, this.width, this.height, "-imagetype", modifiedType, "-dpi", this.dpi, "-datafile", dataXML};
                StatGraphSSR ssr = new StatGraphSSR(ssrArgs);
                ssr.render();
                ++graphCount;
            }
            br.close();
            isr.close();
            if (!this.debug) {
                new File(dataXML).delete();
                new File(viewXML).delete();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getLocalizedMessage());
            return;
        }
    }
}

