/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.encoder.compression.BitBuffer;
import com.sas.visuals.image.encoder.compression.KeyEntry;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

@SASScope(value="ALL")
public class LZWCScheme {
    protected final int maxUnitSize;
    protected final int maxSubBlockSize;
    protected byte[] inBytes;
    protected OutputStream oStrm;
    protected byte[] compressedBytes;
    protected BitBuffer outBuf;
    protected long optionFlags;
    protected int symbolSize;
    protected int unitSize;
    protected int unitSizeCapacity;
    protected Hashtable symbolStringHashTable;
    protected KeyEntry testKey;
    protected short curPrefix;
    protected short curCode;
    protected short clearCode;
    protected short endCode;
    protected boolean foundWasLast;

    public LZWCScheme(byte[] iBytes, OutputStream os, int iSymbolSize, int iMaxCodeSize, int iMaxSubBlockSize) {
        this.inBytes = iBytes;
        this.oStrm = os;
        int padBytes = (iMaxCodeSize + 7) / 8;
        this.maxUnitSize = iMaxCodeSize;
        this.maxSubBlockSize = iMaxSubBlockSize;
        this.compressedBytes = new byte[this.maxSubBlockSize + padBytes];
        this.symbolSize = iSymbolSize;
        this.clearCode = (short)(1 << this.symbolSize);
        this.endCode = (short)(this.clearCode + 1);
        this.outBuf = new BitBuffer(this.compressedBytes);
        this.setUnit(this.symbolSize + 1);
    }

    protected void setUnit(int curSize) {
        this.unitSize = curSize;
        this.unitSizeCapacity = 1 << this.unitSize;
        this.outBuf.setUnitSize(this.unitSize);
        if (Debug.debug) {
            Debug.println("setUnit size=" + curSize);
        }
    }

    public void finalizer() {
    }

    public void compress() throws IOException {
        int numInputBytes = this.inBytes.length;
        this.initSymbolStringHashTable();
        this.curPrefix = (short)-1;
        this.testKey = new KeyEntry(0, 0);
        try {
            this.outBuf.writeUnit(this.clearCode);
        }
        catch (EOFException e) {
            throw new IOException("Buffer already full at initial write");
        }
        for (int i = 0; i < numInputBytes; ++i) {
            this.processSymbol(this.inBytes[i]);
        }
        this.outputEndCode();
        this.writeBufferToStream();
        if (this.outBuf.getByteOffset() > 0 || this.outBuf.getBitOffset() > 0) {
            if (Debug.debug) {
                Debug.println("LZWCScheme.compress():Last writeBufferToStream not enough!!");
            }
            this.writeBufferToStream();
        }
        this.oStrm.write(0);
        this.outBuf = null;
    }

    protected void writeBufferToStream() throws IOException {
        int bufWriteLength = this.outBuf.getByteOffset() + 1;
        int outLength = bufWriteLength < this.maxSubBlockSize ? bufWriteLength : this.maxSubBlockSize;
        this.oStrm.write(outLength);
        this.oStrm.write(this.compressedBytes, 0, outLength);
        this.outBuf.shiftToBegin(outLength);
    }

    void writeValue(int val) throws IOException {
        try {
            this.outBuf.writeUnit(val);
        }
        catch (EOFException e) {
            if (Debug.debug) {
                Debug.print("LZWCScheme.processSymbol(): EOB Exception! ");
            }
            this.writeBufferToStream();
            try {
                this.outBuf.writeUnit(val);
            }
            catch (EOFException e1) {
                throw new IOException("EOB Exception: Buffer already cleared!");
            }
        }
    }

    protected void processSymbol(byte sym) throws IOException {
        Short tmpVal = null;
        this.testKey.setValue(this.curPrefix, sym);
        tmpVal = (Short)this.symbolStringHashTable.get(this.testKey);
        if (tmpVal != null) {
            this.curPrefix = tmpVal;
            this.foundWasLast = true;
        } else {
            short newCode = (short)this.symbolStringHashTable.size();
            this.writeValue(this.curPrefix);
            this.curPrefix = (short)(0xFF & sym);
            this.foundWasLast = false;
            if (newCode == this.unitSizeCapacity) {
                if (this.unitSize < this.maxUnitSize) {
                    this.setUnit(++this.unitSize);
                } else {
                    if (Debug.debug) {
                        Debug.println("unitSize=max: Clearing string table");
                    }
                    this.writeValue(this.clearCode);
                    this.symbolStringHashTable.clear();
                    this.symbolStringHashTable = null;
                    this.initSymbolStringHashTable();
                    this.setUnit(this.symbolSize + 1);
                    this.curPrefix = (short)-1;
                    this.processSymbol(sym);
                }
            }
            if (!this.foundWasLast) {
                KeyEntry newKey = (KeyEntry)this.testKey.clone();
                this.symbolStringHashTable.put(newKey, new Short(newCode));
            }
        }
    }

    public void outputEndCode() throws IOException {
        if (this.foundWasLast) {
            this.writeValue(this.curPrefix);
        }
        this.writeValue(this.endCode);
    }

    public void setOptions(long iOptions) {
        this.optionFlags = iOptions;
    }

    protected void initSymbolStringHashTable() {
        short numSymbols = 1 << this.symbolSize;
        this.symbolStringHashTable = new Hashtable(2 * numSymbols);
        for (short i = 0; i < numSymbols; i = (short)(i + 1)) {
            KeyEntry key = new KeyEntry(-1, (byte)(0xFF & i));
            this.symbolStringHashTable.put(key, new Short(i));
        }
        KeyEntry key = new KeyEntry(-2, 0);
        this.symbolStringHashTable.put(key, new Short(this.clearCode));
        key = new KeyEntry(-2, 1);
        this.symbolStringHashTable.put(key, new Short(this.endCode));
    }
}

