/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder.compression;

import com.sas.codepolicy.SASScope;
import java.io.EOFException;

@SASScope(value="ALL")
public class BitBuffer {
    protected byte[] buf;
    protected int bufLength;
    protected int unitSize;
    protected int mask;
    protected int byteOffset;
    protected int bitOffset;

    public BitBuffer(byte[] buffer) {
        this.buf = buffer;
        this.bufLength = buffer.length;
        this.byteOffset = 0;
        this.bitOffset = 0;
        this.mask = 0;
        this.unitSize = 0;
    }

    public void finalizer() {
    }

    public void setUnitSize(int w) {
        this.unitSize = w;
        this.mask = (1 << this.unitSize) - 1;
    }

    public int read() throws EOFException {
        int readBitExtent = this.bitOffset + this.unitSize;
        int postByteOffset = this.byteOffset + (readBitExtent >> 3);
        int postBitOffset = readBitExtent & 7;
        int accumulator = 0;
        if (postByteOffset >= this.bufLength) {
            throw new EOFException("Post byte offset=" + postByteOffset + " exceeds buffer length=" + this.bufLength);
        }
        int bytesAffected = postByteOffset - this.byteOffset;
        int i = 0;
        int shiftBits = 0;
        while (i < bytesAffected) {
            accumulator |= this.buf[this.byteOffset + i] << shiftBits;
            ++i;
            shiftBits += 8;
        }
        accumulator >>>= this.bitOffset;
        this.bitOffset = postBitOffset;
        this.byteOffset = postByteOffset;
        return accumulator &= this.mask;
    }

    public void writeUnit(int val) throws EOFException {
        int writeBitExtent = this.bitOffset + this.unitSize;
        int postByteOffset = this.byteOffset + (writeBitExtent >> 3);
        int postBitOffset = writeBitExtent & 7;
        if (postByteOffset >= this.bufLength) {
            throw new EOFException("Post byte offset=" + postByteOffset + " exceeds buffer length=" + this.bufLength);
        }
        int bytesAffected = postByteOffset - this.byteOffset + 1;
        int accumulator = this.buf[this.byteOffset];
        accumulator |= (val & this.mask) << this.bitOffset;
        int i = 0;
        while (i < bytesAffected) {
            this.buf[this.byteOffset + i] = (byte)(0xFF & accumulator);
            ++i;
            accumulator >>>= 8;
        }
        this.byteOffset = postByteOffset;
        this.bitOffset = postBitOffset;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public boolean skipBytes(int offset) {
        if (this.bitOffset > 0) {
            ++offset;
        }
        return this.seekByte(this.byteOffset + offset);
    }

    public boolean seekByte(int offset) {
        if (offset >= this.bufLength) {
            this.byteOffset = this.bufLength;
            this.bitOffset = 0;
            return false;
        }
        this.byteOffset = offset;
        this.bitOffset = 0;
        return true;
    }

    public void shiftToBegin(int shiftBytes) {
        int bytesRemaining;
        if (shiftBytes == 0) {
            return;
        }
        int shiftOffset = shiftBytes - 1;
        if (shiftOffset > this.byteOffset) {
            shiftOffset = this.byteOffset;
        }
        if ((bytesRemaining = this.byteOffset - shiftOffset) > 0) {
            System.arraycopy(this.buf, shiftBytes, this.buf, 0, bytesRemaining);
            this.byteOffset = bytesRemaining - 1;
        } else {
            this.byteOffset = 0;
        }
    }

    public boolean isEndOfBuffer() {
        return this.byteOffset >= this.bufLength;
    }

    public String toString() {
        StringBuffer tmpStrBuf = new StringBuffer();
        for (int i = 0; i <= this.byteOffset; ++i) {
            tmpStrBuf.append(Integer.toHexString(0xFF & this.buf[i]) + " ");
        }
        return tmpStrBuf.toString();
    }
}

