/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder;

import com.sas.codepolicy.SASScope;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SASScope(value="ALL")
public class LEDataOutputStream
implements DataOutput {
    DataOutputStream oStream;

    public LEDataOutputStream(OutputStream istrm) {
        this.oStream = new DataOutputStream(istrm);
    }

    public void finalize() throws IOException {
        this.oStream.close();
    }

    @Override
    public void write(int i) throws IOException {
        this.oStream.write(i);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.oStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.oStream.write(b);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.oStream.writeBoolean(b);
    }

    @Override
    public void writeByte(int i) throws IOException {
        this.oStream.writeByte(i);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.oStream.writeChars(s);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.oStream.writeBytes(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.oStream.writeUTF(s);
    }

    @Override
    public void writeChar(int i) throws IOException {
        this.oStream.writeChar(i);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        throw new IOException("LEDataOutputStream.writeDouble() not supported");
    }

    @Override
    public void writeFloat(float f) throws IOException {
        throw new IOException("LEDataOutputStream.writeFloat() not supported");
    }

    @Override
    public void writeInt(int i) throws IOException {
        int LSShort = i & 0xFFFF;
        int MSShort = i >>> 16;
        this.writeShort(LSShort);
        this.writeShort(MSShort);
    }

    @Override
    public void writeLong(long l) throws IOException {
        int LSInt = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        int MSInt = (int)(l >>> 32);
        this.writeInt(LSInt);
        this.writeInt(MSInt);
    }

    @Override
    public void writeShort(int s) throws IOException {
        int LSByte = s & 0xFF;
        int MSByte = s >>> 8;
        this.oStream.write(LSByte);
        this.oStream.write(MSByte);
    }
}

