/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.encoder.GifColorTable;
import com.sas.visuals.image.encoder.LEDataOutputStream;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;

@SASScope(value="ALL")
public class ImageAdaptor {
    protected PixelGrabber grabber;
    protected GifColorTable gifColorTable;
    protected byte[] pixelBytes;
    protected boolean transparentSet;
    protected byte transparentIndex;

    public ImageAdaptor(Image img) {
        this.grabber = new PixelGrabber(img, 0, 0, -1, -1, false);
        this.transparentSet = false;
    }

    public boolean setup(boolean checkAlpha) throws InterruptedException, ImageFormatException {
        boolean rc = this.grabber.grabPixels();
        if (!rc) {
            return rc;
        }
        Object tmpPixels = this.grabber.getPixels();
        ColorModel cModel = this.grabber.getColorModel();
        this.gifColorTable = new GifColorTable(cModel);
        this.gifColorTable.setCheckAlpha(checkAlpha);
        this.pixelBytes = this.gifColorTable.convertToBytes(tmpPixels);
        return rc;
    }

    public boolean setup() throws InterruptedException, ImageFormatException {
        return this.setup(true);
    }

    public void setTransparent(byte index) {
        this.transparentIndex = index;
        this.transparentSet = true;
    }

    public void setTransparentRGB(byte red, byte green, byte blue) throws ImageFormatException {
        if (this.gifColorTable == null || this.gifColorTable.hasIndexColorModel()) {
            throw new ImageFormatException("Not supported for Indexed color model images");
        }
        this.setTransparent(this.gifColorTable.getColorIndex(red, green, blue));
    }

    public boolean isTransparent() {
        return this.transparentSet ? true : this.gifColorTable.isTransparent();
    }

    public byte getTransparentIndex() {
        return this.transparentSet ? this.transparentIndex : this.gifColorTable.getTransparentIndex();
    }

    public byte[] getImageBytes() {
        return this.pixelBytes;
    }

    public int getWidth() {
        return this.grabber.getWidth();
    }

    public int getHeight() {
        return this.grabber.getHeight();
    }

    public int getPixelBitSize() {
        return this.gifColorTable.getPixelBitSize();
    }

    public GifColorTable getGifColorTable() {
        return this.gifColorTable;
    }

    public void writeColorTable(LEDataOutputStream os) throws IOException {
        this.gifColorTable.writeTo(os);
    }
}

