/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.compression.BitBuffer;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public class CcittModeTree {
    static final int ZERO_CHILD = 0;
    static final int ONE_CHILD = 1;
    static final int MODE_VALUE = 2;
    static final short PASS = 1;
    static final short HOR = 2;
    static final short V_L3 = 3;
    static final short V_L2 = 4;
    static final short V_L1 = 5;
    static final short V_0 = 6;
    static final short V_R1 = 7;
    static final short V_R2 = 8;
    static final short V_R3 = 9;
    static final short TWOD_EXT = 10;
    static final short ONED_EXT = 11;
    static final short[][] modeTree = new short[][]{{1, 18, -1}, {2, 17, -1}, {3, 16, -1}, {4, 13, -1}, {5, 10, -1}, {6, 9, -1}, {7, -1, -1}, {-1, 8, -1}, {-1, -1, 11}, {-1, -1, 10}, {11, 12, -1}, {-1, -1, 3}, {-1, -1, 9}, {14, 15, -1}, {-1, -1, 4}, {-1, -1, 8}, {-1, -1, 1}, {-1, -1, 2}, {19, 20, -1}, {-1, -1, 5}, {-1, -1, 7}, {-1, -1, 6}};

    public static short getMode(BitBuffer bbuf) throws ImageCompressionException {
        int treeIndex = bbuf.extract() == 0 ? 0 : 21;
        short mode = modeTree[treeIndex][2];
        while (mode < 0) {
            int childIndex = bbuf.extract();
            if ((treeIndex = modeTree[treeIndex][childIndex]) == -1) {
                throw new ImageCompressionException("Bad mode tree index");
            }
            mode = modeTree[treeIndex][2];
        }
        return mode;
    }
}

