/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.compression.BitBuffer;
import com.sas.visuals.image.decoder.compression.Ccitt1DCScheme;
import com.sas.visuals.image.decoder.compression.CcittModeTree;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public class CcittG3CScheme
extends Ccitt1DCScheme {
    protected BitBuffer refLine;
    int markA0;
    int markB1;
    int markB2;
    boolean curPixelIsWhite;

    public CcittG3CScheme(byte[] inputBytes, int iXSize, int iUnCompSize, int iYSize) throws ImageCompressionException {
        super(inputBytes, iXSize, iUnCompSize, iYSize);
        this.refLine = new BitBuffer(this.xSize, false);
    }

    @Override
    protected void checkStartCode() throws ImageCompressionException {
        this.processEndOfLine();
    }

    @Override
    protected void uncompressScanLine(BitBuffer oBuff) throws ImageCompressionException {
        int count;
        short mode;
        if (this.inBitBuff.extract() == 1) {
            this.refLine.reset();
            super.uncompressScanLine(this.refLine);
            oBuff.append(this.refLine);
            return;
        }
        this.markA0 = 0;
        this.markB2 = 0;
        this.markB1 = 0;
        this.curPixelIsWhite = true;
        for (count = 0; count < this.xSize; count += this.processMode(mode, oBuff)) {
            mode = CcittModeTree.getMode(this.inBitBuff);
        }
        if (count > this.xSize) {
            throw new ImageCompressionException("Uncompressed width =" + count + " exceeds image XSize=" + this.xSize);
        }
    }

    @Override
    protected void processEndOfLine() throws ImageCompressionException {
        int cnt = 0;
        while (this.inBitBuff.extract() != 1) {
            ++cnt;
        }
        if (cnt < 11) {
            throw new ImageCompressionException("Missing EOL code word");
        }
    }

    protected int processMode(int mode, BitBuffer oBuff) throws ImageCompressionException {
        int runLength = 0;
        this.refLine.seek(this.markA0);
        switch (mode) {
            case 1: {
                this.markB1 = this.refLine.findOppositeRun(this.curPixelIsWhite);
                if (this.markB1 < 0) {
                    this.markB1 = this.markB2 = this.xSize;
                } else {
                    this.markB2 = this.refLine.findBit(this.curPixelIsWhite);
                    if (this.markB2 < 0) {
                        this.markB2 = this.xSize;
                    }
                }
                runLength = this.markB2 - this.markA0;
                oBuff.fill(runLength, this.curPixelIsWhite);
                break;
            }
            case 2: {
                int tmpRunLength = super.getRunLength(this.curPixelIsWhite);
                oBuff.fill(tmpRunLength, this.curPixelIsWhite);
                runLength = super.getRunLength(!this.curPixelIsWhite);
                oBuff.fill(runLength, !this.curPixelIsWhite);
                runLength += tmpRunLength;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int delta = mode - 6;
                this.markB1 = this.refLine.findOppositeRun(this.curPixelIsWhite);
                if (this.markB1 < 0) {
                    this.markB1 = this.xSize;
                }
                runLength = this.markB1 - this.markA0 + delta;
                oBuff.fill(runLength, this.curPixelIsWhite);
                this.curPixelIsWhite = !this.curPixelIsWhite;
                break;
            }
            case 10: 
            case 11: {
                throw new ImageCompressionException("Unsupported extension=" + mode);
            }
            default: {
                throw new ImageCompressionException("Unknown mode=" + mode);
            }
        }
        this.markA0 += runLength;
        return runLength;
    }
}

