/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.decoder.compression.BitBuffer;
import com.sas.visuals.image.decoder.compression.CcittTree;
import com.sas.visuals.image.decoder.compression.CompressionScheme;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public class Ccitt1DCScheme
extends CompressionScheme {
    protected BitBuffer inBitBuff;

    public Ccitt1DCScheme(byte[] inputBytes, int iXSize, int iUnCompSize, int iYSize) throws ImageCompressionException {
        super(inputBytes, iXSize, iUnCompSize, iYSize);
    }

    @Override
    public byte[] uncompress() throws ImageCompressionException {
        boolean fillOrder = false;
        this.inBitBuff = new BitBuffer(this.inBytes, fillOrder);
        BitBuffer outBitBuff = new BitBuffer(8 * this.uncompressedSize, fillOrder);
        this.checkStartCode();
        int tmpYSize = this.ySize - 1;
        for (int i = 0; i < tmpYSize; ++i) {
            Debug.println("Scan = " + i);
            this.uncompressScanLine(outBitBuff);
            this.processEndOfLine();
            outBitBuff.nextByteBoundary();
        }
        this.uncompressScanLine(outBitBuff);
        return outBitBuff.getByteBuffer();
    }

    @Override
    public byte[] compress() throws ImageCompressionException {
        throw new ImageCompressionException("Unsupported method");
    }

    protected void uncompressScanLine(BitBuffer oBuff) throws ImageCompressionException {
        int count;
        boolean isWhitePixel = true;
        int runLength = 0;
        for (count = 0; count < this.xSize; count += runLength) {
            runLength = this.getRunLength(isWhitePixel);
            oBuff.fill(runLength, isWhitePixel);
            isWhitePixel = !isWhitePixel;
            runLength = 0;
        }
        if (count > this.xSize) {
            throw new ImageCompressionException("Run length sum=" + count + " exceeds image XSize=" + this.xSize);
        }
    }

    public int getRunLength(boolean isWhitePixel) throws ImageCompressionException {
        short tmpRunLength;
        int runLength = 0;
        do {
            tmpRunLength = CcittTree.getRunLength(this.inBitBuff, isWhitePixel);
            runLength += tmpRunLength;
        } while (tmpRunLength > 63);
        return runLength;
    }

    protected void checkStartCode() throws ImageCompressionException {
    }

    protected void processEndOfLine() throws ImageCompressionException {
        this.inBitBuff.nextByteBoundary();
    }
}

