/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public class LEDataInputStream
implements DataInput {
    DataInputStream iStream;

    public LEDataInputStream(InputStream istrm) {
        this.iStream = new DataInputStream(istrm);
    }

    public void finalize() throws IOException {
        this.iStream.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.iStream.read(b, off, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.iStream.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.iStream.readByte();
    }

    @Override
    public char readChar() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)(ch2 << 8 | ch1);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.iStream.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.iStream.readFully(b);
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedShort() | this.readUnsignedShort() << 16;
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Not Supported: deprecated in DataInputStream");
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() & 0xFFFFFFFFL) + (long)(this.readInt() << 32);
    }

    @Override
    public short readShort() throws IOException {
        int byt2;
        int byt1 = this.iStream.read();
        if ((byt1 | (byt2 = this.iStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)(byt1 | byt2 << 8);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.iStream.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return 0xFFFF & this.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.iStream.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.iStream.skipBytes(n);
    }
}

