/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.ImageProperties;
import com.sas.visuals.image.decoder.BmpDecoder;
import com.sas.visuals.image.decoder.DmpDecoder;
import com.sas.visuals.image.decoder.TiffDecoder;
import com.sas.visuals.image.decoder.WbmpDecoder;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public abstract class ImageDecoder {
    static final int SIGNATURE_LENGTH = 18;
    static final String DMP_IMG_TYPE = "image/dmp";
    static final String TIFF_IMG_TYPE = "image/tiff";
    static final String BMP_IMG_TYPE = "image/bmp";
    static final String WBMP_IMG_TYPE = "image/wbmp";
    protected InputStream iStream;

    public ImageDecoder(InputStream iStrm) {
        this.iStream = iStrm;
    }

    public static String guessContentType(InputStream iStream) throws IOException, ImageException {
        byte[] imgSignature = new byte[18];
        if (!iStream.markSupported()) {
            throw new ImageException("InputStream does not support mark()");
        }
        iStream.mark(19);
        int numRead = iStream.read(imgSignature);
        iStream.reset();
        if (numRead != 18) {
            throw new IOException("EOF while reading signature bytes read=" + numRead + "is < " + 18);
        }
        if (TiffDecoder.matchFormat(imgSignature)) {
            return TIFF_IMG_TYPE;
        }
        if (DmpDecoder.matchFormat(imgSignature)) {
            return DMP_IMG_TYPE;
        }
        if (BmpDecoder.matchFormat(imgSignature)) {
            return BMP_IMG_TYPE;
        }
        if (WbmpDecoder.matchFormat(imgSignature)) {
            return WBMP_IMG_TYPE;
        }
        StringBuffer tmpHexString = new StringBuffer();
        for (int i = 0; i < 18; ++i) {
            tmpHexString.append(imgSignature[i] + " ");
        }
        throw new ImageFormatException("Unrecognized image format: Signature=" + tmpHexString);
    }

    public static boolean compareBytes(byte[] op1, byte[] op2) {
        boolean equal = true;
        if (op1.length > op2.length) {
            return false;
        }
        for (int i = 0; equal && i < op1.length; ++i) {
            equal = op1[i] == op2[i];
        }
        return equal;
    }

    public static ImageDecoder getImageDecoder(String iContentType, InputStream iStrm) throws IOException, ImageException {
        ImageDecoder tmpDecoder = iContentType.equalsIgnoreCase(DMP_IMG_TYPE) ? new DmpDecoder(iStrm) : (iContentType.equalsIgnoreCase(TIFF_IMG_TYPE) ? new TiffDecoder(iStrm) : (iContentType.equalsIgnoreCase(BMP_IMG_TYPE) ? new BmpDecoder(iStrm) : (iContentType.equalsIgnoreCase(WBMP_IMG_TYPE) ? new WbmpDecoder(iStrm) : null)));
        return tmpDecoder;
    }

    public abstract ImageProperties getImageProperties() throws IOException, ImageException;

    public ColorModel getColorModel(ImageProperties iProps) throws IOException, ImageException {
        int colorModelType = iProps.getColorModelType();
        ColorModel tmpCModel = null;
        int bitsPerSample = iProps.getSampleSizeInBits();
        switch (colorModelType) {
            case 0: 
            case 1: {
                boolean reverseVideo = colorModelType == 0;
                byte[] grayMap = this.makeGrayMap(bitsPerSample, reverseVideo);
                tmpCModel = new IndexColorModel(8, grayMap.length / 3, grayMap, 0, false);
                break;
            }
            case 2: {
                tmpCModel = ColorModel.getRGBdefault();
                break;
            }
            case 3: {
                byte[] cmap = this.getColorMap();
                tmpCModel = new IndexColorModel(bitsPerSample, cmap.length / 3, cmap, 0, false);
                break;
            }
            default: {
                throw new ImageFormatException("Unknown ColorModel type=" + colorModelType);
            }
        }
        return tmpCModel;
    }

    public abstract byte[] getColorMap() throws IOException, ImageFormatException;

    public byte[] makeGrayMap(int bitsPerSample, boolean reverseVideo) {
        int count = 1 << bitsPerSample;
        int max = 0;
        int min = 0;
        if (reverseVideo) {
            min = 255;
        } else {
            max = 255;
        }
        short step = (short)((max - min) / (count - 1));
        byte[] grayMap = new byte[3 * count];
        grayMap[0] = (byte)min;
        grayMap[1] = grayMap[2] = grayMap[0];
        for (int i = 3; i < grayMap.length; i += 3) {
            grayMap[i] = (byte)(grayMap[i - 3] + step);
            byte by = grayMap[i];
            grayMap[i + 2] = by;
            grayMap[i + 1] = by;
        }
        return grayMap;
    }

    protected abstract byte[] getRawImageData(ImageProperties var1) throws IOException, ImageException;

    public Object getImageData(ImageProperties iProps) throws IOException, ImageException {
        byte[] byteData = this.getRawImageData(iProps);
        int byteDataLength = byteData.length;
        int colorModelType = iProps.getColorModelType();
        int bitsPerSample = iProps.getSampleSizeInBits();
        if (iProps.getColorModelType() == 2) {
            int paddedImageSizeInPixels = byteDataLength / 3;
            int[] intData = new int[paddedImageSizeInPixels];
            for (int i = 0; i < paddedImageSizeInPixels; ++i) {
                int j = 3 * i;
                intData[i] = 0xFF000000 | (0xFF & byteData[j]) << 16 | (0xFF & byteData[j + 1]) << 8 | 0xFF & byteData[j + 2];
            }
            return intData;
        }
        if (bitsPerSample < 8) {
            int mask = 0xFF & (1 << bitsPerSample) - 1;
            int samplesPerByte = iProps.getSamplesPerByte();
            int paddedImageSizeInPixels = byteDataLength * samplesPerByte;
            byte[] tmpByteData = new byte[paddedImageSizeInPixels];
            for (int i = 0; i < byteDataLength; ++i) {
                int currentByte = 0xFF & byteData[i];
                int byteOffset = samplesPerByte * (i + 1) - 1;
                int j = 0;
                int k = byteOffset;
                while (j < samplesPerByte) {
                    tmpByteData[k] = (byte)(mask & currentByte);
                    currentByte >>= bitsPerSample;
                    ++j;
                    --k;
                }
            }
            return tmpByteData;
        }
        if (bitsPerSample > 8) {
            Debug.println("** May not work!! Index depth=" + bitsPerSample + " is > 8");
        }
        return byteData;
    }
}

