/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.ImageProperties;
import com.sas.visuals.image.decoder.ImageDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public class DmpDecoder
extends ImageDecoder {
    static final String DMP_SIGNATURE = "SAS/IMAGE DUMP";
    int version;
    byte[] byteOrder;
    int colorMapLength;
    long dataLength;
    DataInputStream iStream;

    DmpDecoder(InputStream iStrm) throws IOException {
        super(iStrm);
        this.iStream = new DataInputStream(iStrm);
        this.byteOrder = new byte[2];
        this.version = this.iStream.readUnsignedShort();
        this.iStream.read(this.byteOrder);
        this.colorMapLength = 0;
        this.dataLength = 0L;
    }

    public void finalizer() throws IOException {
        this.iStream.close();
    }

    public static boolean matchFormat(byte[] iSign) {
        String testSign = new String(iSign, 4, DMP_SIGNATURE.length());
        return testSign.compareTo(DMP_SIGNATURE) == 0;
    }

    @Override
    public byte[] getColorMap() throws IOException {
        byte[] dmpCMap = new byte[this.colorMapLength * 6];
        byte[] cMap = new byte[this.colorMapLength * 3];
        this.iStream.readFully(dmpCMap);
        int j = 0;
        int k = 0;
        while (j < cMap.length) {
            cMap[j] = dmpCMap[k];
            cMap[j + 1] = dmpCMap[k + 2];
            cMap[j + 2] = dmpCMap[k + 4];
            j += 3;
            k += 6;
        }
        return cMap;
    }

    @Override
    public byte[] getRawImageData(ImageProperties iProps) throws IOException {
        byte[] dmpData = new byte[(int)this.dataLength];
        this.iStream.readFully(dmpData);
        return dmpData;
    }

    @Override
    public ImageProperties getImageProperties() throws IOException {
        ImageProperties iProps = new ImageProperties("SAS/DMP");
        this.iStream.skip(30L);
        iProps.setXSize(this.iStream.readUnsignedShort());
        iProps.setYSize(this.iStream.readUnsignedShort());
        int colorModelType = this.iStream.readUnsignedShort();
        int lineSizeInBytes = this.iStream.readUnsignedShort();
        int depth = this.iStream.readUnsignedByte();
        int redSizeInBits = this.iStream.readUnsignedByte();
        int greenSizeInBits = this.iStream.readUnsignedByte();
        int blueSizeInBits = this.iStream.readUnsignedByte();
        int alphaSizeInBits = this.iStream.readUnsignedByte();
        this.colorMapLength = this.iStream.readUnsignedShort();
        this.dataLength = 0xFFFFFFFF & this.iStream.readInt();
        if (depth == 1) {
            iProps.setPixelSizeInSamples(1);
            iProps.setSampleSizeInBits(depth);
            iProps.setColorModelType(1);
        } else if (this.colorMapLength > 0) {
            iProps.setPixelSizeInSamples(1);
            iProps.setSampleSizeInBits(depth);
            iProps.setColorModelType(3);
        } else if (colorModelType == 1) {
            iProps.setPixelSizeInSamples(3);
            iProps.setSampleSizeInBits(depth / 3);
            iProps.setColorModelType(2);
        }
        iProps.calcScanLineSizes();
        return iProps;
    }
}

