/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.BufferedFilter;

@SASScope(value="ALL")
public class ShearFilter
extends BufferedFilter {
    static final long serialVersionUID = -1921217808319845962L;
    protected double xShear;
    protected double yShear;
    protected double invFactor;

    public ShearFilter() {
        this.propKey = "shear";
    }

    public ShearFilter(double xs, double ys, int backColor) throws IllegalArgumentException {
        super(backColor);
        this.setXshear(xs);
        this.setYshear(ys);
        this.calcInvFactor();
        this.propVal = "x=" + this.xShear + " y=" + this.yShear;
    }

    public ShearFilter(double xs, double ys) throws IllegalArgumentException {
        this(xs, ys, 0);
    }

    public void setXshear(double xs) throws IllegalArgumentException {
        this.xShear = xs;
        this.calcInvFactor();
        this.propVal = "x=" + this.xShear + " y=" + this.yShear;
    }

    public double getXshear() {
        return this.xShear;
    }

    public void setYshear(double ys) throws IllegalArgumentException {
        this.yShear = ys;
        this.calcInvFactor();
        this.propVal = "x=" + this.xShear + " y=" + this.yShear;
    }

    public double getYshear() {
        return this.yShear;
    }

    private void calcInvFactor() throws IllegalArgumentException {
        this.invFactor = 1.0 - this.xShear * this.yShear;
        if (this.invFactor == 0.0) {
            throw new IllegalArgumentException("Xshear*Yshear can not be 1.0");
        }
    }

    @Override
    public final void transform(int[] in, double[] out) {
        out[0] = (double)in[0] + this.xShear * (double)in[1];
        out[1] = (double)in[1] + this.yShear * (double)in[0];
    }

    @Override
    public final void invTransform(double[] in, double[] out) {
        out[0] = (in[0] - this.xShear * in[1]) / this.invFactor;
        out[1] = (in[1] - this.yShear * in[0]) / this.invFactor;
    }
}

