/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.visuals.image.Rotate90Filter;
import com.sas.visuals.image.RotateTransform180;
import com.sas.visuals.image.RotateTransform270;
import com.sas.visuals.image.RotateTransform90;

public class RotateTransform {
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    protected int scansize;
    protected Rotate90Filter filter;

    public RotateTransform(Rotate90Filter filt) {
        this.filter = filt;
    }

    public static RotateTransform getTransform(int numTurns, Rotate90Filter filt) {
        RotateTransform txf = null;
        switch (numTurns) {
            case 0: {
                txf = new RotateTransform(filt);
                break;
            }
            case 1: {
                txf = new RotateTransform90(filt);
                break;
            }
            case 2: {
                txf = new RotateTransform180(filt);
                break;
            }
            case 3: {
                txf = new RotateTransform270(filt);
            }
        }
        return txf;
    }

    public void transformDimensions(int[] dimn) {
        this.width = dimn[0];
        this.height = dimn[1];
    }

    public void transformBuffer(int[] tArgs, byte[] inBuff, byte[] outBuff, int off) {
        this.extractTArgs(tArgs);
        int i = 0;
        int srcIndex = off;
        int destIndex = 0;
        while (i < this.h) {
            System.arraycopy(inBuff, srcIndex, outBuff, destIndex, this.w);
            ++i;
            srcIndex += this.scansize;
            destIndex += this.w;
        }
        this.filter.setupTArgs(this.x, this.y, this.w, this.h, this.w);
    }

    public void transformBuffer(int[] tArgs, int[] inBuff, int[] outBuff, int off) {
        this.extractTArgs(tArgs);
        int i = 0;
        int srcIndex = off;
        int destIndex = 0;
        while (i < this.h) {
            System.arraycopy(inBuff, srcIndex, outBuff, destIndex, this.w);
            ++i;
            srcIndex += this.scansize;
            destIndex += this.w;
        }
        this.filter.setupTArgs(this.x, this.y, this.w, this.h, this.w);
    }

    public final void extractTArgs(int[] tArgs) {
        this.x = tArgs[0];
        this.y = tArgs[1];
        this.w = tArgs[2];
        this.h = tArgs[3];
        this.scansize = tArgs[4];
    }
}

