/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.RotateTransform;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class Rotate90Filter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = -4023799639704042070L;
    protected int numTurns;
    protected transient int[] tArgs;
    protected transient RotateTransform rotTransform;

    public Rotate90Filter(int angle) {
        this.setRotateAngle(angle);
    }

    public Rotate90Filter() {
        this(0);
    }

    public void setRotateAngle(int angle) {
        if (angle < 0) {
            angle += 360;
        }
        this.numTurns = angle % 360 / 90;
        Debug.println("numTurns=" + this.numTurns);
    }

    public int getRotateAngle() {
        return this.numTurns * 90;
    }

    public void setProperties(Hashtable props) {
        String key = "rotate";
        String val = "" + this.numTurns * 90;
        Object o = (props = (Hashtable)props.clone()).get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    @Override
    public void setDimensions(int iWidth, int iHeight) {
        int[] dimn = new int[2];
        if (this.rotTransform == null) {
            this.rotTransform = RotateTransform.getTransform(this.numTurns, this);
        }
        dimn[0] = iWidth;
        dimn[1] = iHeight;
        this.rotTransform.transformDimensions(dimn);
        super.setDimensions(dimn[0], dimn[1]);
    }

    @Override
    public void setHints(int hints) {
        hints &= 0xFFFFFFFD;
        super.setHints((hints &= 0xFFFFFFFB) | 1);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        byte[] outputBuffer = new byte[w * h];
        this.setupTArgs(x, y, w, h, scansize);
        this.rotTransform.transformBuffer(this.tArgs, pixels, outputBuffer, off);
        super.setPixels(this.tArgs[0], this.tArgs[1], this.tArgs[2], this.tArgs[3], model, outputBuffer, 0, this.tArgs[4]);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int[] outputBuffer = new int[w * h];
        this.setupTArgs(x, y, w, h, scansize);
        this.rotTransform.transformBuffer(this.tArgs, pixels, outputBuffer, off);
        super.setPixels(this.tArgs[0], this.tArgs[1], this.tArgs[2], this.tArgs[3], model, outputBuffer, 0, this.tArgs[4]);
    }

    final void setupTArgs(int x, int y, int w, int h, int scansize) {
        if (this.tArgs == null) {
            this.tArgs = new int[5];
        }
        this.tArgs[0] = x;
        this.tArgs[1] = y;
        this.tArgs[2] = w;
        this.tArgs[3] = h;
        this.tArgs[4] = scansize;
    }
}

