/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageProperties;
import com.sas.visuals.image.RAFileWrapper;
import com.sas.visuals.image.decoder.DefaultDecoder;
import com.sas.visuals.image.decoder.ImageDecoder;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

@SASScope(value="ALL")
public class ImageProvider {
    protected ImageProperties imgProps;
    protected Image img;
    protected ImageProducer mImgSrc;
    protected ColorModel imgColorModel;
    protected Object imgData;
    protected InputStream iStream;
    protected String contentType;
    protected String fileName;
    protected URL url;

    public ImageProvider(InputStream iStrm) throws IOException {
        this.iStream = !iStrm.markSupported() ? new BufferedInputStream(iStrm) : iStrm;
        this.contentType = URLConnection.guessContentTypeFromStream(this.iStream);
        if (this.contentType == null) {
            this.iStream.mark(10);
            int c1 = this.iStream.read();
            int c2 = this.iStream.read();
            int c3 = this.iStream.read();
            int c4 = this.iStream.read();
            this.iStream.reset();
            if (c1 == 255 && c2 == 216 && c3 == 255 && c4 == 225) {
                this.contentType = "image/jpg";
            }
        }
    }

    public ImageProvider(String fileName) throws IOException {
        this(new RAFileWrapper(fileName));
        this.fileName = fileName;
    }

    public ImageProvider(URL iUrl) throws IOException {
        this(new RAFileWrapper(iUrl.openStream(), iUrl.getFile()));
        this.url = iUrl;
    }

    public void finalizer() throws IOException {
        this.iStream.close();
    }

    public ImageProducer getImageSource() throws IOException, ImageException {
        ImageDecoder imgDecoder = ImageDecoder.getImageDecoder(this.contentType, this.iStream);
        this.imgProps = imgDecoder.getImageProperties();
        Debug.println("Image Properties: " + this.imgProps);
        int imgXSize = this.imgProps.getXSize();
        int imgYSize = this.imgProps.getYSize();
        ColorModel cModel = imgDecoder.getColorModel(this.imgProps);
        this.imgData = imgDecoder.getImageData(this.imgProps);
        if (this.imgData instanceof byte[]) {
            int unpackedScanLineSize = this.imgProps.getUnpackedScanLineSize();
            this.mImgSrc = new MemoryImageSource(imgXSize, imgYSize, cModel, (byte[])this.imgData, 0, unpackedScanLineSize);
        } else {
            this.mImgSrc = new MemoryImageSource(imgXSize, imgYSize, cModel, (int[])this.imgData, 0, imgXSize);
        }
        return this.mImgSrc;
    }

    public Image getImage() throws IOException, ImageException {
        if (this.img != null) {
            return this.img;
        }
        if (this.contentType != null) {
            this.img = this.fileName != null ? Toolkit.getDefaultToolkit().getImage(this.fileName) : (this.url != null ? Toolkit.getDefaultToolkit().getImage(this.url) : DefaultDecoder.getImage(this.iStream));
            return this.img;
        }
        this.contentType = ImageDecoder.guessContentType(this.iStream);
        if (this.mImgSrc == null) {
            this.mImgSrc = this.getImageSource();
        }
        this.img = Toolkit.getDefaultToolkit().createImage(this.mImgSrc);
        return this.img;
    }
}

