/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

public class ImageProperties {
    public static final short WHITE_IS_ZERO_CM_TYPE = 0;
    public static final short BLACK_IS_ZERO_CM_TYPE = 1;
    public static final short RGB_CM_TYPE = 2;
    public static final short RGB_PALETTE_CM_TYPE = 3;
    public static final short MSB_FILL_ORDER = 0;
    public static final short LSB_FILL_ORDER = 1;
    String imgFormatName;
    int xSize;
    int ySize;
    int pixelSizeInSamples;
    int sampleSizeInBits;
    int samplesPerByte;
    int padSizeInBits = 8;
    int scanLineSize;
    int unpackedScanLineSize;
    int colorModelType;
    int fillOrder;
    int boundaryBits;

    public ImageProperties(String formatName) {
        this.imgFormatName = formatName;
        this.ySize = 0;
        this.xSize = 0;
    }

    public void setXSize(int iXSize) {
        this.xSize = iXSize;
    }

    public int getXSize() {
        return this.xSize;
    }

    public void setYSize(int iYSize) {
        this.ySize = iYSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public void setPixelSizeInSamples(int iSize) {
        this.pixelSizeInSamples = iSize;
    }

    public int getPixelSizeInSamples() {
        return this.pixelSizeInSamples;
    }

    public void setSampleSizeInBits(int iSize) {
        this.samplesPerByte = 8 / iSize;
        this.sampleSizeInBits = iSize;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public void setFillOrder(int iFill) {
        this.fillOrder = iFill;
    }

    public int getFillOrder() {
        return this.fillOrder;
    }

    public void setColorModelType(int iSize) {
        this.colorModelType = iSize;
    }

    public int getColorModelType() {
        return this.colorModelType;
    }

    public int getPadSizeInBits() {
        return this.padSizeInBits;
    }

    public void setPadSizeInBits(int v) {
        this.padSizeInBits = v;
    }

    public void calcScanLineSizes() {
        int unitsPerScanLine = (this.xSize * this.sampleSizeInBits * this.pixelSizeInSamples + (this.padSizeInBits - 1)) / this.padSizeInBits;
        this.scanLineSize = unitsPerScanLine * this.padSizeInBits / 8;
        this.unpackedScanLineSize = this.scanLineSize * this.samplesPerByte;
    }

    public int getScanLineSize() {
        return this.scanLineSize;
    }

    public int getUnpackedScanLineSize() {
        return this.unpackedScanLineSize;
    }

    public int getSamplesPerByte() {
        return this.samplesPerByte;
    }

    public String toString() {
        return "FORMAT=" + this.imgFormatName + " XSize=" + this.xSize + " YSize=" + this.ySize + "\n\tPixelSizeInSamples=" + this.pixelSizeInSamples + " SampleSizeInBits=" + this.sampleSizeInBits + " FillOrder=" + this.fillOrder + "\n\tPad size=" + this.padSizeInBits + " Scanline size=" + this.scanLineSize + " Unpacked Scanline size=" + this.unpackedScanLineSize + "\n\tColorModelType=" + this.colorModelType;
    }
}

