/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;

@SASScope(value="ALL")
public class GrayFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 5587522563144825813L;
    public static final int FS_SINK = 0;
    public static final int FS_GRAY = 1;
    protected Color _c;
    protected transient int _cRGB;
    protected transient int _cDarkerRGB;
    protected int _filterStyle;
    protected boolean _allowAlpha;

    public GrayFilter() {
        this(SystemColor.control);
    }

    public GrayFilter(Color c) {
        this(c, 1);
    }

    public GrayFilter(Color c, int filterStyle) {
        this.canFilterIndexColorModel = true;
        this._c = c;
        this._filterStyle = filterStyle;
        this._cRGB = c.getRGB();
        this._cDarkerRGB = c.darker().getRGB();
        this._allowAlpha = false;
    }

    public Color getFilterColor() {
        return this._c;
    }

    public void setFilterColor(Color c) {
        this._c = c;
        this._cRGB = c.getRGB();
        this._cDarkerRGB = c.darker().getRGB();
    }

    public int getFilterStyle() {
        return this._filterStyle;
    }

    public void setFilterStyle(int filterStyle) {
        this._filterStyle = filterStyle;
    }

    public void setAllowAlpha(boolean allow) {
        this._allowAlpha = allow;
    }

    public boolean getAllowAlpha() {
        return this._allowAlpha;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int temp = (((rgb & 0xFF0000) >> 16) + ((rgb & 0xFF00) >> 8) + (rgb & 0xFF)) / 3;
        int outRGB = this._filterStyle == 0 ? Color.white.getRGB() : ((this._cRGB & 0xFFFFFF) == (rgb & 0xFFFFFF) ? rgb : (temp > 223 ? this._cDarkerRGB : (temp > 127 ? this._cRGB : this._cDarkerRGB)));
        if (this._allowAlpha) {
            outRGB |= rgb & 0xFF000000;
        }
        return outRGB;
    }
}

