/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.BufferedFilter;
import com.sas.visuals.image.ConvolutionMask;
import com.sas.visuals.image.Debug;

@SASScope(value="ALL")
public class ConvolutionFilter
extends BufferedFilter {
    static final long serialVersionUID = 1514436337827042869L;
    protected ConvolutionMask cMask;
    private transient double[] accumulator;

    public ConvolutionFilter() {
        this.propKey = "convolute";
        this.accumulator = new double[4];
    }

    public void setConvolutionMask(ConvolutionMask mask) {
        this.cMask = mask;
        this.propVal = mask.name;
    }

    public ConvolutionMask getConvolutionMask() {
        return this.cMask;
    }

    @Override
    protected void transformNsendSrcBuffer() {
        Debug.println("ConvolutionFilter.transformNsendSrcBuffer");
        int[] transformedBuffer = new int[this.width];
        int maskSize = this.cMask.size;
        double[][] mask = this.cMask.mask;
        int maskOffset = maskSize / 2;
        for (int row = 0; row < this.height; ++row) {
            int srcPixel = 0;
            for (int col = 0; col < this.width; ++col) {
                int alpha = 0xFF000000 & this.getPixel(col + row * this.width);
                this.clearAccumulatedPixel();
                int mR = 0;
                int iR = row - maskOffset;
                while (mR < maskSize) {
                    int mC = 0;
                    int iC = col - maskOffset;
                    while (mC < maskSize) {
                        int saneR = this.sanitizeRow(iR);
                        int saneC = this.sanitizeColumn(iC);
                        srcPixel = this.getPixel(saneC + saneR * this.width);
                        this.accumulatePixel(srcPixel, mask[mC][mR]);
                        ++mC;
                        ++iC;
                    }
                    ++mR;
                    ++iR;
                }
                transformedBuffer[col] = alpha | this.getAccumulatedPixel();
            }
            this.consumer.setPixels(0, row, this.width, 1, this.transformedColorModel, transformedBuffer, 0, this.width);
        }
    }

    private void clearAccumulatedPixel() {
        this.accumulator[3] = 0.0;
        this.accumulator[2] = 0.0;
        this.accumulator[1] = 0.0;
        this.accumulator[0] = 0.0;
    }

    private void accumulatePixel(int pixel, double multiplier) {
        int red = this.transformedColorModel.getRed(pixel);
        int green = this.transformedColorModel.getGreen(pixel);
        int blue = this.transformedColorModel.getBlue(pixel);
        this.accumulator[1] = this.accumulator[1] + (double)red * multiplier;
        this.accumulator[2] = this.accumulator[2] + (double)green * multiplier;
        this.accumulator[3] = this.accumulator[3] + (double)blue * multiplier;
    }

    private int getAccumulatedPixel() {
        double divisor = this.cMask.divisor;
        double bias = this.cMask.bias;
        int[] channelValue = new int[4];
        for (int c = 1; c < 4; ++c) {
            int tmpValue = (int)(this.accumulator[c] / divisor + bias);
            channelValue[c] = tmpValue < 0 ? 0 : (tmpValue > 255 ? 255 : tmpValue);
        }
        return channelValue[1] << 16 | channelValue[2] << 8 | channelValue[3];
    }

    private int getPixel(int offset) {
        return this.majorityColorModel.getRGB(this.isByteData ? 0xFF & ((byte[])this.srcBuffer)[offset] : ((int[])this.srcBuffer)[offset]);
    }

    private int sanitizeRow(int r) {
        return r < 0 ? 0 : (r >= this.height ? this.height - 1 : r);
    }

    private int sanitizeColumn(int c) {
        return c < 0 ? 0 : (c >= this.width ? this.width - 1 : c);
    }
}

