/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.adapters;

import com.sas.visuals.adapters.MinMaxSpacePartitioner;

public class ProportionalSpacePartitioner
extends MinMaxSpacePartitioner {
    static final long serialVersionUID = 5236031106504715542L;
    public static final double PREFERRED_SIZE = -2.0;
    protected double[] percentages;

    public ProportionalSpacePartitioner() {
        this(null, null, null);
    }

    public ProportionalSpacePartitioner(double[] percentages) {
        this(percentages, null, null);
    }

    public ProportionalSpacePartitioner(double[] percentages, int[] minimums, int[] maximums) {
        this(percentages, minimums, maximums, true);
    }

    public ProportionalSpacePartitioner(double[] percentages, int[] minimums, int[] maximums, boolean giveMoreSpaceThanSpecified) {
        super(minimums, maximums, giveMoreSpaceThanSpecified);
        this.percentages = percentages;
    }

    @Override
    public int getPartitionedSpace(int[] sizes, int totalSize, int[] preferredSizes) {
        int size;
        int i;
        int sizeUsed = 0;
        int totalAfterPreferred = totalSize;
        for (i = 0; i < sizes.length; ++i) {
            if (this.percentages[i] != -2.0) continue;
            size = preferredSizes[i];
            sizes[i] = size = this.getConstrainedSize(i, size, totalSize, sizeUsed);
            sizeUsed += size;
            totalAfterPreferred -= size;
        }
        for (i = 0; i < sizes.length; ++i) {
            if (this.percentages[i] == -2.0) continue;
            size = (int)((double)totalAfterPreferred * this.percentages[i]);
            sizes[i] = size = this.getConstrainedSize(i, size, totalSize, sizeUsed);
            sizeUsed += size;
        }
        return totalSize - sizeUsed;
    }

    public double[] getPercentages() {
        return this.percentages;
    }

    public void setPercentages(double[] percentages) {
        this.percentages = percentages;
    }
}

