/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.validators;

import com.sas.text.Message;
import com.sas.util.validators.RB;
import com.sas.util.validators.Validator;

public class RequiredStringValidator
extends Validator {
    static final long serialVersionUID = -2315546223903595427L;
    public static final String RB_KEY = "RequiredStringValidator.";
    public static final String invalidLength = "RequiredStringValidator.InvalidFormat";
    public static final String notString = "RequiredStringValidator.NotString";
    protected static final int INVALID_LENGTH = 0;
    protected static final int NOT_STRING = 1;

    public RequiredStringValidator() {
    }

    public RequiredStringValidator(String customValidationMessage) {
        this.messages.set(0, this.newValidationMessage(customValidationMessage));
    }

    @Override
    public boolean validateValue(Object component, Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            this.setValidationMessage((Message)this.messages.get(0));
            this.setValidationMessageCode(invalidLength);
            return false;
        }
        if (value instanceof String) {
            if (value.toString().length() == 0) {
                this.setValidationMessage((Message)this.messages.get(0));
                this.setValidationMessageCode(invalidLength);
                return false;
            }
            return true;
        }
        this.setValidationMessage((Message)this.messages.get(1));
        this.setValidationMessageCode(notString);
        return false;
    }

    @Override
    public void createValidationMessages() {
        super.createValidationMessages();
        this.messages.add(this.newValidationMessage(RB.getStringResource(RB_KEY, "InvalidFormat.txt")));
        this.messages.add(this.newValidationMessage(RB.getStringResource(RB_KEY, "NotString.txt")));
    }
}

