/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.io.ObjectTokenizer;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class CSVStreamToTableModelTransform
implements TransformInterface {
    protected static final String localeDefaultDelimiter = Util.getCommonResources().getString("Delimiter.txt");
    protected String delimiters;
    protected String encoding;
    protected String[] columnHeaders;

    public CSVStreamToTableModelTransform() {
        this(localeDefaultDelimiter);
    }

    public CSVStreamToTableModelTransform(String delimiters) {
        this(delimiters, null);
    }

    public CSVStreamToTableModelTransform(String delimiters, String encoding) {
        this(null, delimiters, null);
    }

    public CSVStreamToTableModelTransform(String[] columnHeaders, String delimiters, String encoding) {
        this.columnHeaders = columnHeaders;
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        this.encoding = encoding;
    }

    public Object transform(Object input) throws TransformException {
        try {
            InputStream stream = (InputStream)input;
            String[] lines = this.readLines(stream, null);
            if (lines.length == 0) {
                if (this.columnHeaders == null) {
                    return new DefaultTableModel();
                }
                return new DefaultTableModel(this.columnHeaders, 0);
            }
            Object[] headers = this.columnHeaders;
            int startIndex = 0;
            if (headers == null) {
                headers = this.parseLineToArray(lines[startIndex++]);
            }
            DefaultTableModel model = new DefaultTableModel(headers, 0);
            for (int i = startIndex; i < lines.length; ++i) {
                model.addRow(this.parseLineToArray(lines[i]));
            }
            return model;
        }
        catch (IOException ioe) {
            throw new TransformException(ioe.getMessage());
        }
    }

    private String[] readLines(InputStream stream, String encoding) throws IOException {
        InputStreamReader reader = null;
        reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            list.add(line);
        }
        return list.toArray(new String[0]);
    }

    protected String[] parseLineToArray(String line) {
        try {
            ObjectTokenizer tokenizer = new ObjectTokenizer((Reader)new BufferedReader(new StringReader(line)));
            ArrayList<String> list = new ArrayList<String>();
            while (tokenizer.nextObject(this.delimiters, false) != -1) {
                if (tokenizer.getLastObject() == null) continue;
                list.add(tokenizer.getLastObject().toString());
            }
            return list.toArray(new String[0]);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }
}

