/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.errorhandlers;

import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.RB;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JOptionPaneErrorHandler
implements GenericErrorHandlerInterface,
Serializable {
    static final long serialVersionUID = 3329191431422271049L;
    public static final String RB_KEY = "JOptionPaneErrorHandler.";
    public static final String validationErrorText = RB.getStringResource("JOptionPaneErrorHandler.", "validationError.txt");
    static final String constructionExceptionText = RB.getStringResource("JOptionPaneErrorHandler.", "constructionException.txt");
    protected String titleString;
    protected int messageType = 0;
    protected Component component;
    protected String overrideMessage;

    public JOptionPaneErrorHandler() {
        this(null, null);
    }

    public JOptionPaneErrorHandler(String overrideMessage) {
        this(null, overrideMessage);
    }

    public JOptionPaneErrorHandler(Component frame) {
        this(frame, null);
    }

    public JOptionPaneErrorHandler(Component frame, String overrideMessage) {
        if (frame != null) {
            this.component = Util.getParentFrame(frame);
            if (this.component == null) {
                this.component = frame;
            }
        }
        this.overrideMessage = overrideMessage;
        this.titleString = null;
    }

    public void setTitle(String newTitle) {
        this.titleString = newTitle;
    }

    public String getTitle() {
        return this.titleString;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType == 1 ? messageType : (messageType == 2 ? messageType : (messageType == 3 ? messageType : (messageType == -1 ? messageType : 0)));
    }

    @Override
    public void handleError(Object object, Message message, String messageCode) {
        Component parentFrame = this.component;
        if (parentFrame == null) {
            parentFrame = object instanceof JComponent ? ((JComponent)object).getRootPane() : (object instanceof Component ? (Component)object : new JFrame());
        }
        Component parent = parentFrame;
        Message msg = message;
        LabelView label = new LabelView();
        label.setReplaceNewline(false);
        label.setReplaceTab(false);
        label.setText(this.overrideMessage == null ? msg.toString() : this.overrideMessage);
        label.setPreferredSpanSize(new Dimension(Math.max(100, Toolkit.getDefaultToolkit().getScreenSize().width - 150), -1));
        JOptionPane.showMessageDialog(parent, label, this.titleString == null ? validationErrorText : this.titleString, this.messageType);
    }
}

