/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.wizard;

import com.sas.swing.visuals.wizard.RB;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;

public class ButtonLayout
implements LayoutManager2 {
    public static final String RB_KEY = "ButtonLayout.";
    public static final String REMAINDER = "Remainder";
    protected Hashtable spaceRequestTable = new Hashtable();
    protected Hashtable rightSpaceTable = new Hashtable();
    protected Component remainderComponent;
    protected int justify = 2;
    protected float remainingPercentSpace = 1.0f;

    @Override
    public void addLayoutComponent(String string, Component comp) {
        this.addLayoutComponent(comp, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraint) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraint == null) {
                this.spaceRequestTable.put(comp, new Integer(0));
            } else if (constraint instanceof Integer) {
                if ((Integer)constraint < 0) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "negativeConstraintValue.ex.txt"));
                }
                this.spaceRequestTable.put(comp, constraint);
            } else if (constraint instanceof Float) {
                if (((Float)constraint).floatValue() < 0.0f || (double)((Float)constraint).floatValue() > 1.0) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidFloatConstraint1.ex.txt"));
                }
                if (((Float)constraint).floatValue() > this.remainingPercentSpace) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidFloatConstraint2.ex.txt"));
                }
                this.remainingPercentSpace -= ((Float)constraint).floatValue();
                this.spaceRequestTable.put(comp, constraint);
            } else {
                if (!(constraint instanceof String)) throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalConstraintObject.ex.txt"));
                if (!constraint.equals(REMAINDER)) throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalConstraintValue.ex.txt"));
                if (this.remainderComponent != null) {
                    this.spaceRequestTable.remove(this.remainderComponent);
                    this.spaceRequestTable.put(this.remainderComponent, new Integer(0));
                }
                this.remainderComponent = comp;
                this.spaceRequestTable.put(comp, constraint);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            Object request = this.spaceRequestTable.get(comp);
            if (request instanceof Float) {
                this.remainingPercentSpace += ((Float)request).floatValue();
            }
            if (comp == this.remainderComponent) {
                this.remainderComponent = null;
            }
            this.spaceRequestTable.remove(comp);
            this.rightSpaceTable.remove(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int width = 0;
            int height = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension dim = comp.getPreferredSize();
                Object spaceRequest = this.spaceRequestTable.get(comp);
                if (spaceRequest instanceof Integer) {
                    int space = (Integer)spaceRequest;
                    width += space;
                }
                width += dim.width;
                int currentHeight = dim.height;
                if (currentHeight <= height) continue;
                height = currentHeight;
            }
            return new Dimension(insets.left + insets.right + width, insets.top + insets.bottom + height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int width = 0;
            int height = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension dim = comp.getMinimumSize();
                Object spaceRequest = this.spaceRequestTable.get(comp);
                if (spaceRequest instanceof Integer) {
                    int space = (Integer)spaceRequest;
                    width += space;
                }
                width += dim.width;
                int currentHeight = dim.height;
                if (currentHeight <= height) continue;
                height = currentHeight;
            }
            return new Dimension(insets.left + insets.right + width, insets.top + insets.bottom + height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Object spaceRequest;
            int i;
            Component component;
            int remainderSpace = 0;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            int xspace = parent.getSize().width - (insets.left + insets.right);
            int yspace = parent.getSize().height - (insets.top + insets.bottom);
            int x = insets.left;
            int totalComponentWidths = 0;
            for (int i2 = 0; i2 < ncomponents; ++i2) {
                component = parent.getComponent(i2);
                totalComponentWidths += component.getPreferredSize().width;
            }
            int rightSpace = xspace - totalComponentWidths;
            for (i = 0; i < ncomponents; ++i) {
                component = parent.getComponent(i);
                spaceRequest = this.spaceRequestTable.get(component);
                if (!(spaceRequest instanceof Integer)) continue;
                this.rightSpaceTable.put(component, spaceRequest);
                rightSpace -= ((Integer)spaceRequest).intValue();
            }
            if (rightSpace > 0) {
                double percentRemaining = 1.0;
                for (int i3 = 0; i3 < ncomponents; ++i3) {
                    component = parent.getComponent(i3);
                    spaceRequest = this.spaceRequestTable.get(component);
                    if (!(spaceRequest instanceof Float)) continue;
                    float percentRequest = ((Float)spaceRequest).floatValue();
                    int compRightSpace = (int)(percentRequest * (float)rightSpace);
                    this.rightSpaceTable.put(component, new Integer(compRightSpace));
                    percentRemaining -= (double)percentRequest;
                }
                remainderSpace = (int)(percentRemaining * (double)rightSpace);
                if (this.remainderComponent != null) {
                    this.rightSpaceTable.put(this.remainderComponent, new Integer(remainderSpace));
                }
            } else {
                for (i = 0; i < ncomponents; ++i) {
                    component = parent.getComponent(i);
                    spaceRequest = this.spaceRequestTable.get(component);
                    if (!(spaceRequest instanceof Float) && !(spaceRequest instanceof String)) continue;
                    this.rightSpaceTable.put(component, new Integer(0));
                }
            }
            for (int i4 = 0; i4 < ncomponents; ++i4) {
                component = parent.getComponent(i4);
                Dimension size = component.getPreferredSize();
                int width = size.width;
                int height = size.height;
                int y = (yspace - height) / 2 + insets.top;
                if (i4 == 0 && this.remainderComponent == null && this.justify == 2) {
                    x += remainderSpace;
                }
                component.setBounds(x, y, width, height);
                int currentRightSpace = (Integer)this.rightSpaceTable.get(component);
                x += width + currentRightSpace;
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public void setJustification(int align) {
        if (align != 1 && align != 2) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidJustificationValue.ex.txt"));
        }
        this.justify = align;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraint(Component comp, Object constraint) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (this.spaceRequestTable.containsKey(comp)) {
                this.removeLayoutComponent(comp);
                this.addLayoutComponent(comp, constraint);
            }
        }
    }

    public Object getConstraint(Component comp) {
        return this.spaceRequestTable.get(comp);
    }
}

