/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.treetable.ZoneDefinition;

public class ZoneByTree
implements ZoneDefinition {
    int depth;

    public ZoneByTree(int d) {
        if (d < 0) {
            throw new IllegalArgumentException();
        }
        this.depth = d;
    }

    @Override
    public boolean equal(TreeTableRow r0, TreeTableRow r1) {
        if (this.contains(r0) && this.contains(r1)) {
            TreeTableRow r;
            int pathlen = this.depth + 1;
            TreeTableRow[] path = new TreeTableRow[pathlen];
            int px = -1;
            for (r = r0; r != null; r = (TreeTableRow)r.getParent()) {
                path[++px % pathlen] = r;
            }
            TreeTableRow z0 = path[(px + 1) % pathlen];
            for (r = r1; r != null; r = (TreeTableRow)r.getParent()) {
                if (r != z0) continue;
                return true;
            }
            return false;
        }
        return this.contains(r0) == this.contains(r1);
    }

    @Override
    public boolean equal(Object[] r0, Object[] r1) {
        return true;
    }

    @Override
    public boolean contains(TreeTableRow r) {
        return r != null && r.getLevel() >= this.depth;
    }

    @Override
    public boolean contains(Object[] r) {
        return false;
    }
}

