/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.CellAction;
import com.sas.swing.visuals.treetable.CellActionEvent;
import com.sas.swing.visuals.treetable.ConcatenatedFieldComparator;
import com.sas.swing.visuals.treetable.MultiLineHeaderCellRenderer;
import com.sas.swing.visuals.treetable.SasCellEditor;
import com.sas.swing.visuals.treetable.SasCellRenderer;
import com.sas.swing.visuals.treetable.TreeTableHeader;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.treetable.TreeTableRowRE;
import com.sas.swing.visuals.treetable.ZoneByData;
import com.sas.swing.visuals.treetable.ZoneByTree;
import com.sas.swing.visuals.treetable.Zones;
import com.sas.text.SASFormat;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeTable
extends JTable {
    public static final String RB_KEY = "TreeTable.";
    TreeTableRowRE jtree;
    int rowHeight = 1;
    TableCellRenderer treeTreeCellRenderer;
    TableCellRenderer flatTreeCellRenderer;
    String[] columnNames;
    TreeNode rootNode;
    boolean columnNamesCached;
    boolean rootNodeCached;
    TableModel model;
    Color[] bgcolors;
    Color[] fgcolors;
    TreeExpansionListener expansionEventToDataChangedEventRelay;
    TableModelListener modelChangeToRevalidateRelay;
    boolean wholeTableEditable;
    int preferredScrollableViewportWidth;
    int preferredScrollableViewportHeight;
    boolean wholeTableEditableIsValid;
    boolean preferredScrollableViewportWidthIsValid;
    boolean preferredScrollableViewportHeightIsValid;
    protected ConcatenatedFieldComparator sortCriteria;
    protected boolean displayedAsTree;
    protected JTableHeader sortHeader;
    protected MouseListener sortHeaderListener;
    Zones zones;
    protected int expansionEvents;
    protected boolean consumingEvents;
    protected boolean preserveSelectionAcrossNodeExpansion;
    protected int pressCount;
    protected int dragCount;
    protected int releaseCount;
    protected int clickCount;
    protected JPopupMenu cellPopup;
    protected boolean cellPopupEnabled;
    protected int popupCellRow;
    protected int popupCellColumn;
    protected Hashtable cellPopupActions;
    protected ActionListener linkListenerList;
    protected Color linkFgColor;
    protected Cursor linkCursor;
    protected Cursor defaultCursor;
    protected Point mouseLocation;
    protected Point mouseCell;
    protected boolean mouseIsOverLink;
    private boolean sortEnabled = true;
    Stack selectionStateStack = new Stack();
    ListSelectionListener[] selectionListeners;
    EventListener[] tableModelListeners;

    public TreeTable() {
        this.init();
    }

    public TreeTable(String[] columnNames) {
        this.init();
        this.setColumnNames(columnNames);
    }

    public TreeTable(TreeNode root, String[] columnNames) {
        this.init();
        this.setColumnNames(columnNames);
        this.setRoot(root);
    }

    public TreeTable(TableModel m) {
        super(m);
        this.init();
        this.setModel(m);
    }

    protected void init() {
        this.model = null;
        this.rowHeight = super.getRowHeight();
        this.flatTreeCellRenderer = null;
        this.treeTreeCellRenderer = this.jtree;
        this.expansionEventToDataChangedEventRelay = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                ++TreeTable.this.expansionEvents;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                ++TreeTable.this.expansionEvents;
            }
        };
        this.modelChangeToRevalidateRelay = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TreeTable.this.revalidate();
                TreeTable.this.repaint();
            }
        };
        this.rootNode = null;
        this.columnNames = null;
        this.columnNamesCached = false;
        this.rootNodeCached = false;
        this.wholeTableEditableIsValid = false;
        this.preferredScrollableViewportWidthIsValid = false;
        this.preferredScrollableViewportHeightIsValid = false;
        this.zones = new Zones(this);
        this.zones.setEnabled(false);
        this.displayedAsTree = true;
        this.expansionEvents = 0;
        this.consumingEvents = false;
        this.preserveSelectionAcrossNodeExpansion = true;
        this.sortInit();
        this.headerWorkaround();
        this.overrideRenderer(Object.class);
        this.overrideRenderer(Boolean.class);
        this.overrideRenderer(Double.class);
        this.overrideRenderer(Number.class);
        this.getTableHeader().setDefaultRenderer(new MultiLineHeaderCellRenderer());
        this.makeCellPopup();
        this.setSurrendersFocusOnKeystroke(true);
        this.linkFgColor = Color.blue;
        this.linkCursor = new Cursor(12);
        this.defaultCursor = super.getCursor();
        this.mouseLocation = new Point(-1, -1);
        this.mouseCell = new Point(-1, -1);
        this.mouseIsOverLink = false;
    }

    protected void overrideRenderer(Class c) {
        this.setDefaultRenderer(c, new SasCellRenderer(this.getDefaultRenderer(c)));
        this.setDefaultEditor(c, new SasCellEditor());
    }

    protected void headerWorkaround() {
        TableColumnModel cm = this.getTableHeader().getColumnModel();
        this.setTableHeader(new TreeTableHeader(cm));
    }

    protected void makeCellPopup() {
        this.cellPopup = new JPopupMenu();
        this.cellPopupActions = new Hashtable();
        this.addPredefinedCellPopupItems();
        this.cellPopupEnabled = false;
    }

    public void setCellPopupEnabled(boolean b) {
        this.cellPopupEnabled = b;
    }

    public boolean isCellPopupEnabled() {
        return this.cellPopupEnabled;
    }

    protected void showCellPopup(Point xy) {
        this.popupCellRow = this.rowAtPoint(xy);
        this.popupCellColumn = this.columnAtPoint(xy);
        this.updateCellPopupEnabledItems(this.popupCellRow, this.popupCellColumn);
        this.cellPopup.show(this, xy.x, xy.y);
    }

    public void addCellPopupItem(CellAction action) {
        String name = action.getName();
        if (this.cellPopupActions.containsKey(name)) {
            this.removeCellPopupItem(name);
        }
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new CellActionRelay(action));
        this.cellPopup.add(item);
        this.cellPopupActions.put(name, action);
    }

    public void removeCellPopupItem(String name) {
        if (name == null) {
            return;
        }
        int i = 0;
        while (i < this.cellPopup.getComponentCount()) {
            JMenuItem mi = (JMenuItem)this.cellPopup.getComponent(i);
            if (mi.getText().equals(name)) {
                this.cellPopup.remove(i);
                continue;
            }
            ++i;
        }
        this.cellPopupActions.remove(name);
    }

    public void removeCellPopupItem(int i) {
        Component ci = this.cellPopup.getComponent(i);
        if (ci instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)ci;
            String name = mi.getText();
            this.cellPopupActions.remove(name);
        }
        this.cellPopup.remove(i);
    }

    public void removeAllCellPopupItems() {
        this.cellPopupActions.clear();
        this.cellPopup.removeAll();
    }

    public void addPredefinedCellPopupItems() {
        Enumeration predefs = CellAction.getAllPredefinedCellActions();
        while (predefs.hasMoreElements()) {
            this.addCellPopupItem((CellAction)predefs.nextElement());
        }
    }

    private void updateCellPopupEnabledItems(int rx, int cx) {
        for (int i = 0; i < this.cellPopup.getComponentCount(); ++i) {
            JMenuItem mi = (JMenuItem)this.cellPopup.getComponent(i);
            String name = mi.getText();
            CellAction a = (CellAction)this.cellPopupActions.get(name);
            if (a == null) continue;
            TreeTable t = this;
            Object v = t.getValueAt(rx, cx);
            mi.setEnabled(a.isAvailable(t, rx, cx, v));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TreeTableRow ttr;
        super.tableChanged(e);
        if (this.rowHeight == 0 && this.defaultRenderersByColumnClass == null) {
            return;
        }
        if (this.model instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)this.model;
            int r1 = ttm.getRowCount(true);
            for (int rx = 0; rx < r1; ++rx) {
                ttr = ttm.getRowAt(rx, true);
                int h = ttr.getHeight();
                if (h <= 0) {
                    h = this.rowHeight;
                }
                if (h <= 0) {
                    for (int cx = 0; cx < this.getColumnCount(); ++cx) {
                        int cellHeight = this.getCellRenderer((int)rx, (int)cx).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)rx, (int)cx), (boolean)false, (boolean)false, (int)rx, (int)cx).getPreferredSize().height;
                        if (cellHeight <= h) continue;
                        h = cellHeight;
                    }
                }
                super.setRowHeight(rx, h);
            }
        }
        if (e != null && e.getColumn() >= 0 && e.getFirstRow() >= 0 && e.getFirstRow() == e.getLastRow()) {
            int oldRow = e.getFirstRow();
            int newRow = -1;
            TreeTableModel ttm = null;
            ttr = null;
            if (this.model instanceof TreeTableModel) {
                ttm = (TreeTableModel)this.model;
                ttr = ttm.getRowAt(oldRow, true);
            }
            this._sort(false);
            if (ttm != null && ttr != null && e instanceof TreeTableModel.MutableTableModelEvent) {
                TreeTableModel.MutableTableModelEvent me = (TreeTableModel.MutableTableModelEvent)e;
                int r1 = ttm.getRowCount(true);
                for (int rx = 0; rx < r1; ++rx) {
                    TreeTableRow rrx = ttm.getRowAt(rx, true);
                    if (rrx != ttr) continue;
                    newRow = rx;
                    break;
                }
                if (newRow >= 0) {
                    me.setFirstRow(newRow);
                    me.setLastRow(newRow);
                }
            }
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        if (this.displayedAsTree) {
            int treeColumnIndex = this.findTreeColumn();
            if (treeColumnIndex == -1) {
                return;
            }
            TableColumn treeColumn = this.getColumnModel().getColumn(treeColumnIndex);
            if (treeColumn == null) {
                return;
            }
            treeColumn.setCellRenderer(this.treeTreeCellRenderer);
        }
    }

    @Override
    public void setRowHeight(int rx, int height) {
        if (this.model instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)this.model;
            TreeTableRow ttr = ttm.getRowAt(rx);
            ttr.setHeight(height);
        }
        if (height <= 0) {
            height = this.getRowHeight();
        }
        super.setRowHeight(rx, height);
    }

    @Override
    public void setRowHeight(int newRowHeight) {
        if (this.model instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)this.model;
            for (int rx = 0; rx < ttm.getRowCount(false); ++rx) {
                TreeTableRow ttr = ttm.getRowAt(rx, false);
                ttr.setHeight(0);
            }
        }
        this.rowHeight = newRowHeight;
        int jtableRowHeight = newRowHeight;
        if (jtableRowHeight < 1) {
            jtableRowHeight = 1;
        }
        super.setRowHeight(jtableRowHeight);
        if (newRowHeight <= 0) {
            this.tableChanged(new TableModelEvent(this.model));
        }
    }

    public void setColumnNames(String[] names) {
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] != null) continue;
                throw new IllegalArgumentException("names[" + i + "]==null");
            }
        }
        this.columnNames = null;
        this.columnNamesCached = false;
        if (names == null) {
            return;
        }
        if (this.model != null && this.model instanceof TreeTableModel) {
            ((TreeTableModel)this.model).setColumnNames(names);
        } else if (this.model != null && this.model instanceof DefaultTableModel) {
            ((DefaultTableModel)this.model).setColumnIdentifiers(names);
        } else if (this.rootNodeCached) {
            this.setModel(new TreeTableModel(this.rootNode, names));
        } else {
            this.columnNames = names;
            this.columnNamesCached = true;
        }
    }

    public void setRoot(TreeNode root) {
        this.rootNode = null;
        this.rootNodeCached = false;
        if (root != null) {
            if (root instanceof MutableTreeNode) {
                ((MutableTreeNode)root).removeFromParent();
            } else if (root.getParent() != null) {
                throw new IllegalArgumentException("root.parent!=null && !root instanceof MutableTreeNode");
            }
        }
        if (this.model != null && this.model instanceof TreeTableModel) {
            ((TreeTableModel)this.model).setRoot(root);
        } else if (this.model != null) {
            String[] names = new String[this.model.getColumnCount()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.model.getColumnName(i);
            }
            this.setModel(new TreeTableModel(root, names));
        } else if (this.columnNamesCached) {
            this.setModel(new TreeTableModel(root, this.columnNames));
        } else {
            this.rootNode = root;
            this.rootNodeCached = true;
        }
    }

    @Override
    public void setModel(TableModel m) {
        TableModel oldModel = this.model;
        this.model = m;
        if (this.jtree != null && this.expansionEventToDataChangedEventRelay != null) {
            this.jtree.removeTreeExpansionListener(this.expansionEventToDataChangedEventRelay);
        }
        if (oldModel != null && this.modelChangeToRevalidateRelay != null) {
            oldModel.removeTableModelListener(this.modelChangeToRevalidateRelay);
        }
        if (oldModel != null && oldModel instanceof TreeTableModel) {
            ((TreeTableModel)oldModel).setTree(null);
            ((TreeTableModel)oldModel).setTreeTable(null);
        }
        this.columnNames = new String[m.getColumnCount()];
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columnNames[i] = m.getColumnName(i);
        }
        super.setModel(this.model);
        TreeTableModel ttm = null;
        if (m instanceof TreeTableModel) {
            ttm = (TreeTableModel)m;
            if (this.jtree == null) {
                this.jtree = new TreeTableRowRE();
                if (this.treeTreeCellRenderer == null) {
                    this.treeTreeCellRenderer = this.jtree;
                }
            }
            ttm.setTree(this.jtree);
            ttm.setTreeTable(this);
            this.jtree.setBackground(this.getBackground());
            this.jtree.setForeground(this.getForeground());
            this.jtree.setSelectionBackground(this.getSelectionBackground());
            this.jtree.setSelectionForeground(this.getSelectionForeground());
            this.jtree.setBorder(null);
            this.jtree.setFont(this.getFont());
            this.jtree.setTable(this);
            this._setDisplayedAsTree(this.displayedAsTree);
            if (this.expansionEventToDataChangedEventRelay != null) {
                this.jtree.addTreeExpansionListener(this.expansionEventToDataChangedEventRelay);
            }
            this.enableEvents(16L);
        }
        if (this.model != null && this.modelChangeToRevalidateRelay != null) {
            this.model.addTableModelListener(this.modelChangeToRevalidateRelay);
        }
        this.rootNode = null;
        this.columnNames = null;
        this.columnNamesCached = false;
        this.rootNodeCached = false;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.setMouseLocation(e.getX(), e.getY());
        if (this.consumingEvents) {
            if (e.getID() == 506 && this.pressCount == 1 && this.releaseCount == 0 && this.clickCount == 0) {
                ++this.dragCount;
                return;
            }
            this.consumingEvents = false;
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int treeColumnIndex;
        this.setMouseLocation(e.getX(), e.getY());
        int e_col = this.mouseCell.x;
        int e_row = this.mouseCell.y;
        if (e.getID() == 505) {
            this.setMouseLocation(-1, -1);
        }
        if (this.consumingEvents) {
            switch (e.getID()) {
                case 501: {
                    if (this.pressCount != 0 || this.dragCount != 0 || this.releaseCount != 0 || this.clickCount != 0) break;
                    ++this.pressCount;
                    e.consume();
                    return;
                }
                case 502: {
                    if (this.pressCount != 1 || this.releaseCount != 0 || this.clickCount != 0) break;
                    ++this.releaseCount;
                    if (this.dragCount > 0) {
                        this.consumingEvents = false;
                    }
                    e.consume();
                    return;
                }
                case 500: {
                    if (this.pressCount != 1 || this.dragCount != 0 || this.releaseCount != 1 || this.clickCount != 0) break;
                    ++this.clickCount;
                    this.consumingEvents = false;
                    e.consume();
                    return;
                }
                case 504: 
                case 505: {
                    e.consume();
                    return;
                }
            }
            this.consumingEvents = false;
        }
        if (this.isEditing() && e.getID() == 501 && (this.getEditingRow() != e_row || this.getEditingColumn() != e_col)) {
            this.getCellEditor().stopCellEditing();
            this.consumingEvents = true;
            this.pressCount = 1;
            this.clickCount = 0;
            this.releaseCount = 0;
            this.dragCount = 0;
            e.consume();
            return;
        }
        if (this.cellPopupEnabled && e.isPopupTrigger()) {
            this.showCellPopup(e.getPoint());
        }
        if (e.getID() == 501 && e.getClickCount() < 2 && this.displayedAsTree && this.jtree != null && !e.isControlDown() && (treeColumnIndex = this.findTreeColumn()) == e_col) {
            int treeX0 = 0;
            for (int i = 0; i < treeColumnIndex; ++i) {
                treeX0 += this.columnModel.getColumn(i).getWidth();
            }
            Rectangle e_row_rect = this.getCellRect(e_row, e_col, false);
            int e_row_y = e_row_rect.y;
            int e_row_h = e_row_rect.height;
            this.jtree.setRowHeight(e_row_h);
            MouseEvent fudged_e = new MouseEvent(this.jtree, e.getID(), e.getWhen(), e.getModifiers(), e.getX() - treeX0, e_row * e_row_h + e.getY() - e_row_y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            this.expansionEvents = 0;
            this.preTreeExpand();
            int old_nr = this.getRowCount();
            this.jtree.dispatchEvent(fudged_e);
            int new_nr = this.getRowCount();
            this.postTreeExpand(old_nr, new_nr, e_row_y, e_row_h, e_row);
            if (this.expansionEvents > 0) {
                this.consumingEvents = true;
                this.pressCount = 1;
                this.clickCount = 0;
                this.releaseCount = 0;
                this.dragCount = 0;
                e.consume();
                return;
            }
        }
        if (e.getID() == 501 && e.getButton() == 1 && (e.getModifiers() & 0xFFFFFBEF) == 0 && e.getClickCount() < 2 && this.isCellLink(e_row, e_col) && this.linkListenerList != null) {
            this.linkListenerList.actionPerformed(new CellActionEvent((Object)this, 1001, this.getLinkCommand(e_row, e_col), e_row, e_col));
            this.consumingEvents = true;
            this.pressCount = 1;
            this.clickCount = 0;
            this.releaseCount = 0;
            this.dragCount = 0;
            e.consume();
            return;
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyevent) {
        if (keyevent.getModifiers() == 2 && keyevent.getID() == 401 && (keyevent.getKeyCode() == 37 || keyevent.getKeyCode() == 39)) {
            Object rowObj;
            int e_row = this.selectionModel.getLeadSelectionIndex();
            int e_col = this.columnModel.getSelectionModel().getLeadSelectionIndex();
            if (e_row < 0) {
                return;
            }
            if (e_col < 0) {
                e_col = 0;
            }
            if (!((rowObj = this.getRow(e_row)) instanceof TreeTableRow)) {
                return;
            }
            TreePath path = new TreePath(((TreeTableRow)rowObj).getPath());
            Rectangle e_row_rect = this.getCellRect(e_row, e_col, false);
            int e_row_y = e_row_rect.y;
            int e_row_h = e_row_rect.height;
            this.expansionEvents = 0;
            this.preTreeExpand();
            int old_nr = this.getRowCount();
            if (this.jtree.isExpanded(path) && keyevent.getKeyCode() == 37) {
                this.jtree.collapsePath(path);
            } else if (!this.jtree.isExpanded(path) && keyevent.getKeyCode() == 39) {
                this.jtree.expandPath(path);
            }
            int new_nr = this.getRowCount();
            this.postTreeExpand(old_nr, new_nr, e_row_y, e_row_h, e_row);
            if (this.expansionEvents > 0) {
                keyevent.consume();
                return;
            }
        } else {
            super.processKeyEvent(keyevent);
        }
    }

    private void preTreeExpand() {
        if (this.preserveSelectionAcrossNodeExpansion) {
            this.saveSelectionState();
        } else {
            this.disconnectSelectionListeners();
        }
    }

    private void postTreeExpand(int old_nr, int new_nr, int e_row_y, int e_row_h, int e_row) {
        int newlyVisibleRows = new_nr - old_nr;
        if (newlyVisibleRows > 0 && this.jtree.getScrollsOnExpand()) {
            int newlyVisibleHeight = 0;
            for (int i = 1; i <= newlyVisibleRows; ++i) {
                newlyVisibleHeight += this.getCellRect((int)(e_row + i), (int)0, (boolean)true).height;
            }
            Rectangle newArea = new Rectangle(0, e_row_y + e_row_h, this.getWidth(), newlyVisibleHeight);
            this.scrollRectToVisible(newArea);
            this.validate();
        }
        SelectionState ss = (SelectionState)this.selectionStateStack.peek();
        int old_anchor = -1;
        int old_lead = -1;
        int numAnchorRows = ss.anchorRowNumbers.length;
        if (numAnchorRows > 0) {
            old_anchor = ss.anchorRowNumbers[0];
            old_lead = ss.anchorRowNumbers[numAnchorRows - 1];
        }
        if (this.preserveSelectionAcrossNodeExpansion && this.expansionEvents > 0 && newlyVisibleRows != 0 && (old_anchor > e_row || old_lead > e_row)) {
            int new_anchor = old_anchor;
            int new_lead = old_lead;
            if (newlyVisibleRows > 0) {
                if (old_anchor > e_row) {
                    new_anchor += newlyVisibleRows;
                }
                new_lead = old_anchor <= e_row ? e_row : (old_lead <= e_row ? e_row + newlyVisibleRows + 1 : (new_lead += newlyVisibleRows));
            } else if (old_anchor > e_row && old_anchor + newlyVisibleRows <= e_row && old_lead > e_row && old_lead + newlyVisibleRows <= e_row) {
                new_anchor = new_lead = e_row;
            } else {
                int bias;
                int n = bias = old_anchor > e_row && old_lead > e_row ? 1 : 0;
                if (new_anchor > e_row && (new_anchor += newlyVisibleRows) <= e_row) {
                    new_anchor = e_row + bias;
                }
                if (new_lead > e_row && (new_lead += newlyVisibleRows) < e_row) {
                    new_lead = e_row + bias;
                }
            }
            int nrows = 1 + (new_lead > new_anchor ? new_lead - new_anchor : new_anchor - new_lead);
            int dir = new_lead > new_anchor ? 1 : -1;
            Object[] newAnchorRows = new Object[nrows];
            int[] newAnchorRowNumbers = new int[nrows];
            int old_rxx = 0;
            int new_rx = new_anchor;
            for (int i = 0; i < nrows; ++i) {
                int old_rx;
                int n = old_rx = new_rx <= e_row ? new_rx : new_rx - newlyVisibleRows;
                while (old_rxx < ss.anchorRowNumbers.length && ss.anchorRowNumbers[old_rxx] != old_rx) {
                    ++old_rxx;
                }
                newAnchorRowNumbers[i] = new_rx;
                newAnchorRows[i] = this.getRow(new_rx);
                if (old_rxx >= ss.anchorRowNumbers.length) {
                    ss.anchorRowsSelected = false;
                    for (int sx = 0; sx < ss.selectedRowNumbers.length; ++sx) {
                        if (ss.selectedRowNumbers[sx] != new_rx) continue;
                        ss.anchorRowsSelected = true;
                        break;
                    }
                }
                new_rx += dir;
            }
            ss.anchorRowNumbers = newAnchorRowNumbers;
            ss.anchorRows = newAnchorRows;
        }
        if (this.preserveSelectionAcrossNodeExpansion) {
            if (this.expansionEvents > 0) {
                this.restoreSelectionState();
            } else {
                this.discardSavedSelectionState();
            }
        } else {
            this.reconnectSelectionListeners();
        }
    }

    public synchronized void addLinkListener(ActionListener l) {
        this.linkListenerList = AWTEventMulticaster.add(this.linkListenerList, l);
    }

    public synchronized void removeLinkListener(ActionListener l) {
        this.linkListenerList = AWTEventMulticaster.remove(this.linkListenerList, l);
    }

    public boolean isCellLink(int rx, int cx) {
        if (rx < 0 || cx < 0) {
            return false;
        }
        return this.getLinkCommand(rx, cx) != null;
    }

    public String getLinkCommand(int rx, int cx) {
        if (rx < 0 || cx < 0) {
            return null;
        }
        if (this.model instanceof TreeTableModel) {
            int mcx = this.getColumnIndex(cx);
            if (mcx < 0) {
                return null;
            }
            return ((TreeTableModel)this.model).getLinkCommand(rx, mcx, true);
        }
        return null;
    }

    public void setLinkCommand(int rx, int cx, String cmd) {
        if (rx < 0 || cx < 0) {
            return;
        }
        if (!(this.model instanceof TreeTableModel)) {
            return;
        }
        int mcx = this.getColumnIndex(cx);
        if (mcx < 0) {
            return;
        }
        ((TreeTableModel)this.model).setLinkCommand(cmd, rx, mcx, true);
    }

    public void setLinkForeground(Color lfg) {
        this.linkFgColor = lfg;
    }

    public Color getLinkForeground() {
        return this.linkFgColor;
    }

    public void setNormalCursor(Cursor c) {
        this.defaultCursor = c;
    }

    public Cursor getNormalCursor() {
        return this.defaultCursor;
    }

    public void setLinkCursor(Cursor c) {
        this.linkCursor = c;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    public boolean isMouseOver(int rx, int cx) {
        return this.mouseCell.x == cx && this.mouseCell.y == rx;
    }

    private void setMouseLocation(int x, int y) {
        this.mouseLocation.x = x;
        this.mouseLocation.y = y;
        int rx = this.rowAtPoint(this.mouseLocation);
        int cx = this.columnAtPoint(this.mouseLocation);
        boolean mouseWasOverLink = this.mouseIsOverLink;
        this.mouseIsOverLink = this.isCellLink(rx, cx);
        if (this.mouseIsOverLink != mouseWasOverLink) {
            super.setCursor(this.mouseIsOverLink ? this.linkCursor : this.defaultCursor);
        }
        if (this.mouseCell.x != cx || this.mouseCell.y != rx) {
            if (mouseWasOverLink) {
                this.repaint(this.getCellRect(this.mouseCell.y, this.mouseCell.x, true));
            }
            if (this.mouseIsOverLink) {
                this.repaint(this.getCellRect(rx, cx, true));
            }
            this.mouseCell.x = cx;
            this.mouseCell.y = rx;
        }
    }

    public void setPreserveSelectionAcrossNodeExpansion(boolean b) {
        this.preserveSelectionAcrossNodeExpansion = b;
    }

    public boolean getPreserveSelectionAcrossNodeExpansion() {
        return this.preserveSelectionAcrossNodeExpansion;
    }

    @Override
    public void changeSelection(int rx, int cx, boolean toggle, boolean extend) {
        if (this.getRowSelectionAllowed() || toggle && extend) {
            super.changeSelection(rx, cx, toggle, extend);
        }
    }

    public int findTreeColumn() {
        return this.getColumnPosition(0);
    }

    public int getColumnIndex(Object id) {
        int columnPosition = this.columnModel.getColumnIndex(id);
        return this.getColumnIndex(columnPosition);
    }

    public int getColumnIndex(int columnPosition) {
        return this.columnModel.getColumn(columnPosition).getModelIndex();
    }

    public int getColumnPosition(int columnIndex) {
        for (int cp = 0; cp < this.columnModel.getColumnCount(); ++cp) {
            if (this.getColumnIndex(cp) != columnIndex) continue;
            return cp;
        }
        return -1;
    }

    public void setColumnFormat(int columnPosition, SASFormat f) {
        TableColumn c = this.getColumnModel().getColumn(columnPosition);
        if (columnPosition == this.findTreeColumn()) {
            if (this.flatTreeCellRenderer instanceof SasCellRenderer) {
                ((SasCellRenderer)this.flatTreeCellRenderer).setFormat(f);
            } else {
                this.flatTreeCellRenderer = new SasCellRenderer(f);
                c.setCellRenderer(this.flatTreeCellRenderer);
            }
            if (this.treeTreeCellRenderer instanceof SasCellRenderer) {
                ((SasCellRenderer)this.treeTreeCellRenderer).setFormat(f);
            } else {
                this.treeTreeCellRenderer = new SasCellRenderer(f);
                ((SasCellRenderer)this.treeTreeCellRenderer).setInnerRenderer(this.jtree);
                c.setCellRenderer(this.treeTreeCellRenderer);
            }
        } else {
            TableCellRenderer r = c.getCellRenderer();
            if (r instanceof SasCellRenderer) {
                ((SasCellRenderer)r).setFormat(f);
            } else {
                c.setCellRenderer(new SasCellRenderer(f));
            }
        }
        TableCellEditor e = c.getCellEditor();
        if (e instanceof SasCellEditor) {
            ((SasCellEditor)e).setFormat(f);
        } else {
            c.setCellEditor(new SasCellEditor(f));
        }
    }

    public SASFormat getColumnFormat(int columnPosition) {
        TableCellEditor e;
        SASFormat rf = null;
        SASFormat ef = null;
        TableColumn c = this.getColumnModel().getColumn(columnPosition);
        TableCellRenderer r = c.getCellRenderer();
        if (r instanceof SasCellRenderer) {
            rf = ((SasCellRenderer)r).getFormat();
        }
        if ((e = c.getCellEditor()) instanceof SasCellEditor) {
            ef = ((SasCellEditor)e).getFormat();
        }
        return ef == rf ? ef : null;
    }

    public void expandToDepth(int d, boolean c) {
        if (this.model instanceof TreeTableModel) {
            ((TreeTableModel)this.model).expandToDepth(d, c);
        }
    }

    public void setDisplayedAsTree(boolean d) {
        if (this.displayedAsTree != d) {
            this._setDisplayedAsTree(d);
        }
    }

    private void _setDisplayedAsTree(boolean d) {
        boolean d0 = this.displayedAsTree;
        int treeColumnIndex = this.findTreeColumn();
        if (treeColumnIndex == -1) {
            return;
        }
        this.saveSelectionState();
        TableColumn treeColumn = this.getColumnModel().getColumn(treeColumnIndex);
        if (d && !d0) {
            this.flatTreeCellRenderer = treeColumn.getCellRenderer();
        } else if (d0 & !d) {
            this.treeTreeCellRenderer = treeColumn.getCellRenderer();
        }
        if (d) {
            treeColumn.setCellRenderer(this.treeTreeCellRenderer);
        } else {
            treeColumn.setCellRenderer(this.flatTreeCellRenderer);
        }
        if (this.model instanceof TreeTableModel) {
            ((TreeTableModel)this.model).setDisplayedAsTree(d);
        }
        this.displayedAsTree = d;
        this.restoreSelectionState();
        this.repaint();
    }

    public boolean isDisplayedAsTree() {
        return this.displayedAsTree;
    }

    public void clearZones() {
        this.zones.clear();
    }

    public void addTreeZone(int depth) {
        this.zones.add(new ZoneByTree(depth));
    }

    public void addDataZone(int field) {
        this.zones.add(new ZoneByData(field));
    }

    public void addDataZone(Object id) {
        this.addDataZone(this.getColumnIndex(id));
    }

    public boolean getZonesEnabled() {
        return this.zones.getEnabled();
    }

    public void setZonesEnabled(boolean e) {
        this.zones.setEnabled(e);
        this.repaint();
    }

    public Zones getZones() {
        return this.zones;
    }

    public void setZones(Zones z) {
        this.zones = z;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g instanceof Graphics2D) {
            this.zones.paint((Graphics2D)g, this);
        }
    }

    private void sortInit() {
        this.sortCriteria = new ConcatenatedFieldComparator();
        this.sortCriteria.setEventSource(this);
        this.setSortLocale(this.getLocale());
        this.sortHeaderListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreeTable.this.sortOnClickedColumn(e);
            }
        };
    }

    public void setSortLocale(Locale x) {
        Collator c = null;
        if (x != null) {
            c = Collator.getInstance(x);
        }
        this.sortCriteria.setCollator(c);
    }

    public void clearSortFields() {
        this.sortCriteria.clearFields();
    }

    public void addSortField(int s) {
        this.sortCriteria.addField(s);
    }

    public void addSortField(int s, boolean a) {
        this.sortCriteria.addField(s, a);
    }

    public void addSortField(int s, boolean a, Comparator c) {
        this.sortCriteria.addField(s, a, c);
    }

    public void addSortField(int s, boolean a, SASFormat f) {
        this.sortCriteria.addField(s, a, f);
    }

    public void addSortField(Object id) {
        this.addSortField(this.getColumnIndex(id));
    }

    public void addSortField(Object id, boolean a) {
        this.addSortField(this.getColumnIndex(id), a);
    }

    public void addSortField(Object id, boolean a, Comparator c) {
        this.addSortField(this.getColumnIndex(id), a, c);
    }

    public void addSortField(Object id, boolean a, SASFormat f) {
        this.addSortField(this.getColumnIndex(id), a, f);
    }

    public int getSortLength() {
        return this.sortCriteria.getLength();
    }

    public int getSortField(int i) {
        return this.sortCriteria.getSortField(i);
    }

    public boolean getSortAscending(int i) {
        return this.sortCriteria.getAscending(i);
    }

    public Comparator getSortComparator(int i) {
        return this.sortCriteria.getComparator(i);
    }

    public SASFormat getSortFormatter(int i) {
        return this.sortCriteria.getFormatter(i);
    }

    public void addSortListener(ActionListener sl) {
        this.sortCriteria.addActionListener(sl);
    }

    public void removeSortListener(ActionListener sl) {
        this.sortCriteria.removeActionListener(sl);
    }

    public void enableSortEvents() {
        this.sortCriteria.setActionEventsEnabled(true);
    }

    public void disableSortEvents() {
        this.sortCriteria.setActionEventsEnabled(false);
    }

    protected void listenToHeader() {
        if (this.sortHeader != null) {
            this.sortHeader.removeMouseListener(this.sortHeaderListener);
        }
        if (this.isSortEnabled()) {
            this.sortHeader = this.getTableHeader();
            this.sortHeader.addMouseListener(this.sortHeaderListener);
        }
    }

    public final boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public final void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        this.listenToHeader();
    }

    protected void sortOnClickedColumn(MouseEvent e) {
        JTableHeader h = this.getTableHeader();
        int columnPosition = h.columnAtPoint(e.getPoint());
        if (columnPosition == -1) {
            return;
        }
        int columnIndex = this.getColumnIndex(columnPosition);
        boolean ascending = true;
        if (this.sortCriteria.getLength() > 0 && this.sortCriteria.getSortField(0) == columnIndex) {
            ascending = !this.sortCriteria.getAscending(0);
        }
        this.sortCriteria.prependField(columnIndex, ascending);
        this.sort();
    }

    public void sort() {
        this._sort(true);
    }

    public void _sort(boolean fireChangeEvent) {
        this.saveSelectionState();
        if (this.model instanceof TreeTableModel) {
            ((TreeTableModel)this.model).sort(this.sortCriteria);
        } else {
            int rownum;
            int nrows = this.getRowCount();
            ArrayList<Object> rows = new ArrayList<Object>(nrows);
            for (rownum = 0; rownum < nrows; ++rownum) {
                rows.add(this.getRow(rownum));
            }
            try {
                Collections.sort(rows, this.sortCriteria);
            }
            catch (UnsupportedOperationException x) {
                throw new Error("coding error! " + x);
            }
            catch (ClassCastException x) {
                throw new Error("coding error! " + x);
            }
            this.disconnectDataModelListeners();
            for (rownum = 0; rownum < nrows; ++rownum) {
                this.setRow(rownum, rows.get(rownum));
            }
            this.reconnectDataModelListeners();
            if (fireChangeEvent && this.model instanceof AbstractTableModel) {
                ((AbstractTableModel)this.model).fireTableDataChanged();
            }
        }
        this.restoreSelectionState();
    }

    protected void saveSelectionState() {
        if (this.selectionStateStack == null) {
            return;
        }
        if (this.selectionStateStack.empty()) {
            this.disconnectSelectionListeners();
        }
        SelectionState ss = new SelectionState();
        ss.selectedRowNumbers = this.getSelectedRows();
        int nsel = ss.selectedRowNumbers.length;
        ss.selectedRows = new Object[nsel];
        for (int i = 0; i < nsel; ++i) {
            ss.selectedRows[i] = this.getRow(ss.selectedRowNumbers[i]);
        }
        int rowCount = this.getRowCount();
        ListSelectionModel selmodel = this.getSelectionModel();
        int anchorRowNumber = selmodel.getAnchorSelectionIndex();
        int leadRowNumber = selmodel.getLeadSelectionIndex();
        if (anchorRowNumber >= 0 && anchorRowNumber < rowCount && leadRowNumber >= 0 && leadRowNumber < rowCount) {
            int dir = anchorRowNumber <= leadRowNumber ? 1 : -1;
            int anchorRows_length = (leadRowNumber - anchorRowNumber) * dir + 1;
            ss.anchorRowNumbers = new int[anchorRows_length];
            ss.anchorRows = new Object[anchorRows_length];
            for (int i = 0; i < anchorRows_length; ++i) {
                int rx;
                ss.anchorRowNumbers[i] = rx = anchorRowNumber + i * dir;
                ss.anchorRows[i] = this.getRow(rx);
            }
            ss.anchorRowsSelected = selmodel.isSelectedIndex(anchorRowNumber);
        } else {
            ss.anchorRows = new Object[0];
            ss.anchorRowNumbers = new int[0];
        }
        this.selectionStateStack.push(ss);
    }

    protected void restoreSelectionState() {
        int nsel;
        if (this.selectionStateStack == null) {
            return;
        }
        if (this.selectionStateStack.empty()) {
            return;
        }
        SelectionState ss = (SelectionState)this.selectionStateStack.pop();
        this.clearSelection();
        int moves = 0;
        int firstSel = -1;
        int lastSel = -1;
        int newAnchorIndex = -1;
        int newLeadIndex = -1;
        ListSelectionModel m = this.getSelectionModel();
        m.setValueIsAdjusting(!(m instanceof DefaultListSelectionModel));
        Object anchorRow = null;
        Object leadRow = null;
        if (ss.anchorRows.length > 0) {
            anchorRow = ss.anchorRows[0];
            leadRow = ss.anchorRows[ss.anchorRows.length - 1];
        }
        if (anchorRow == null) {
            newAnchorIndex = m.getAnchorSelectionIndex();
        }
        if (leadRow == null) {
            newLeadIndex = m.getLeadSelectionIndex();
        }
        int nrestore = nsel = ss.selectedRows.length;
        if (anchorRow != null) {
            ++nrestore;
        }
        if (leadRow != null) {
            ++nrestore;
        }
        if (nrestore > 0) {
            int rowCount = this.getRowCount();
            for (int rx = 0; rx < rowCount && nrestore > 0; ++rx) {
                int sx;
                Object row = this.getRow(rx);
                if (newAnchorIndex < 0 && anchorRow != null && this.rowsEqual(row, anchorRow)) {
                    newAnchorIndex = rx;
                    --nrestore;
                }
                if (newLeadIndex < 0 && leadRow != null && this.rowsEqual(row, leadRow)) {
                    newLeadIndex = rx;
                    --nrestore;
                }
                for (sx = 0; sx < nsel && !this.rowsEqual(row, ss.selectedRows[sx]); ++sx) {
                }
                if (sx >= nsel) continue;
                int oldRx = ss.selectedRowNumbers[sx];
                if (rx != oldRx) {
                    if (moves == 0) {
                        firstSel = lastSel = rx;
                    }
                    ++moves;
                    if (rx < firstSel) {
                        firstSel = rx;
                    }
                    if (rx > lastSel) {
                        lastSel = rx;
                    }
                    if (oldRx < firstSel) {
                        firstSel = oldRx;
                    }
                    if (oldRx > lastSel) {
                        lastSel = oldRx;
                    }
                }
                this.addRowSelectionInterval(rx, rx);
                ss.selectedRows[sx] = ss.selectedRows[nsel - 1];
                ss.selectedRowNumbers[sx] = ss.selectedRowNumbers[nsel - 1];
                --nsel;
                --nrestore;
            }
            for (int sx = 0; sx < nsel; ++sx) {
                int oldRx = ss.selectedRowNumbers[sx];
                if (moves == 0) {
                    firstSel = lastSel = oldRx;
                }
                ++moves;
                if (oldRx < firstSel) {
                    firstSel = oldRx;
                }
                if (oldRx <= lastSel) continue;
                lastSel = oldRx;
            }
            if (moves > 0 && m instanceof DefaultListSelectionModel) {
                this.touchSelection(m, firstSel);
                m.setValueIsAdjusting(true);
                this.touchSelection(m, firstSel);
                if (firstSel != lastSel) {
                    this.touchSelection(m, lastSel);
                }
            }
            boolean preserveAllAnchorRows = true;
            int nrows = ss.anchorRows.length;
            int oldAnchorIndex = -1;
            int oldLeadIndex = -1;
            if (nrows > 0) {
                oldAnchorIndex = ss.anchorRowNumbers[0];
                oldLeadIndex = ss.anchorRowNumbers[nrows - 1];
            }
            if (newAnchorIndex < 0 || newLeadIndex < 0 || nrows < 0 || this.abs(newLeadIndex - newAnchorIndex) != this.abs(oldLeadIndex - oldAnchorIndex)) {
                preserveAllAnchorRows = false;
            } else {
                int newdir = newAnchorIndex <= newLeadIndex ? 1 : -1;
                for (int i = 0; i < nrows; ++i) {
                    int new_rx = newAnchorIndex + i * newdir;
                    if (this.rowsEqual(ss.anchorRows[i], this.getRow(new_rx))) continue;
                    preserveAllAnchorRows = false;
                    break;
                }
            }
            if (!preserveAllAnchorRows) {
                for (int rx = 0; rx < rowCount && newAnchorIndex < 0; ++rx) {
                    Object row_rx = this.getRow(rx);
                    for (int i = 0; i < nrows && newAnchorIndex < 0; ++i) {
                        if (!this.rowsEqual(row_rx, ss.anchorRows[i])) continue;
                        newAnchorIndex = rx;
                    }
                }
                if (newAnchorIndex < 0) {
                    newAnchorIndex = 0;
                    ss.anchorRowsSelected = m.isSelectedIndex(newAnchorIndex);
                }
                newLeadIndex = newAnchorIndex;
            }
            this._select(m, newAnchorIndex, newLeadIndex, ss.anchorRowsSelected);
        }
        if (this.selectionStateStack.empty()) {
            this.reconnectSelectionListeners();
        }
        if (moves > 0) {
            m.setValueIsAdjusting(false);
        }
    }

    protected void discardSavedSelectionState() {
        int n = this.selectionStateStack.size();
        if (n > 0) {
            this.selectionStateStack.pop();
        }
        if (n == 1) {
            this.reconnectSelectionListeners();
        }
    }

    private void touchSelection(ListSelectionModel m, int rx) {
        boolean select = m.isSelectedIndex(rx);
        this._select(m, rx, rx, !select);
        this._select(m, rx, rx, select);
    }

    private void _select(ListSelectionModel m, int rx0, int rx1, boolean sel) {
        if (sel) {
            m.addSelectionInterval(rx0, rx1);
        } else {
            m.removeSelectionInterval(rx0, rx1);
        }
    }

    private int abs(int a) {
        return a >= 0 ? a : -a;
    }

    protected void disconnectSelectionListeners() {
        ListSelectionModel m = this.getSelectionModel();
        if (this.selectionListeners == null) {
            if (m instanceof DefaultListSelectionModel) {
                DefaultListSelectionModel dm = (DefaultListSelectionModel)m;
                this.selectionListeners = dm.getListSelectionListeners();
                for (int i = 0; i < this.selectionListeners.length; ++i) {
                    dm.removeListSelectionListener(this.selectionListeners[i]);
                }
            } else {
                m.setValueIsAdjusting(true);
            }
        }
    }

    protected void reconnectSelectionListeners() {
        if (this.selectionListeners != null) {
            ListSelectionModel m = this.getSelectionModel();
            for (int i = 0; i < this.selectionListeners.length; ++i) {
                m.addListSelectionListener(this.selectionListeners[i]);
                this.selectionListeners[i] = null;
            }
        }
        this.selectionListeners = null;
    }

    protected void disconnectDataModelListeners() {
        TableModel m = this.getModel();
        if (this.tableModelListeners == null && m instanceof AbstractTableModel) {
            AbstractTableModel atm = (AbstractTableModel)m;
            this.tableModelListeners = atm.getListeners(TableModelListener.class);
            for (int i = 0; i < this.tableModelListeners.length; ++i) {
                atm.removeTableModelListener((TableModelListener)this.tableModelListeners[i]);
            }
        }
    }

    protected void reconnectDataModelListeners() {
        TableModel m = this.getModel();
        if (this.tableModelListeners != null && m instanceof AbstractTableModel) {
            for (int i = 0; i < this.tableModelListeners.length; ++i) {
                m.addTableModelListener((TableModelListener)this.tableModelListeners[i]);
                this.tableModelListeners[i] = null;
            }
        }
        this.tableModelListeners = null;
    }

    protected Object getRow(int rownum) {
        if (this.model instanceof TreeTableModel) {
            return ((TreeTableModel)this.model).getRowAt(rownum);
        }
        int ncols = this.model.getColumnCount();
        Object[] row = new Object[ncols];
        for (int colnum = 0; colnum < ncols; ++colnum) {
            row[colnum] = this.model.getValueAt(rownum, colnum);
        }
        return row;
    }

    protected void setRow(int rownum, Object x) {
        if (!(this.model instanceof TreeTableModel)) {
            int ncols = this.model.getColumnCount();
            Object[] row = (Object[])x;
            for (int colnum = 0; colnum < ncols; ++colnum) {
                this.model.setValueAt(row[colnum], rownum, colnum);
            }
        }
    }

    protected boolean rowsEqual(Object x1, Object x2) {
        if (this.model instanceof TreeTableModel) {
            return x1 == x2;
        }
        int ncols = this.model.getColumnCount();
        Object[] row1 = (Object[])x1;
        Object[] row2 = (Object[])x2;
        for (int colnum = 0; colnum < ncols; ++colnum) {
            if (row1[colnum] == row2[colnum]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setTableHeader(JTableHeader h) {
        super.setTableHeader(h);
        this.listenToHeader();
    }

    @Override
    public String getColumnName(int cx) {
        if (cx < 0) {
            throw new IndexOutOfBoundsException("" + cx + "<0");
        }
        int mx = this.convertColumnIndexToModel(cx);
        if (mx < 0) {
            throw new IndexOutOfBoundsException("" + mx + "<0");
        }
        if (this.model != null) {
            int max = this.model.getColumnCount() - 1;
            if (mx > max) {
                throw new IndexOutOfBoundsException("" + mx + ">" + max);
            }
            return this.model.getColumnName(mx);
        }
        if (this.columnNamesCached) {
            int max = this.columnNames.length - 1;
            if (mx > max) {
                throw new IndexOutOfBoundsException("" + mx + ">" + max);
            }
            return this.columnNames[mx];
        }
        return "";
    }

    public Object getRoot() {
        if (this.model != null) {
            if (this.model instanceof TreeTableModel) {
                return ((TreeTableModel)this.model).getRoot();
            }
            return null;
        }
        if (this.rootNodeCached) {
            return this.rootNode;
        }
        return null;
    }

    @Override
    public int getEditingRow() {
        return this.convertColumnIndexToModel(this.editingColumn) == 0 ? -1 : this.editingRow;
    }

    public void setBackgroundArray(Color[] bgs) {
        this.bgcolors = bgs;
    }

    public Color[] getBackgroundArray() {
        return this.bgcolors;
    }

    public void setForegroundArray(Color[] fgs) {
        this.fgcolors = fgs;
    }

    public Color[] getForegroundArray() {
        return this.fgcolors;
    }

    @Override
    public void setShowHorizontalLines(boolean showHorizontalLines) {
        super.setShowHorizontalLines(showHorizontalLines);
        this.setRowMargin(showHorizontalLines ? 1 : 0);
    }

    @Override
    public void setShowVerticalLines(boolean showVerticalLines) {
        super.setShowVerticalLines(showVerticalLines);
        this.getColumnModel().setColumnMargin(showVerticalLines ? 1 : 0);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.jtree != null) {
            this.jtree.setBackground(bg);
        }
        super.setBackground(bg);
        this.setOpaque(bg.getAlpha() == 255);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.jtree != null) {
            this.jtree.setForeground(fg);
        }
        super.setForeground(fg);
    }

    @Override
    public void setSelectionBackground(Color bg) {
        if (this.jtree != null) {
            this.jtree.setSelectionBackground(bg);
        }
        super.setSelectionBackground(bg);
    }

    @Override
    public void setSelectionForeground(Color fg) {
        if (this.jtree != null) {
            this.jtree.setSelectionForeground(fg);
        }
        super.setSelectionForeground(fg);
    }

    @Override
    public void clearSelection() {
        if (this.jtree != null) {
            this.jtree.clearSelection();
        }
        super.clearSelection();
    }

    @Override
    public void setFont(Font f) {
        if (this.jtree != null) {
            this.jtree.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public int getRowCount() {
        return this.model != null ? this.model.getRowCount() : 0;
    }

    public void setFlatCellRenderer(TableCellRenderer r) {
        this.flatTreeCellRenderer = r;
        if (!this.displayedAsTree) {
            this._setDisplayedAsTree(this.displayedAsTree);
        }
    }

    public TableCellRenderer getFlatCellRenderer() {
        return this.flatTreeCellRenderer;
    }

    public void setEditable(boolean flag) {
        this.wholeTableEditable = flag;
        this.wholeTableEditableIsValid = true;
    }

    public void unsetEditable() {
        this.wholeTableEditableIsValid = false;
    }

    @Override
    public boolean isCellEditable(int rx, int cx) {
        boolean myVote = this.wholeTableEditableIsValid ? this.wholeTableEditable : this.model.isCellEditable(rx, this.getColumnIndex(cx));
        return myVote && this.getCellEditor(rx, cx).isCellEditable(null);
    }

    public boolean isEditable() {
        return this.wholeTableEditable;
    }

    public boolean isEditableSet() {
        return this.wholeTableEditableIsValid;
    }

    public void setRootVisible(boolean v) {
        if (this.model instanceof TreeTableModel) {
            this.saveSelectionState();
            ((TreeTableModel)this.model).setRootVisible(v);
            this.restoreSelectionState();
        }
    }

    public void setPreferredScrollableViewportWidth(int w) {
        this.preferredScrollableViewportWidth = w;
        this.preferredScrollableViewportWidthIsValid = true;
    }

    public void unsetPreferredScrollableViewportWidth() {
        this.preferredScrollableViewportWidthIsValid = false;
    }

    public void setPreferredScrollableViewportHeight(int h) {
        this.preferredScrollableViewportHeight = h;
        this.preferredScrollableViewportHeightIsValid = true;
    }

    public void unsetPreferredScrollableViewportHeight() {
        this.preferredScrollableViewportHeightIsValid = false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        boolean wv = this.preferredScrollableViewportWidthIsValid;
        boolean hv = this.preferredScrollableViewportHeightIsValid;
        if (wv && hv) {
            return new Dimension(this.preferredScrollableViewportWidth, this.preferredScrollableViewportHeight);
        }
        Dimension super_d = super.getPreferredScrollableViewportSize();
        if (!wv && !hv) {
            return super_d;
        }
        return new Dimension(wv ? this.preferredScrollableViewportWidth : super_d.width, hv ? this.preferredScrollableViewportHeight : super_d.height);
    }

    public void setVisibleRowCount(int newCount) {
        this.setPreferredScrollableViewportHeight(this.getRowHeight() * newCount);
        this.invalidate();
    }

    public int getVisibleRowCount() {
        return this.getHeight() / this.getRowHeight();
    }

    public void setTreeVisibleRowCount(int rowCount) {
        if (this.jtree != null) {
            this.jtree.setVisibleRowCount(rowCount);
        }
    }

    public int getTreeVisibleRowCount() {
        return this.jtree == null ? 0 : this.jtree.getVisibleRowCount();
    }

    public void collapsePath(TreePath path) {
        if (this.jtree != null) {
            this.jtree.collapsePath(path);
        }
    }

    public void expandPath(TreePath path) {
        if (this.jtree != null) {
            this.jtree.expandPath(path);
        }
    }

    public void addSelectionPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.addSelectionPath(p);
        }
    }

    public void addSelectionPaths(TreePath[] ps) {
        if (this.jtree != null) {
            this.jtree.addSelectionPaths(ps);
        }
    }

    public void fireTreeCollapsed(TreePath path) {
        if (this.jtree != null) {
            this.jtree.fireTreeCollapsed(path);
        }
    }

    public void fireTreeExpanded(TreePath path) {
        if (this.jtree != null) {
            this.jtree.fireTreeExpanded(path);
        }
    }

    public void fireTreeWillCollapse(TreePath path) throws ExpandVetoException {
        if (this.jtree != null) {
            this.jtree.fireTreeWillCollapse(path);
        }
    }

    public void fireTreeWillExpand(TreePath path) throws ExpandVetoException {
        if (this.jtree != null) {
            this.jtree.fireTreeWillExpand(path);
        }
    }

    public Enumeration getExpandedDescendants(TreePath p) {
        return this.jtree == null ? null : this.jtree.getExpandedDescendants(p);
    }

    public Rectangle getPathBounds(TreePath path) {
        return this.jtree == null ? null : this.jtree.getPathBounds(path);
    }

    public int getRowForPath(TreePath path) {
        return this.jtree == null ? 0 : this.jtree.getRowForPath(path);
    }

    public boolean hasBeenExpanded(TreePath p) {
        return this.jtree == null ? false : this.jtree.hasBeenExpanded(p);
    }

    public boolean isCollapsed(TreePath p) {
        return this.jtree == null ? false : this.jtree.isCollapsed(p);
    }

    public boolean isExpanded(TreePath p) {
        return this.jtree == null ? false : this.jtree.isExpanded(p);
    }

    public boolean isPathEditable(TreePath p) {
        return this.jtree == null ? false : this.jtree.isPathEditable(p);
    }

    public boolean isPathSelected(TreePath p) {
        return this.jtree == null ? false : this.jtree.isPathSelected(p);
    }

    public boolean isVisible(TreePath p) {
        return this.jtree == null ? false : this.jtree.isVisible(p);
    }

    public void makeVisible(TreePath p) {
        if (this.jtree != null) {
            this.jtree.makeVisible(p);
        }
    }

    public void removeSelectionPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.removeSelectionPath(p);
        }
    }

    public void removeSelectionPaths(TreePath[] paths) {
        if (this.jtree != null) {
            this.jtree.removeSelectionPaths(paths);
        }
    }

    public void scrollPathToVisible(TreePath p) {
        if (this.jtree != null) {
            this.jtree.scrollPathToVisible(p);
        }
    }

    public void setAnchorSelectionPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.setAnchorSelectionPath(p);
        }
    }

    public void setLeadSelectionPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.setLeadSelectionPath(p);
        }
    }

    public void setSelectionPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.setSelectionPath(p);
        }
    }

    public void setSelectionPaths(TreePath[] paths) {
        if (this.jtree != null) {
            this.jtree.setSelectionPaths(paths);
        }
    }

    public void startEditingAtPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.startEditingAtPath(p);
        }
    }

    public void addSelectionInterval(int i0, int i1) {
        if (this.jtree != null) {
            this.jtree.addSelectionInterval(i0, i1);
        }
    }

    public void addSelectionRow(int row) {
        if (this.jtree != null) {
            this.jtree.addSelectionRow(row);
        }
    }

    public void addSelectionRows(int[] rows) {
        if (this.jtree != null) {
            this.jtree.addSelectionRows(rows);
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        if (this.jtree != null) {
            this.jtree.addTreeExpansionListener(l);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        if (this.jtree != null) {
            this.jtree.addTreeSelectionListener(l);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener l) {
        if (this.jtree != null) {
            this.jtree.addTreeWillExpandListener(l);
        }
    }

    public void cancelEditing() {
        if (this.jtree != null) {
            this.jtree.cancelEditing();
        }
    }

    public void collapseRow(int row) {
        this._remap();
        if (this.jtree != null) {
            this.jtree.collapseRow(row);
        }
    }

    public String convertValueToText(Object v, boolean s, boolean e, boolean l, int r, boolean f) {
        return this.jtree == null ? null : this.jtree.convertValueToText(v, s, e, l, r, f);
    }

    public void expandRow(int row) {
        this._remap();
        if (this.jtree != null) {
            this.jtree.expandRow(row);
        }
    }

    public AccessibleContext getTreeAccessibleContext() {
        return this.jtree == null ? null : this.jtree.getAccessibleContext();
    }

    public TreePath getAnchorSelectionPath() {
        return this.jtree == null ? null : this.jtree.getAnchorSelectionPath();
    }

    public TreeCellEditor getTreeCellEditor() {
        return this.jtree == null ? null : this.jtree.getCellEditor();
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.jtree == null ? null : this.jtree.getCellRenderer();
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        this._remap();
        return this.jtree == null ? null : this.jtree.getClosestPathForLocation(x, y);
    }

    public int getClosestRowForLocation(int x, int y) {
        this._remap();
        return this.jtree == null ? 0 : this.jtree.getClosestRowForLocation(x, y);
    }

    public boolean getTreeDragEnabled() {
        return this.jtree == null ? false : this.jtree.getDragEnabled();
    }

    public TreePath getEditingPath() {
        return this.jtree == null ? null : this.jtree.getEditingPath();
    }

    public boolean getExpandsSelectedPaths() {
        return this.jtree == null ? false : this.jtree.getExpandsSelectedPaths();
    }

    public boolean getInvokesStopCellEditing() {
        return this.jtree == null ? false : this.jtree.getInvokesStopCellEditing();
    }

    public Object getLastSelectedPathComponent() {
        return this.jtree == null ? null : this.jtree.getLastSelectedPathComponent();
    }

    public TreePath getLeadSelectionPath() {
        return this.jtree == null ? null : this.jtree.getLeadSelectionPath();
    }

    public int getLeadSelectionRow() {
        return this.jtree == null ? 0 : this.jtree.getLeadSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.jtree == null ? 0 : this.jtree.getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.jtree == null ? 0 : this.jtree.getMinSelectionRow();
    }

    public TreeModel getTreeModel() {
        return this.jtree == null ? null : this.jtree.getModel();
    }

    public TreePath getNextMatch(String p, int r, Position.Bias b) {
        return this.jtree == null ? null : this.jtree.getNextMatch(p, r, b);
    }

    public TreePath getPathForLocation(int x, int y) {
        this._remap();
        return this.jtree == null ? null : this.jtree.getPathForLocation(x, y);
    }

    public TreePath getPathForRow(int row) {
        this._remap();
        return this.jtree == null ? null : this.jtree.getPathForRow(row);
    }

    public Dimension getTreePreferredScrollableViewportSize() {
        return this.jtree == null ? null : this.jtree.getPreferredScrollableViewportSize();
    }

    public Rectangle getRowBounds(int row) {
        this._remap();
        return this.jtree == null ? null : this.jtree.getRowBounds(row);
    }

    public int getTreeRowCount() {
        this._remap();
        return this.jtree == null ? 0 : this.jtree.getRowCount();
    }

    public int getRowForLocation(int x, int y) {
        this._remap();
        return this.jtree == null ? 0 : this.jtree.getRowForLocation(x, y);
    }

    public int getTreeRowHeight() {
        return this.jtree == null ? 0 : this.jtree.getRowHeight();
    }

    public int getTreeScrollableBlockIncrement(Rectangle r, int o, int d) {
        return this.jtree == null ? 0 : this.jtree.getScrollableBlockIncrement(r, o, d);
    }

    public boolean getTreeScrollableTracksViewportHeight() {
        return this.jtree == null ? false : this.jtree.getScrollableTracksViewportHeight();
    }

    public boolean getTreeScrollableTracksViewportWidth() {
        return this.jtree == null ? false : this.jtree.getScrollableTracksViewportWidth();
    }

    public int getTreeScrollableUnitIncrement(Rectangle r, int o, int d) {
        return this.jtree == null ? 0 : this.jtree.getScrollableUnitIncrement(r, o, d);
    }

    public boolean getScrollsOnExpand() {
        return this.jtree == null ? false : this.jtree.getScrollsOnExpand();
    }

    public int getSelectionCount() {
        return this.jtree == null ? 0 : this.jtree.getSelectionCount();
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.jtree == null ? null : this.jtree.getSelectionModel();
    }

    public TreePath getSelectionPath() {
        return this.jtree == null ? null : this.jtree.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.jtree == null ? null : this.jtree.getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.jtree == null ? null : this.jtree.getSelectionRows();
    }

    public boolean getShowsRootHandles() {
        return this.jtree == null ? false : this.jtree.getShowsRootHandles();
    }

    public int getToggleClickCount() {
        return this.jtree == null ? 0 : this.jtree.getToggleClickCount();
    }

    public String getTreeToolTipText(MouseEvent event) {
        return this.jtree == null ? null : this.jtree.getToolTipText();
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return this.jtree == null ? null : this.jtree.getTreeExpansionListeners();
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return this.jtree == null ? null : this.jtree.getTreeSelectionListeners();
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return this.jtree == null ? null : this.jtree.getTreeWillExpandListeners();
    }

    public TreeUI getTreeUI() {
        return this.jtree == null ? null : this.jtree.getUI();
    }

    public String getTreeUIClassID() {
        return this.jtree == null ? null : this.jtree.getUIClassID();
    }

    public boolean isCollapsed(int row) {
        return this.jtree == null ? false : this.jtree.isCollapsed(row);
    }

    public boolean isTreeEditing() {
        return this.jtree == null ? false : this.jtree.isEditing();
    }

    public boolean isExpanded(int row) {
        return this.jtree == null ? false : this.jtree.isExpanded(row);
    }

    public boolean isFixedRowHeight() {
        return this.jtree == null ? false : this.jtree.isFixedRowHeight();
    }

    public boolean isLargeModel() {
        return this.jtree == null ? false : this.jtree.isLargeModel();
    }

    public boolean isRootVisible() {
        return this.jtree == null ? false : this.jtree.isRootVisible();
    }

    public boolean isTreeRowSelected(int row) {
        return this.jtree == null ? false : this.jtree.isRowSelected(row);
    }

    public boolean isSelectionEmpty() {
        return this.jtree == null ? false : this.jtree.isSelectionEmpty();
    }

    public void removeSelectionInterval(int i0, int i1) {
        if (this.jtree != null) {
            this.jtree.removeSelectionInterval(i0, i1);
        }
    }

    public void removeSelectionRow(int row) {
        if (this.jtree != null) {
            this.jtree.removeSelectionRow(row);
        }
    }

    public void removeSelectionRows(int[] rows) {
        if (this.jtree != null) {
            this.jtree.removeSelectionRows(rows);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        if (this.jtree != null) {
            this.jtree.removeTreeExpansionListener(l);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener l) {
        if (this.jtree != null) {
            this.jtree.removeTreeSelectionListener(l);
        }
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener l) {
        if (this.jtree != null) {
            this.jtree.removeTreeWillExpandListener(l);
        }
    }

    public void scrollRowToVisible(int row) {
        if (this.jtree != null) {
            this.jtree.scrollRowToVisible(row);
        }
    }

    public void setTreeCellEditor(TreeCellEditor e) {
        if (this.jtree != null) {
            this.jtree.setCellEditor(e);
        }
    }

    public void setTreeCellRenderer(TreeCellRenderer x) {
        if (this.jtree != null) {
            this.jtree.setCellRenderer(x);
        }
    }

    public void setCellRenderer(TreeCellRenderer x) {
        if (this.jtree != null) {
            this.jtree.setCellRenderer(x);
        }
    }

    public void setTreeDragEnabled(boolean b) {
        if (this.jtree != null) {
            this.jtree.setDragEnabled(b);
        }
    }

    public void setExpandsSelectedPaths(boolean b) {
        if (this.jtree != null) {
            this.jtree.setExpandsSelectedPaths(b);
        }
    }

    public void setInvokesStopCellEditing(boolean b) {
        if (this.jtree != null) {
            this.jtree.setInvokesStopCellEditing(b);
        }
    }

    public void setLargeModel(boolean b) {
        if (this.jtree != null) {
            this.jtree.setLargeModel(b);
        }
    }

    public void setTreeModel(TreeModel m) {
        if (this.jtree != null) {
            this.jtree.setModel(m);
        }
    }

    public void setScrollsOnExpand(boolean b) {
        if (this.jtree != null) {
            this.jtree.setScrollsOnExpand(b);
        }
    }

    public void setSelectionInterval(int i0, int i1) {
        if (this.jtree != null) {
            this.jtree.setSelectionInterval(i0, i1);
        }
    }

    public void setTreeSelectionModel(TreeSelectionModel m) {
        if (this.jtree != null) {
            this.jtree.setSelectionModel(m);
        }
    }

    public void setSelectionRow(int row) {
        if (this.jtree != null) {
            this.jtree.setSelectionRow(row);
        }
    }

    public void setSelectionRows(int[] rows) {
        if (this.jtree != null) {
            this.jtree.setSelectionRows(rows);
        }
    }

    public void setShowsRootHandles(boolean b) {
        if (this.jtree != null) {
            this.jtree.setShowsRootHandles(b);
        }
    }

    public void setToggleClickCount(int cc) {
        if (this.jtree != null) {
            this.jtree.setToggleClickCount(cc);
        }
    }

    public void setTreeUI(TreeUI ui) {
        if (this.jtree != null) {
            this.jtree.setUI(ui);
        }
    }

    public boolean stopEditing() {
        return this.jtree == null ? false : this.jtree.stopEditing();
    }

    public void treeDidChange() {
        if (this.jtree != null) {
            this.jtree.treeDidChange();
        }
    }

    public void updateTreeUI() {
        if (this.jtree != null) {
            this.jtree.updateUI();
        }
    }

    private void _remap() {
        if (this.model != null && this.model instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)this.model;
            ttm.rebuildMaps();
        }
    }

    private class SelectionState {
        int[] selectedRowNumbers;
        int[] anchorRowNumbers;
        Object[] selectedRows;
        Object[] anchorRows;
        boolean anchorRowsSelected;

        private SelectionState() {
        }
    }

    private class CellActionRelay
    implements ActionListener {
        CellAction action;

        public CellActionRelay(CellAction a) {
            this.action = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.perform(new CellActionEvent((Object)TreeTable.this, e.getID(), e.getActionCommand(), TreeTable.this.popupCellRow, TreeTable.this.popupCellColumn));
        }
    }
}

