/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.TreeTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MultiLineHeaderCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final String NEWLINE = "\n";
    private Filler ftop;
    private Filler fbottom;
    private int lineHeight;
    private int lineCount;
    private JTableHeader header;
    private boolean needRefresh;
    private Font font;

    public MultiLineHeaderCellRenderer() {
        this.setLayout(new CellLayout());
        Border b = UIManager.getBorder("TableHeader.cellBorder");
        this.setBorder(b);
        this.fixInsets(b.getBorderInsets(this));
        this.setDoubleBuffered(false);
        this.setOpaque(this.getBackground().getAlpha() == 255);
        this.needRefresh = true;
        this.ftop = new Filler(0, 0);
        this.ftop.setOpaque(false);
        this.ftop.setDoubleBuffered(false);
        this.fbottom = new Filler(0, 0);
        this.fbottom.setOpaque(false);
        this.fbottom.setDoubleBuffered(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.cacheRenderingInfo(table, row, column);
        this.removeAll();
        this.invalidate();
        ArrayList tokens = this.tokenize((String)value);
        int hph = 0;
        JTableHeader th = table.getTableHeader();
        if (th instanceof TreeTableHeader) {
            TreeTableHeader tth = (TreeTableHeader)th;
            if (tth.isPreferredHeightSet()) {
                hph = tth.getPreferredHeight();
            }
        } else if (th.isPreferredSizeSet()) {
            hph = (int)th.getPreferredSize().getHeight();
        }
        int verticalSpace = MultiLineHeaderCellRenderer.max(hph, this.lineCount * this.lineHeight);
        int verticalSize = tokens.size() * this.lineHeight;
        int verticalPadding = verticalSpace - verticalSize;
        if (verticalPadding < 0) {
            verticalPadding = 0;
        }
        this.ftop.setPreferredHeight((float)verticalPadding * this.getAlignmentY());
        this.add(this.ftop);
        float alignment = this.getAlignmentX();
        for (int i = 0; i < tokens.size(); ++i) {
            JLabel l = new JLabel();
            l.setText((String)tokens.get(i));
            l.setHorizontalAlignment(2);
            l.setAlignmentX(alignment);
            l.setForeground(this.getForeground());
            l.setBackground(this.getBackground());
            l.setOpaque(false);
            l.setDoubleBuffered(false);
            l.setFont(this.getFont());
            this.add(l);
        }
        this.fbottom.setPreferredHeight((float)verticalPadding * (1.0f - this.getAlignmentY()));
        this.add(this.fbottom);
        return this;
    }

    private ArrayList tokenize(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(s, NEWLINE);
        while (t.hasMoreTokens()) {
            tokens.add(t.nextToken());
        }
        return tokens;
    }

    @Override
    public Font getFont() {
        return this.header != null ? this.header.getFont() : UIManager.getFont("TableHeader.font");
    }

    @Override
    public Color getForeground() {
        return this.header != null && this.header.isForegroundSet() ? this.header.getForeground() : UIManager.getColor("TableHeader.foreground");
    }

    @Override
    public Color getBackground() {
        return this.header != null && this.header.isBackgroundSet() ? this.header.getBackground() : UIManager.getColor("TableHeader.background");
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.setOpaque(bg.getAlpha() == 255);
    }

    private void cacheRenderingInfo(JTable table, int row, int col) {
        JTableHeader jTableHeader = this.header = table != null ? table.getTableHeader() : null;
        if (col > 0) {
            this.needRefresh = true;
        } else if (this.needRefresh) {
            this.needRefresh = false;
            this.cacheFontHeight();
            TableColumnModel cm = table.getTableHeader().getColumnModel();
            this.lineCount = 0;
            for (int i = 0; i < cm.getColumnCount(); ++i) {
                String value = cm.getColumn(i).getHeaderValue().toString();
                int n = this.tokenize(value).size();
                if (n <= this.lineCount) continue;
                this.lineCount = n;
            }
        }
    }

    private void cacheFontHeight() {
        Font f = this.getFont();
        if (f != this.font) {
            this.font = f;
            JLabel sizeSample = new JLabel("abcdefg");
            sizeSample.setFont(f);
            this.lineHeight = (int)sizeSample.getPreferredSize().getHeight();
        }
    }

    private static final int max(int a, int b) {
        return a >= b ? a : b;
    }

    private void fixInsets(Insets i) {
        i.left = MultiLineHeaderCellRenderer.max(i.left, 2);
        i.right = i.left = MultiLineHeaderCellRenderer.max(i.left, i.right);
        i.top = MultiLineHeaderCellRenderer.max(i.top, 2);
        i.bottom = i.top = MultiLineHeaderCellRenderer.max(i.top, i.bottom);
    }

    private class CellLayout
    implements LayoutManager {
        private CellLayout() {
        }

        @Override
        public void layoutContainer(Container p) {
            Dimension as = p.getSize();
            Insets pi = ((JComponent)p).getBorder().getBorderInsets(p);
            int aw = as.width - pi.left - pi.right;
            int ah = as.height - pi.top - pi.bottom;
            if (aw <= 0 || ah <= 0) {
                return;
            }
            Dimension ps = this._layoutSize(p, false);
            int eh = ah - ps.height;
            if (eh < 0) {
                eh = 0;
            }
            MultiLineHeaderCellRenderer.this.ftop.setPreferredHeight((float)eh * MultiLineHeaderCellRenderer.this.getAlignmentY());
            MultiLineHeaderCellRenderer.this.fbottom.setPreferredHeight((float)eh * (1.0f - MultiLineHeaderCellRenderer.this.getAlignmentY()));
            int n = p.getComponentCount();
            int cy = pi.top;
            for (int i = 0; i < n; ++i) {
                Component c = p.getComponent(i);
                Dimension cs = c.getPreferredSize();
                int cw = cs.width;
                int ch = cs.height;
                int x0 = pi.left;
                int x1 = aw - cw;
                if (x1 < 0) {
                    x1 = 0;
                }
                int xf = (int)(c.getAlignmentX() * (float)x1);
                int cx = x0 + xf;
                cw = aw - xf;
                c.setBounds(cx, cy, cw, ch);
                cy += ch;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container p) {
            Dimension size = this._layoutSize(p, true);
            Insets pi = ((JComponent)p).getBorder().getBorderInsets(p);
            size.width += pi.left + pi.right;
            size.height += pi.top + pi.bottom;
            return size;
        }

        @Override
        public Dimension preferredLayoutSize(Container p) {
            Dimension pSize = this._layoutSize(p, false);
            MultiLineHeaderCellRenderer.this.cacheFontHeight();
            pSize.height = MultiLineHeaderCellRenderer.this.lineCount * MultiLineHeaderCellRenderer.this.lineHeight;
            Insets pi = ((JComponent)p).getBorder().getBorderInsets(p);
            pSize.width += pi.left + pi.right;
            pSize.height += pi.top + pi.bottom;
            return pSize;
        }

        private Dimension _layoutSize(Container p, boolean min) {
            Dimension ps = new Dimension(0, 0);
            int n = p.getComponentCount();
            for (int i = 1; i < n - 1; ++i) {
                Dimension cs;
                Component c = p.getComponent(i);
                Dimension dimension = cs = min ? c.getMinimumSize() : c.getPreferredSize();
                if (cs.width > ps.width) {
                    ps.width = cs.width;
                }
                if (cs.height <= 0) continue;
                ps.height += cs.height;
            }
            return ps;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private class Filler
    extends JComponent {
        private Dimension size;

        public Filler(int w, double h) {
            this(w, (int)h);
        }

        public Filler(int w, int h) {
            this.size = new Dimension(w, h);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.size;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        public void setPreferredWidth(double w) {
            this.size.width = (int)w;
        }

        public void setPreferredHeight(double h) {
            this.size.height = (int)h;
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void paint(Graphics g) {
        }
    }
}

