/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treecombobox;

import com.sas.swing.visuals.treecombobox.TreeComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class IndentedItemsRenderer
extends JPanel
implements ListCellRenderer {
    private List indentionLevels;
    private int indentAmount;
    private Icon defaultIcon;
    private TreeComboBox treeComboBox;

    public IndentedItemsRenderer(TreeComboBox comboBoxComponent) {
        this.treeComboBox = comboBoxComponent;
        this.indentionLevels = comboBoxComponent.getNodeIndentLevels();
        this.indentAmount = 16;
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        if (value == null) {
            return this;
        }
        Component comp = this.treeComboBox.getTreeItemsListCellRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (comp != null) {
            this.setLayout(new BorderLayout());
            this.add(comp, "West");
        }
        if (index >= 0 && this.indentionLevels.size() > 0) {
            int nodeIndentLevel = (Integer)this.indentionLevels.get(index);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0), BorderFactory.createEmptyBorder(0, nodeIndentLevel * this.getIndentAmountInPixels(), 0, 0)));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        }
        this.setFont(list.getFont());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    public void setIndentAmountInPixels(int pixelIndentAmount) {
        this.indentAmount = pixelIndentAmount;
    }

    public int getIndentAmountInPixels() {
        return this.indentAmount;
    }
}

