/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.tableview.CombiningRendererInterface;
import com.sas.swing.visuals.tableview.TableFormatArea;
import com.sas.swing.visuals.tableview.TableFormatAreaInterface;
import com.sas.table.AccurateRowCountInterface;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.TableException;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;

@SASScope
public abstract class TableViewUtil {
    public static final int LASTROW = -369;
    public static final int ROW = -88;
    public static final int COLUMN = -89;

    public static Object getValueFromMap(Map map, int row, int column, Object uniqueID) {
        CombiningRendererInterface combiningRenderer = null;
        if (map != null) {
            Set entrySet = map.entrySet();
            Object[] entries = entrySet.toArray();
            for (int i = entries.length - 1; i >= 0; --i) {
                Map.Entry entry = (Map.Entry)entries[i];
                TableFormatAreaInterface key = (TableFormatAreaInterface)entry.getKey();
                if (!key.areaMatches(row, column, uniqueID)) continue;
                Object renderer = entry.getValue();
                if (combiningRenderer != null) {
                    if (combiningRenderer.combineWith(renderer)) continue;
                    return combiningRenderer;
                }
                if (renderer instanceof CombiningRendererInterface) {
                    combiningRenderer = (CombiningRendererInterface)renderer;
                    if (combiningRenderer.isCombining()) continue;
                    return renderer;
                }
                return renderer;
            }
        }
        return combiningRenderer;
    }

    public static Object getValueFromMap(Map map, int row, int column) {
        CombiningRendererInterface combiningRenderer = null;
        if (map != null) {
            Set entrySet = map.entrySet();
            Object[] entries = entrySet.toArray();
            for (int i = entries.length - 1; i >= 0; --i) {
                Map.Entry entry = (Map.Entry)entries[i];
                TableFormatAreaInterface key = (TableFormatAreaInterface)entry.getKey();
                if (!key.areaMatches(row, column, null)) continue;
                Object renderer = entry.getValue();
                if (combiningRenderer != null) {
                    if (combiningRenderer.combineWith(renderer)) continue;
                    return combiningRenderer;
                }
                if (renderer instanceof CombiningRendererInterface) {
                    combiningRenderer = (CombiningRendererInterface)renderer;
                    if (combiningRenderer.isCombining()) continue;
                    return renderer;
                }
                return renderer;
            }
        }
        return combiningRenderer;
    }

    public static void setValuesOnMap(Map map, int startRow, int endRow, int repeatRow, int startColumn, int endColumn, int repeatColumn, Object value) {
        TableFormatArea key = new TableFormatArea(startRow, endRow, repeatRow, startColumn, endColumn, repeatColumn);
        TableViewUtil.setValuesOnMap(map, key, value);
    }

    public static void setValuesOnMap(Map map, TableFormatAreaInterface area, Object value) {
        TableFormatArea key;
        if (area instanceof TableFormatArea && (key = (TableFormatArea)area).getStartRow() == 1 && key.getEndRow() == -1 && key.getRepeatRow() == 1 && key.getStartColumn() == 1 && key.getEndColumn() == -1 && key.getRepeatColumn() == 1) {
            map.clear();
        }
        map.put(area, value);
    }

    public static void updateValuesOnMap(Map map, int coordinateType, int from, int to) {
        if (coordinateType != -88 && coordinateType != -89) {
            throw new IllegalArgumentException();
        }
        if (map == null) {
            return;
        }
        int direction = from - to;
        LinkedHashMap newMap = new LinkedHashMap();
        Set keys = map.keySet();
        for (TableFormatAreaInterface formatArea : keys) {
            TableFormatArea newtfa;
            int repeatFactor;
            int end;
            int start;
            Object renderer = map.get(formatArea);
            if (!(formatArea instanceof TableFormatArea)) {
                newMap.put(formatArea, renderer);
                continue;
            }
            TableFormatArea tfa = (TableFormatArea)formatArea;
            if (coordinateType == -89) {
                start = tfa.getStartColumn();
                end = tfa.getEndColumn();
                repeatFactor = tfa.getRepeatColumn();
                if (start == end) {
                    if (direction > 0) {
                        if (start == from) {
                            tfa.setStartColumn(to);
                            tfa.setEndColumn(to);
                        } else if (start < from && start >= to) {
                            tfa.setStartColumn(start + 1);
                            tfa.setEndColumn(start + 1);
                        }
                    } else if (direction < 0) {
                        if (start == from) {
                            tfa.setStartColumn(to);
                            tfa.setEndColumn(to);
                        } else if (start > from && start <= to) {
                            tfa.setStartColumn(start - 1);
                            tfa.setEndColumn(start - 1);
                        }
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (repeatFactor == 1) {
                    if (from >= start && from <= end) {
                        if (to < start || to > end) {
                            if (direction > 0) {
                                tfa.setStartColumn(start + 1);
                            } else if (direction < 0) {
                                tfa.setEndColumn(end - 1);
                            }
                            TableFormatArea newtfa2 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), to, to, repeatFactor);
                            newMap.put(newtfa2, renderer);
                        }
                        newMap.put(tfa, renderer);
                        continue;
                    }
                    if (to > start && to < end) {
                        if (from < start || from > end) {
                            tfa.setStartColumn(to + 1);
                            if (direction > 0) {
                                tfa.setEndColumn(end + 1);
                            } else if (direction < 0) {
                                --start;
                            }
                            end = to - 1;
                            if (start <= end) {
                                TableFormatArea newtfa3 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), start, end, repeatFactor);
                                newMap.put(newtfa3, renderer);
                            }
                        }
                        newMap.put(tfa, renderer);
                        continue;
                    }
                    if (from > end && to <= start) {
                        tfa.setStartColumn(start + 1);
                        if (end != -1) {
                            tfa.setEndColumn(end + 1);
                        }
                        newMap.put(tfa, renderer);
                        continue;
                    }
                    if (from < start && to >= end) {
                        tfa.setStartColumn(start - 1);
                        tfa.setEndColumn(end - 1);
                        newMap.put(tfa, renderer);
                        continue;
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (repeatFactor <= 1) continue;
                if (from >= start && (end == -1 || from <= end)) {
                    if (direction > 0) {
                        boolean found = false;
                        boolean fromIsInRange = false;
                        for (int column = from; column >= to; --column) {
                            if ((column - start) % repeatFactor != 0) continue;
                            found = true;
                            if (column != from) break;
                            fromIsInRange = true;
                            break;
                        }
                        if (found) {
                            if (fromIsInRange) {
                                TableFormatArea newtfa4 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), to, to, 1);
                                newMap.put(newtfa4, renderer);
                            }
                            int newStart = start + (from + 1 - start) / repeatFactor * repeatFactor;
                            if ((from + 1 - start) % repeatFactor > 0) {
                                newStart += repeatFactor;
                            }
                            if (end == -1 || end != -1 && newStart <= end) {
                                tfa.setStartColumn(newStart);
                            }
                            if (to > start) {
                                if (start <= to - 1) {
                                    newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), start, to - 1, repeatFactor);
                                    newMap.put(newtfa, renderer);
                                }
                                newStart = start + (to - start) / repeatFactor * repeatFactor + 1;
                                if ((to - start) % repeatFactor > 0) {
                                    newStart += repeatFactor;
                                }
                                if (newStart <= from) {
                                    newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, from, repeatFactor);
                                    newMap.put(newtfa, renderer);
                                }
                            } else if (to <= start && start + 1 <= from) {
                                newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), start + 1, from, repeatFactor);
                                newMap.put(newtfa, renderer);
                            }
                        }
                    } else if (direction < 0) {
                        boolean found = false;
                        boolean fromIsInRange = false;
                        for (int column = from; column <= to; ++column) {
                            if ((column - start) % repeatFactor != 0) continue;
                            found = true;
                            if (column != from) break;
                            fromIsInRange = true;
                            break;
                        }
                        if (found) {
                            if (from == start) {
                                tfa.setStartColumn(to);
                                tfa.setEndColumn(to);
                                tfa.setRepeatColumn(1);
                            } else {
                                if (fromIsInRange) {
                                    TableFormatArea newtfa5 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), to, to, 1);
                                    newMap.put(newtfa5, renderer);
                                }
                                tfa.setEndColumn(from - 1);
                            }
                            int newStart = start + (from + 1 - start) / repeatFactor * repeatFactor - 1;
                            if ((from + 1 - start) % repeatFactor > 0) {
                                newStart += repeatFactor;
                            }
                            if (end == -1 || to < end) {
                                if (newStart <= to - 1) {
                                    newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, to - 1, repeatFactor);
                                    newMap.put(newtfa, renderer);
                                }
                                newStart = start + (to + 1 - start) / repeatFactor * repeatFactor;
                                if ((to + 1 - start) % repeatFactor > 0) {
                                    newStart += repeatFactor;
                                }
                                if (end == -1 || newStart <= end) {
                                    newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, end, repeatFactor);
                                    newMap.put(newtfa, renderer);
                                }
                            } else if (to >= end && newStart <= end - 1) {
                                newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, end - 1, repeatFactor);
                                newMap.put(newtfa, renderer);
                            }
                        }
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (direction > 0 && end != -1 && from > end && to <= end) {
                    if (to > start) {
                        int newEnd;
                        tfa.setEndColumn(to - 1);
                        int newStart = start + (to - start) / repeatFactor * repeatFactor + 1;
                        if ((to - start) % repeatFactor > 0) {
                            newStart += repeatFactor;
                        }
                        int n = newEnd = end == -1 ? end : end + 1;
                        if (newStart <= newEnd) {
                            TableFormatArea newtfa6 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, newEnd, repeatFactor);
                            newMap.put(newtfa6, renderer);
                        }
                    } else if (to <= start) {
                        tfa.setStartColumn(start + 1);
                        tfa.setEndColumn(end + 1);
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (direction < 0 && from < start && to >= start) {
                    if (end == -1 || to < end) {
                        tfa.setStartColumn(start - 1);
                        tfa.setEndColumn(to - 1);
                        int newStart = start + (to + 1 - start) / repeatFactor * repeatFactor;
                        if ((to + 1 - start) % repeatFactor > 0) {
                            newStart += repeatFactor;
                        }
                        if (newStart <= end) {
                            TableFormatArea newtfa7 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, end, repeatFactor);
                            newMap.put(newtfa7, renderer);
                        }
                    } else if (to >= end) {
                        tfa.setStartColumn(start - 1);
                        tfa.setEndColumn(end - 1);
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                newMap.put(tfa, renderer);
                continue;
            }
            if (coordinateType != -88) continue;
            start = tfa.getStartRow();
            end = tfa.getEndRow();
            repeatFactor = tfa.getRepeatRow();
            if (start == end) {
                if (direction > 0) {
                    if (start == from) {
                        tfa.setStartRow(to);
                        tfa.setEndRow(to);
                    } else if (start < from && start >= to) {
                        tfa.setStartRow(start + 1);
                        tfa.setEndRow(start + 1);
                    }
                } else if (direction < 0) {
                    if (start == from) {
                        tfa.setStartRow(to);
                        tfa.setEndRow(to);
                    } else if (start > from && start <= to) {
                        tfa.setStartRow(start - 1);
                        tfa.setEndRow(start - 1);
                    }
                }
                newMap.put(tfa, renderer);
                continue;
            }
            if (repeatFactor == 1) {
                if (from >= start && from <= end) {
                    if (to < start || to > end) {
                        if (direction > 0) {
                            tfa.setStartRow(start + 1);
                        } else if (direction < 0) {
                            tfa.setEndRow(end - 1);
                        }
                        TableFormatArea newtfa8 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), to, to, repeatFactor);
                        newMap.put(newtfa8, renderer);
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (to > start && to < end) {
                    if (from < start || from > end) {
                        tfa.setStartRow(to + 1);
                        if (direction > 0) {
                            tfa.setEndRow(end + 1);
                        } else if (direction < 0) {
                            --start;
                        }
                        end = to - 1;
                        if (start <= end) {
                            TableFormatArea newtfa9 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), start, end, repeatFactor);
                            newMap.put(newtfa9, renderer);
                        }
                    }
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (from > end && to <= start) {
                    tfa.setStartRow(start + 1);
                    tfa.setEndRow(end + 1);
                    newMap.put(tfa, renderer);
                    continue;
                }
                if (from < start && to >= end) {
                    tfa.setStartRow(start - 1);
                    tfa.setEndRow(end - 1);
                    newMap.put(tfa, renderer);
                    continue;
                }
                newMap.put(tfa, renderer);
                continue;
            }
            if (repeatFactor <= 1) continue;
            if (from >= start && (end == -1 || from <= end)) {
                if (direction > 0) {
                    boolean found = false;
                    boolean fromIsInRange = false;
                    for (int row = from; row >= to; --row) {
                        if ((row - start) % repeatFactor != 0) continue;
                        found = true;
                        if (row != from) break;
                        fromIsInRange = true;
                        break;
                    }
                    if (found) {
                        if (fromIsInRange) {
                            TableFormatArea newtfa10 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), to, to, 1);
                            newMap.put(newtfa10, renderer);
                        }
                        int newStart = start + (from + 1 - start) / repeatFactor * repeatFactor;
                        if ((from + 1 - start) % repeatFactor > 0) {
                            newStart += repeatFactor;
                        }
                        if (end == -1 || end != -1 && newStart <= end) {
                            tfa.setStartRow(newStart);
                        }
                        if (to > start) {
                            if (start <= to - 1) {
                                newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), start, to - 1, repeatFactor);
                                newMap.put(newtfa, renderer);
                            }
                            newStart = start + (to - start) / repeatFactor * repeatFactor + 1;
                            if ((to - start) % repeatFactor > 0) {
                                newStart += repeatFactor;
                            }
                            if (newStart <= from) {
                                newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, from, repeatFactor);
                                newMap.put(newtfa, renderer);
                            }
                        } else if (to <= start && start + 1 <= from) {
                            newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), start + 1, from, repeatFactor);
                            newMap.put(newtfa, renderer);
                        }
                    }
                } else if (direction < 0) {
                    boolean found = false;
                    boolean fromIsInRange = false;
                    for (int row = from; row <= to; ++row) {
                        if ((row - start) % repeatFactor != 0) continue;
                        found = true;
                        if (row != from) break;
                        fromIsInRange = true;
                        break;
                    }
                    if (found) {
                        if (from == start) {
                            tfa.setStartRow(to);
                            tfa.setEndRow(to);
                            tfa.setRepeatRow(1);
                        } else {
                            if (fromIsInRange) {
                                TableFormatArea newtfa11 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), to, to, 1);
                                newMap.put(newtfa11, renderer);
                            }
                            tfa.setEndRow(from - 1);
                        }
                        int newStart = start + (from + 1 - start) / repeatFactor * repeatFactor - 1;
                        if ((from + 1 - start) % repeatFactor > 0) {
                            newStart += repeatFactor;
                        }
                        if (end == -1 || to < end) {
                            if (newStart <= to - 1) {
                                newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, to - 1, repeatFactor);
                                newMap.put(newtfa, renderer);
                            }
                            newStart = start + (to + 1 - start) / repeatFactor * repeatFactor;
                            if ((to + 1 - start) % repeatFactor > 0) {
                                newStart += repeatFactor;
                            }
                            if (end == -1 || newStart <= end) {
                                newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, end, repeatFactor);
                                newMap.put(newtfa, renderer);
                            }
                        } else if (to >= end && newStart <= end - 1) {
                            newtfa = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, end - 1, repeatFactor);
                            newMap.put(newtfa, renderer);
                        }
                    }
                }
                newMap.put(tfa, renderer);
                continue;
            }
            if (direction > 0 && end != -1 && from > end && to <= end) {
                if (to > start) {
                    int newEnd;
                    tfa.setEndRow(to - 1);
                    int newStart = start + (to - start) / repeatFactor * repeatFactor + 1;
                    if ((to - start) % repeatFactor > 0) {
                        newStart += repeatFactor;
                    }
                    int n = newEnd = end == -1 ? end : end + 1;
                    if (newStart <= newEnd) {
                        TableFormatArea newtfa12 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, newEnd, repeatFactor);
                        newMap.put(newtfa12, renderer);
                    }
                } else if (to <= start) {
                    tfa.setStartRow(start + 1);
                    tfa.setEndRow(end + 1);
                }
                newMap.put(tfa, renderer);
                continue;
            }
            if (direction < 0 && from < start && to >= start) {
                if (end == -1 || to < end) {
                    tfa.setStartRow(start - 1);
                    tfa.setEndRow(to - 1);
                    int newStart = start + (to + 1 - start) / repeatFactor * repeatFactor;
                    if ((to + 1 - start) % repeatFactor > 0) {
                        newStart += repeatFactor;
                    }
                    if (newStart <= end) {
                        TableFormatArea newtfa13 = new TableFormatArea(tfa.getStartRow(), tfa.getEndRow(), tfa.getRepeatRow(), newStart, end, repeatFactor);
                        newMap.put(newtfa13, renderer);
                    }
                } else if (to >= end) {
                    tfa.setStartRow(start - 1);
                    tfa.setEndRow(end - 1);
                }
                newMap.put(tfa, renderer);
                continue;
            }
            newMap.put(tfa, renderer);
        }
        map.clear();
        map.putAll(newMap);
    }

    public static Object checkForLastRowFromMap(Map map, int row, int column, TableModel dataModel) {
        Object renderer = null;
        if (row != -369 && dataModel != null) {
            if (dataModel instanceof AccurateRowCountInterface) {
                if (((AccurateRowCountInterface)dataModel).isAccurateRowCountAvailable() && row == dataModel.getRowCount()) {
                    renderer = TableViewUtil.getValueFromMap(map, -369, column);
                }
            } else if (row == dataModel.getRowCount()) {
                renderer = TableViewUtil.getValueFromMap(map, -369, column);
            }
        }
        return renderer;
    }

    public static String getColumnName(TableModel model, int columnIndex) {
        if (model instanceof StaticColumnInfoInterface) {
            try {
                return (String)((StaticColumnInfoInterface)model).getColumnInfo(columnIndex + 1, "NAME");
            }
            catch (TableException e) {
                return "";
            }
        }
        return model.getColumnName(columnIndex);
    }

    public static void removeCellRenderers(Map cellRenderers, Collection collection) {
        Iterator iter = cellRenderers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object renderer = entry.getValue();
            if (!collection.contains(renderer)) continue;
            iter.remove();
        }
    }

    public static Object[] getSelectedRowGroups(int[] selectedRows) {
        ArrayList<Dimension> groups = new ArrayList<Dimension>();
        if (selectedRows.length > 0) {
            int start = selectedRows[0];
            for (int i = 1; i < selectedRows.length; ++i) {
                if (selectedRows[i] == selectedRows[i - 1] + 1) continue;
                groups.add(new Dimension(start, selectedRows[i - 1]));
                start = selectedRows[i];
            }
            groups.add(new Dimension(start, selectedRows[selectedRows.length - 1]));
        }
        return groups.toArray();
    }
}

