/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.BevelArrowIcon;
import com.sas.swing.visuals.tableview.DefaultTableHeaderRenderer;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.table.SortableInterface;
import com.sas.util.SortDirectionInterface;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTable;

public class SortHeaderRenderer
extends DefaultTableHeaderRenderer
implements SortDirectionInterface {
    private Icon ascendingIcon;
    private Icon descendingIcon;

    public SortHeaderRenderer() {
        this((Character)null);
    }

    public SortHeaderRenderer(Character splitCharacter) {
        super(splitCharacter);
        this.setHorizontalTextPosition(10);
        this.ascendingIcon = new BevelArrowIcon(1, 10);
        this.descendingIcon = new BevelArrowIcon(5, 10);
    }

    public void setAscendingIcon(Icon newIcon) {
        if (newIcon != this.ascendingIcon) {
            Icon old = this.ascendingIcon;
            this.ascendingIcon = newIcon;
            this.firePropertyChange("ascendingIcon", old, newIcon);
        }
    }

    public Icon getAscendingIcon() {
        return this.ascendingIcon;
    }

    public void setDescendingIcon(Icon newIcon) {
        if (newIcon != this.descendingIcon) {
            Icon old = this.descendingIcon;
            this.descendingIcon = newIcon;
            this.firePropertyChange("descendingIcon", old, newIcon);
        }
    }

    public Icon getDescendingIcon() {
        return this.descendingIcon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setIcon(null);
        if (table.getModel() instanceof SortableInterface) {
            SortableInterface model = (SortableInterface)table.getModel();
            String[] sortColumns = model.getSortedColumns();
            int[] sortDirs = model.getSortedDirections();
            if (sortColumns != null && sortDirs != null) {
                int dir = 2;
                String columnName = TableViewUtil.getColumnName(table.getModel(), table.convertColumnIndexToModel(column));
                for (int i = 0; i < sortColumns.length; ++i) {
                    if (!columnName.equals(sortColumns[i])) continue;
                    dir = sortDirs[i];
                    break;
                }
                if (dir == 0) {
                    this.setIcon(this.ascendingIcon);
                } else if (dir == 1) {
                    this.setIcon(this.descendingIcon);
                }
                Icon sortIcon = this.getIcon();
                if (sortIcon instanceof BevelArrowIcon) {
                    BevelArrowIcon arrow = (BevelArrowIcon)sortIcon;
                    if (sortColumns.length > 0) {
                        if (!sortColumns[0].equals(columnName)) {
                            arrow.setSize(arrow.getOriginalSize() - 4);
                        } else {
                            arrow.setSize(arrow.getOriginalSize());
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.getIcon() == null) {
            int width = 0;
            if (this.ascendingIcon != null) {
                width = this.ascendingIcon.getIconWidth();
            }
            if (this.descendingIcon != null) {
                width = Math.max(width, this.descendingIcon.getIconWidth());
            }
            if (width > 0) {
                dim.width += width + this.getIconTextGap();
            }
        }
        return dim;
    }
}

