/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.TableView;
import java.util.BitSet;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CellSelectionModel
extends DefaultListSelectionModel {
    protected static final int MIN = -1;
    protected static final int MAX = Integer.MAX_VALUE;
    protected BitSet value;
    protected BitSet extendedValue;
    protected TableView table;
    protected int firstAdjustedOrdinal;
    protected int lastAdjustedOrdinal;
    protected int firstChangedOrdinal;
    protected int lastChangedOrdinal;
    protected int anchorOrdinal;
    protected int leadOrdinal;
    protected int minOrdinal;
    protected int maxOrdinal;

    public CellSelectionModel() {
        this(null);
    }

    public CellSelectionModel(TableView table) {
        this.setTable(table);
        this.value = new BitSet(32);
        this.extendedValue = new BitSet(32);
        this.setSelectionMode(2);
        this.minOrdinal = Integer.MAX_VALUE;
        this.maxOrdinal = -1;
        this.firstAdjustedOrdinal = Integer.MAX_VALUE;
        this.lastAdjustedOrdinal = -1;
        this.lastChangedOrdinal = -1;
        this.firstChangedOrdinal = Integer.MAX_VALUE;
        this.anchorOrdinal = -1;
        this.leadOrdinal = -1;
    }

    public void setTable(TableView newTable) {
        if (newTable != this.table) {
            this.table = newTable;
        }
    }

    public TableView getTable() {
        return this.table;
    }

    public int getMinSelectionOrdinal() {
        return this.isSelectionEmpty() ? -1 : this.minOrdinal;
    }

    public int getMaxSelectionOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.minOrdinal > this.maxOrdinal;
    }

    @Override
    public void setSelectionInterval(int ordinal1, int ordinal2) {
        if (ordinal1 == -1 || ordinal2 == -1) {
            return;
        }
        if (this.getSelectionMode() == 0) {
            ordinal1 = ordinal2;
        }
        this.updateSelectedValues();
        this.updateLeadAnchorOrdinals(ordinal1, ordinal2);
        int clearMin = this.minOrdinal;
        int clearMax = this.maxOrdinal;
        int setMin = Math.min(ordinal1, ordinal2);
        int setMax = Math.max(ordinal1, ordinal2);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    @Override
    public void addSelectionInterval(int ordinal1, int ordinal2) {
        if (ordinal1 == -1 || ordinal2 == -1) {
            return;
        }
        if (this.getSelectionMode() != 2) {
            this.setSelectionInterval(ordinal1, ordinal2);
            return;
        }
        this.updateSelectedValues();
        this.updateLeadAnchorOrdinals(ordinal1, ordinal2);
        int clearMin = Integer.MAX_VALUE;
        int clearMax = -1;
        int setMin = Math.min(ordinal1, ordinal2);
        int setMax = Math.max(ordinal1, ordinal2);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    @Override
    public void removeSelectionInterval(int ordinal1, int ordinal2) {
        if (ordinal1 == -1 || ordinal2 == -1) {
            return;
        }
        this.updateSelectedValues();
        this.updateLeadAnchorOrdinals(ordinal1, ordinal2);
        int clearMin = Math.min(ordinal1, ordinal2);
        int clearMax = Math.max(ordinal1, ordinal2);
        int setMin = Integer.MAX_VALUE;
        int setMax = -1;
        if (this.getSelectionMode() != 2 && clearMin > this.minOrdinal && clearMax < this.maxOrdinal) {
            clearMax = this.maxOrdinal;
        }
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.getMinSelectionOrdinal();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.getMaxSelectionOrdinal();
    }

    @Override
    public boolean isSelectedIndex(int ordinal) {
        return ordinal < this.minOrdinal || ordinal > this.maxOrdinal ? false : this.value.get(ordinal) || this.extendedValue.get(ordinal);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchorOrdinal;
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.leadOrdinal;
    }

    @Override
    public void setAnchorSelectionIndex(int ordinal) {
        this.updateSelectedValues();
        this.updateLeadAnchorOrdinals(ordinal, this.leadOrdinal);
        this.anchorOrdinal = ordinal;
        this.fireValueChanged();
    }

    @Override
    public void setLeadSelectionIndex(int ordinal) {
        int anchorOrdinal = this.anchorOrdinal;
        if (anchorOrdinal == -1 || ordinal == -1) {
            return;
        }
        if (this.leadOrdinal == -1) {
            this.leadOrdinal = ordinal;
        }
        boolean shouldSelect = this.value.get(this.anchorOrdinal) || this.extendedValue.get(this.anchorOrdinal);
        BitSet bits = this.extendedValue;
        if (this.getSelectionMode() == 0) {
            bits = this.value;
            anchorOrdinal = ordinal;
            shouldSelect = true;
        }
        int oldMin = Math.min(this.anchorOrdinal, this.leadOrdinal);
        int oldMax = Math.max(this.anchorOrdinal, this.leadOrdinal);
        int newMin = Math.min(anchorOrdinal, ordinal);
        int newMax = Math.max(anchorOrdinal, ordinal);
        this.updateLeadAnchorOrdinals(anchorOrdinal, ordinal);
        this.changeSelection(bits, oldMin, oldMax, newMin, newMax, shouldSelect);
    }

    @Override
    public void insertIndexInterval(int ordinal, int length, boolean before) {
        int insMinIndex = before ? ordinal : ordinal + 1;
        int insMaxIndex = insMinIndex + length - 1;
        for (int i = this.maxOrdinal; i >= insMinIndex; --i) {
            this.setState(i + length, this.value.get(i) || this.extendedValue.get(i));
        }
        boolean setInsertedValues = this.value.get(ordinal) || this.extendedValue.get(ordinal);
        for (int i = insMinIndex; i <= insMaxIndex; ++i) {
            this.setState(i, setInsertedValues);
        }
        this.fireValueChanged();
        this.validateMinAndMaxOrdinal();
    }

    @Override
    public void removeIndexInterval(int ordinal1, int ordinal2) {
        int rmMinIndex = Math.min(ordinal1, ordinal2);
        int rmMaxIndex = Math.max(ordinal1, ordinal2);
        int gapLength = rmMaxIndex - rmMinIndex + 1;
        for (int i = rmMinIndex; i <= this.maxOrdinal; ++i) {
            this.setState(i, this.value.get(i + gapLength) || this.extendedValue.get(i + gapLength));
        }
        this.fireValueChanged();
        this.validateMinAndMaxOrdinal();
    }

    private void setState(int index, boolean state) {
        if (state) {
            this.set(this.value, index);
            this.set(this.extendedValue, index);
        } else {
            this.clear(this.value, index);
            this.clear(this.extendedValue, index);
        }
    }

    public void addSelection(int row, int column) {
        this.addSelectionInterval(row, column, row, column);
    }

    public void setSelection(int row, int column) {
        this.setSelectionInterval(row, column, row, column);
    }

    public void setSelectionInterval(int row1, int column1, int row2, int column2) {
        int ordinal1 = this.createOrdinal(row1, column1);
        int ordinal2 = this.createOrdinal(row2, column2);
        this.setSelectionInterval(ordinal1, ordinal2);
    }

    public void addSelectionInterval(int row1, int column1, int row2, int column2) {
        int ordinal1 = this.createOrdinal(row1, column1);
        int ordinal2 = this.createOrdinal(row2, column2);
        this.addSelectionInterval(ordinal1, ordinal2);
    }

    public void removeSelection(int row, int column) {
        this.removeSelectionInterval(row, column, row, column);
    }

    public void removeSelectionInterval(int row1, int column1, int row2, int column2) {
        int ordinal1 = this.createOrdinal(row1, column1);
        int ordinal2 = this.createOrdinal(row2, column2);
        this.removeSelectionInterval(ordinal1, ordinal2);
    }

    public void setAnchorSelectionCell(int row, int column) {
        int ordinal = this.createOrdinal(row, column);
        this.setAnchorSelectionIndex(ordinal);
    }

    public void setLeadSelectionCell(int row, int column) {
        int ordinal = this.createOrdinal(row, column);
        this.setLeadSelectionIndex(ordinal);
    }

    @Override
    public void clearSelection() {
        int columnCount = 1;
        if (this.getTable() != null) {
            columnCount = this.getTable().getColumnCount();
        }
        if (columnCount > 0) {
            int row1 = this.minOrdinal / columnCount;
            int column1 = this.minOrdinal % columnCount;
            int row2 = this.maxOrdinal / columnCount;
            int column2 = this.maxOrdinal % columnCount;
            this.removeSelectionInterval(row1, column1, row2, column2);
        }
    }

    protected void updateSelectedValues() {
        this.value.or(this.extendedValue);
        int size = this.extendedValue.length();
        for (int i = 0; i < size; ++i) {
            this.extendedValue.clear(i);
        }
    }

    public boolean isSelected(int row, int column) {
        return this.isSelectedIndex(this.createOrdinal(row, column));
    }

    protected void set(BitSet bits, int ordinal) {
        if (bits.get(ordinal)) {
            return;
        }
        bits.set(ordinal);
        this.markAsDirty(ordinal);
        this.minOrdinal = Math.min(this.minOrdinal, ordinal);
        this.maxOrdinal = Math.max(this.maxOrdinal, ordinal);
    }

    protected void clear(BitSet bits, int ordinal) {
        if (!bits.get(ordinal)) {
            return;
        }
        bits.clear(ordinal);
        this.markAsDirty(ordinal);
        if (this.value.length() == 0 && this.extendedValue.length() == 0) {
            this.minOrdinal = Integer.MAX_VALUE;
            this.maxOrdinal = -1;
            return;
        }
        if (this.isSelectionEmpty()) {
            this.minOrdinal = Integer.MAX_VALUE;
            this.maxOrdinal = -1;
        }
    }

    protected void markAsDirty(int ordinal) {
        this.firstAdjustedOrdinal = Math.min(this.firstAdjustedOrdinal, ordinal);
        this.lastAdjustedOrdinal = Math.max(this.lastAdjustedOrdinal, ordinal);
    }

    protected boolean contains(int a, int b, int i) {
        return i >= a && i <= b;
    }

    protected void updateLeadAnchorOrdinals(int anchorOrdinal, int leadOrdinal) {
        if (this.leadAnchorNotificationEnabled) {
            if (this.anchorOrdinal != anchorOrdinal) {
                if (this.anchorOrdinal != -1) {
                    this.markAsDirty(this.anchorOrdinal);
                }
                this.markAsDirty(anchorOrdinal);
            }
            if (this.leadOrdinal != leadOrdinal) {
                if (this.leadOrdinal != -1) {
                    this.markAsDirty(this.leadOrdinal);
                }
                this.markAsDirty(leadOrdinal);
            }
        }
        this.anchorOrdinal = anchorOrdinal;
        this.leadOrdinal = leadOrdinal;
    }

    protected void validateMinAndMaxOrdinal() {
        if (this.getTable() != null) {
            int columnCount = Math.max(1, this.getTable().getColumnCount());
            int minRow = Integer.MAX_VALUE;
            int maxRow = -1;
            int minColumn = Integer.MAX_VALUE;
            int maxColumn = -1;
            if (minColumn > 0 || maxColumn < columnCount - 1) {
                int row;
                int col;
                int i;
                int row2;
                boolean gotFirst = false;
                int size = this.value.length();
                if (size > 0 && (row2 = (size - 1) / columnCount) > maxRow) {
                    maxRow = row2;
                }
                for (i = 0; i < size && (minColumn > 0 || maxColumn < columnCount - 1); ++i) {
                    if (!this.value.get(i)) continue;
                    col = i % columnCount;
                    if (col < minColumn) {
                        minColumn = col;
                    }
                    if (col > maxColumn) {
                        maxColumn = col;
                    }
                    if (gotFirst) continue;
                    gotFirst = true;
                    row = i / columnCount;
                    if (row >= minRow) continue;
                    minRow = row;
                }
                gotFirst = false;
                size = this.extendedValue.length();
                if (size > 0 && (row2 = (size - 1) / columnCount) > maxRow) {
                    maxRow = row2;
                }
                for (i = 0; i < size && (minColumn > 0 || maxColumn < columnCount - 1); ++i) {
                    if (!this.extendedValue.get(i)) continue;
                    col = i % columnCount;
                    if (col < minColumn) {
                        minColumn = col;
                    }
                    if (col > maxColumn) {
                        maxColumn = col;
                    }
                    if (gotFirst) continue;
                    gotFirst = true;
                    row = i / columnCount;
                    if (row >= minRow) continue;
                    minRow = row;
                }
            }
            this.minOrdinal = this.createOrdinal(minRow, minColumn);
            this.maxOrdinal = this.createOrdinal(maxRow, maxColumn);
        }
    }

    protected void changeSelection(BitSet bits, int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        int columnCount = 0;
        if (this.getTable() != null) {
            columnCount = this.getTable().getColumnCount();
        }
        int maxColumnCount = Math.max(1, columnCount);
        int clearRow1 = Integer.MAX_VALUE;
        if (clearMin != Integer.MAX_VALUE) {
            clearRow1 = clearMin / maxColumnCount;
        }
        int clearRow2 = -1;
        if (clearMax != -1) {
            clearRow2 = clearMax / maxColumnCount;
        }
        int clearMaxRow = Math.max(clearRow1, clearRow2);
        int clearMinRow = Math.min(clearRow1, clearRow2);
        if (clearMax == -1) {
            clearMaxRow = -1;
        }
        if (clearMaxRow == Integer.MAX_VALUE) {
            clearMaxRow = -1;
        }
        if (clearMin == Integer.MAX_VALUE) {
            clearMinRow = Integer.MAX_VALUE;
        }
        if (clearMinRow == -1) {
            clearMinRow = Integer.MAX_VALUE;
        }
        int clearColumn1 = Integer.MAX_VALUE;
        int clearColumn2 = -1;
        if (clearMin != Integer.MAX_VALUE) {
            clearColumn1 = clearMin % maxColumnCount;
        }
        if (clearMax != -1) {
            clearColumn2 = clearMax % maxColumnCount;
        }
        int clearMinColumn = Math.min(clearColumn1, clearColumn2);
        int clearMaxColumn = Math.max(clearColumn1, clearColumn2);
        if (clearMinColumn == -1) {
            clearMinColumn = clearColumn1;
        }
        if (clearMaxColumn == Integer.MAX_VALUE) {
            clearMaxColumn = clearColumn2;
        }
        int row1 = setMin / maxColumnCount;
        int row2 = setMax / maxColumnCount;
        int maxRow = Math.max(row1, row2);
        int minRow = Math.min(row1, row2);
        if (setMax == -1) {
            maxRow = -1;
        }
        if (maxRow == Integer.MAX_VALUE) {
            maxRow = Integer.MAX_VALUE;
        }
        if (setMin == Integer.MAX_VALUE) {
            minRow = Integer.MAX_VALUE;
        }
        if (minRow == -1) {
            minRow = Integer.MAX_VALUE;
        }
        int column1 = Integer.MAX_VALUE;
        int column2 = -1;
        if (setMin != Integer.MAX_VALUE) {
            column1 = setMin % maxColumnCount;
        }
        if (setMax != -1) {
            column2 = setMax % maxColumnCount;
        }
        int minColumn = Math.min(column1, column2);
        int maxColumn = Math.max(column1, column2);
        if (minColumn == -1) {
            minColumn = column1;
        }
        if (maxColumn == Integer.MAX_VALUE) {
            maxColumn = column2;
        }
        clearMin = Integer.MAX_VALUE;
        clearMax = -1;
        setMin = Integer.MAX_VALUE;
        setMax = -1;
        int max = Math.max(clearMaxRow, maxRow);
        for (int i = Math.min(clearMinRow, minRow); i <= max; ++i) {
            if (i > clearMaxRow) {
                clearMin = Integer.MAX_VALUE;
                clearMax = -1;
            } else if (i < clearMinRow) {
                clearMin = Integer.MAX_VALUE;
                clearMax = -1;
            } else {
                clearMin = this.createOrdinal(i, clearMinColumn);
                clearMax = this.createOrdinal(i, clearMaxColumn);
            }
            if (i > maxRow) {
                setMin = Integer.MAX_VALUE;
                setMax = -1;
            } else if (i < minRow) {
                setMin = Integer.MAX_VALUE;
                setMax = -1;
            } else {
                setMin = this.createOrdinal(i, minColumn);
                setMax = this.createOrdinal(i, maxColumn);
            }
            int max2 = Math.max(setMax, clearMax);
            for (int j = Math.min(setMin, clearMin); j <= max2; ++j) {
                boolean shouldClear = this.contains(clearMin, clearMax, j);
                boolean shouldSet = this.contains(setMin, setMax, j);
                if (shouldSet && shouldClear) {
                    if (clearFirst) {
                        shouldClear = false;
                    } else {
                        shouldSet = false;
                    }
                }
                if (shouldSet) {
                    this.set(bits, j);
                }
                if (!shouldClear) continue;
                this.clear(bits, j);
            }
        }
        this.validateMinAndMaxOrdinal();
        this.fireValueChanged();
    }

    protected void changeSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        this.changeSelection(this.value, clearMin, clearMax, setMin, setMax, clearFirst);
    }

    protected void changeSelection(int clearMin, int clearMax, int setMin, int setMax) {
        this.changeSelection(clearMin, clearMax, setMin, setMax, true);
    }

    protected void changeTempSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        this.changeSelection(this.extendedValue, clearMin, clearMax, setMin, setMax, clearFirst);
    }

    protected void changeTempSelection(int clearMin, int clearMax, int setMin, int setMax) {
        this.changeTempSelection(clearMin, clearMax, setMin, setMax, true);
    }

    protected int createOrdinal(int row, int column) {
        if (row == -1 || column == -1) {
            return -1;
        }
        if (row == Integer.MAX_VALUE || column == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int colCount = 0;
        if (this.getTable() != null) {
            colCount = this.getTable().getColumnCount();
        }
        return column + row * colCount;
    }

    @Override
    protected void fireValueChanged(boolean isAdjusting) {
        if (this.lastChangedOrdinal == -1) {
            return;
        }
        int oldfirstChangedOrdinal = this.firstChangedOrdinal;
        int oldlastChangedOrdinal = this.lastChangedOrdinal;
        this.firstChangedOrdinal = Integer.MAX_VALUE;
        this.lastChangedOrdinal = -1;
        this.fireValueChanged(oldfirstChangedOrdinal, oldlastChangedOrdinal, isAdjusting);
    }

    @Override
    protected void fireValueChanged(int firstOrdinal, int lastOrdinal) {
        this.fireValueChanged(firstOrdinal, lastOrdinal, this.getValueIsAdjusting());
    }

    @Override
    protected void fireValueChanged(int firstOrdinal, int lastOrdinal, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null || !(e instanceof ListSelectionEvent)) {
                e = new ListSelectionEvent(this, firstOrdinal, lastOrdinal, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    protected void fireValueChanged() {
        if (this.lastAdjustedOrdinal == -1) {
            return;
        }
        if (this.getValueIsAdjusting()) {
            this.firstChangedOrdinal = Math.min(this.firstChangedOrdinal, this.firstAdjustedOrdinal);
            this.lastChangedOrdinal = Math.max(this.lastChangedOrdinal, this.lastAdjustedOrdinal);
        }
        int oldfirstAdjustedOrdinal = this.firstAdjustedOrdinal;
        int oldlastAdjustedOrdinal = this.lastAdjustedOrdinal;
        this.firstAdjustedOrdinal = Integer.MAX_VALUE;
        this.lastAdjustedOrdinal = -1;
        this.fireValueChanged(oldfirstAdjustedOrdinal, oldlastAdjustedOrdinal);
    }

    @Override
    public String toString() {
        String vs = this.value.toString();
        String tvs = this.extendedValue.toString();
        String comma = ", ";
        if (tvs.length() <= 2 || vs.length() <= 2) {
            comma = "";
        }
        String s = (this.getValueIsAdjusting() ? "~" : "=") + vs.substring(0, vs.length() - 1) + comma + tvs.substring(1);
        return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + s;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CellSelectionModel clone = (CellSelectionModel)super.clone();
        clone.value = (BitSet)this.value.clone();
        clone.extendedValue = (BitSet)this.extendedValue.clone();
        return clone;
    }
}

