/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.NavigationalAction;
import com.sas.swing.visuals.tableview.PagingAction;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.SelectAction;
import com.sas.swing.visuals.tableview.ShowPopupMenuAction;
import com.sas.swing.visuals.tableview.StartEditingAction;
import com.sas.swing.visuals.tableview.SwapCurrentCellAction;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableViewUI
extends BasicTableUI {
    protected TableView table;
    protected PropertyChangeListener propertyChangeListener;
    protected static Rectangle nonHeldRect;
    protected static Rectangle heldClip;

    public BasicTableViewUI() {
        nonHeldRect = new Rectangle();
        heldClip = new Rectangle();
    }

    protected int calculateColumnIndex(Point p) {
        int column = this.table.columnAtPoint(p);
        if (column == -1) {
            column = this.table.getComponentOrientation().isLeftToRight() ? (p.x > 0 ? (p.x >= this.table.getCellAreaWidth() ? this.table.getColumnCount() - 1 : this.table.getColumnCount() - ((HoldInterface)((Object)this.table.getTableHeader())).getHeldIndices(4).size() - 1) : 0) : (p.x < 0 ? this.table.getColumnCount() - 1 : 0);
        }
        return column;
    }

    protected int calculateRowIndex(Point p) {
        int row = this.table.rowAtPoint(p);
        if (row == -1) {
            row = p.y > 0 ? (p.y >= this.table.getCellAreaHeight() ? this.table.getRowCount() - 1 : this.table.getRowCount() - this.table.getRowHeader().getHeldIndices(3).size() - 1) : 0;
        }
        return row;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicTableViewUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.table = (TableView)c;
        super.installUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        InputMap inputMap = this.table.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(121, 1), "showPopupMenu");
        inputMap.put(KeyStroke.getKeyStroke(47, 2), "deselectAll");
        inputMap.put(KeyStroke.getKeyStroke(32, 2), "deselect");
        inputMap.put(KeyStroke.getKeyStroke(32, 0), new Object());
        inputMap.put(KeyStroke.getKeyStroke(32, 1), new Object());
        inputMap.put(KeyStroke.getKeyStroke(32, 3), new Object());
        inputMap.put(KeyStroke.getKeyStroke(34, 3), "scrollRightExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(33, 3), "scrollLeftExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(117, 2), "swapWithColumnHeader");
        inputMap.put(KeyStroke.getKeyStroke(118, 2), "swapWithRowHeader");
        inputMap.put(KeyStroke.getKeyStroke(119, 2), "swapWithOriginComponent");
        ActionMap map = this.table.getActionMap();
        map.put("selectNextColumn", new NavigationalAction(1, 0, false, false, false));
        map.put("selectPreviousColumn", new NavigationalAction(-1, 0, false, false, false));
        map.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        map.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        map.put("selectNextColumnExtendSelection", new NavigationalAction(1, 0, false, true, false));
        map.put("selectPreviousColumnExtendSelection", new NavigationalAction(-1, 0, false, true, false));
        map.put("selectNextRowExtendSelection", new NavigationalAction(0, 1, false, true, false));
        map.put("selectPreviousRowExtendSelection", new NavigationalAction(0, -1, false, true, false));
        map.put("scrollUpChangeSelection", new PagingAction(false, false, true, false));
        map.put("scrollDownChangeSelection", new PagingAction(false, true, true, false));
        map.put("selectFirstColumn", new PagingAction(false, false, false, true));
        map.put("selectLastColumn", new PagingAction(false, true, false, true));
        map.put("scrollUpExtendSelection", new PagingAction(true, false, true, false));
        map.put("scrollDownExtendSelection", new PagingAction(true, true, true, false));
        map.put("selectFirstColumnExtendSelection", new PagingAction(true, false, false, true));
        map.put("selectLastColumnExtendSelection", new PagingAction(true, true, false, true));
        map.put("selectFirstRow", new PagingAction(false, false, true, true));
        map.put("selectLastRow", new PagingAction(false, true, true, true));
        map.put("selectFirstRowExtendSelection", new PagingAction(true, false, true, true));
        map.put("selectLastRowExtendSelection", new PagingAction(true, true, true, true));
        map.put("selectNextColumnCell", new NavigationalAction(1, 0, true, false, true));
        map.put("selectPreviousColumnCell", new NavigationalAction(-1, 0, true, false, true));
        map.put("selectNextRowCell", new NavigationalAction(0, 1, true, false, true));
        map.put("selectPreviousRowCell", new NavigationalAction(0, -1, true, false, true));
        if (this.table.getComponentOrientation().isLeftToRight()) {
            map.put("scrollLeftChangeSelection", new PagingAction(false, false, false, false));
            map.put("scrollRightChangeSelection", new PagingAction(false, true, false, false));
            map.put("scrollLeftExtendSelection", new PagingAction(true, false, false, false));
            map.put("scrollRightExtendSelection", new PagingAction(true, true, false, false));
        } else {
            map.put("scrollLeftChangeSelection", new PagingAction(false, true, false, false));
            map.put("scrollRightChangeSelection", new PagingAction(false, false, false, false));
            map.put("scrollLeftExtendSelection", new PagingAction(true, true, false, false));
            map.put("scrollRightExtendSelection", new PagingAction(true, false, false, false));
        }
        map.put("startEditing", new StartEditingAction());
        map.put("showPopupMenu", new ShowPopupMenuAction());
        map.put("deselectAll", new SelectAction(false, true));
        map.put("deselect", new SelectAction(false, false));
        map.put("swapWithColumnHeader", new SwapCurrentCellAction(1));
        map.put("swapWithRowHeader", new SwapCurrentCellAction(2));
        map.put("swapWithOriginComponent", new SwapCurrentCellAction(3));
    }

    private Dimension createTableSize(long width) {
        int height = 0;
        int rowCount = this.table.getRowCount();
        if (rowCount > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, 0, true, false);
            height = r.y + r.height;
        }
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle oldClipBounds = g.getClipBounds();
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(oldClipBounds.x, oldClipBounds.y, oldClipBounds.width, oldClipBounds.height);
        if (colCount == 0 || rowCount == 0) {
            return;
        }
        Rectangle cellArea = this.table.getCellAreaRect();
        Rectangle cellClipBounds = cellArea.intersection(oldClipBounds);
        g.setColor(this.table.getBackground());
        g.fillRect(cellClipBounds.x, cellClipBounds.y, cellClipBounds.width, cellClipBounds.height);
        if (!cellClipBounds.isEmpty()) {
            int heldColumnLeftWidth = 0;
            int heldColumnRightWidth = 0;
            int heldColumnLeftCount = 0;
            int heldColumnRightCount = 0;
            if (this.table.getColumnHeader() != null) {
                heldColumnLeftCount = this.table.getColumnHeader().getHeldIndices(2).size();
                heldColumnRightCount = this.table.getColumnHeader().getHeldIndices(4).size();
                heldColumnLeftWidth = this.table.getColumnHeader().getLeadingHeldWidth();
                heldColumnRightWidth = this.table.getColumnHeader().getTrailingHeldWidth();
            }
            int heldRowTopHeight = this.table.getRowHeader().getTopHeldHeight();
            int heldRowBottomHeight = this.table.getRowHeader().getBottomHeldHeight();
            int heldRowTopCount = this.table.getRowHeader().getHeldIndices(1).size();
            int heldRowBottomCount = this.table.getRowHeader().getHeldIndices(3).size();
            boolean accountForHolds = !this.table.printing;
            boolean ltr = this.table.getComponentOrientation().isLeftToRight();
            Point upperLeft = oldClipBounds.getLocation();
            Point lowerRight = new Point(oldClipBounds.x + oldClipBounds.width - 1, oldClipBounds.y + oldClipBounds.height - 1);
            int rMin = Math.max(this.table.rowAtPoint(upperLeft, accountForHolds), heldRowTopCount);
            int rMax = Math.min(this.table.rowAtPoint(lowerRight, accountForHolds), rowCount - 1 - heldRowBottomCount);
            int cMin = Math.max(this.table.columnAtPoint(ltr ? upperLeft : lowerRight, accountForHolds), heldColumnLeftCount);
            int cMax = Math.min(this.table.columnAtPoint(ltr ? lowerRight : upperLeft, accountForHolds), colCount - 1 - heldColumnRightCount);
            if (rMin < 0) {
                rMin = 0;
            }
            if (cMin < 0) {
                cMin = 0;
            }
            if (cMax == -1) {
                cMax = colCount - 1;
            }
            if (rMax == -1) {
                rMax = rowCount - 1;
            }
            this.paintCells(g, rMin, rMax, cMin, cMax);
            this.paintGrid(g, rMin, rMax, cMin, cMax, false);
            if (heldRowTopCount > 0 || heldRowBottomCount > 0 || heldColumnRightCount > 0 || heldColumnLeftCount > 0) {
                Rectangle r;
                Rectangle clipBounds = cellClipBounds;
                Rectangle vr = this.table.getVisibleRect();
                int startXRightHeldPos = clipBounds.x + Math.min(clipBounds.width, cellArea.width) - heldColumnRightWidth;
                int startYBottomHeldPos = clipBounds.y + Math.min(clipBounds.height, cellArea.height) - heldRowBottomHeight;
                int rightHeldWidth = clipBounds.x + clipBounds.width - startXRightHeldPos;
                int bottomHeldHeight = Math.min(clipBounds.height - heldRowTopHeight, heldRowBottomHeight);
                int visTableWidth = Math.min(vr.width, cellArea.width);
                int visTableHeight = Math.min(vr.height, cellArea.height);
                BasicTableViewUI.heldClip.x = clipBounds.x + heldColumnLeftWidth;
                BasicTableViewUI.heldClip.width = clipBounds.width - (heldColumnLeftWidth + heldColumnRightWidth);
                BasicTableViewUI.heldClip.height = bottomHeldHeight;
                BasicTableViewUI.heldClip.y = startYBottomHeldPos;
                Rectangle rect = null;
                if (heldRowBottomCount > 0 && !(rect = heldClip.intersection(clipBounds)).isEmpty()) {
                    this.clipAndPaint(g, rect);
                    if (this.table.printing) {
                        g.translate(0, rect.y - vr.y - visTableHeight + heldRowBottomHeight);
                    }
                    this.paintCells(g, rowCount - heldRowBottomCount, rowCount - 1, Math.max(cMin, heldColumnLeftCount), Math.min(cMax, colCount - 1 - heldColumnRightCount));
                    r = g.getClipBounds();
                    --r.y;
                    ++r.height;
                    g.setClip(r);
                    this.paintGrid(g, rowCount - heldRowBottomCount, rowCount - 1, Math.max(cMin, heldColumnLeftCount), Math.min(cMax, colCount - 1 - heldColumnRightCount), true);
                    ++r.y;
                    --r.height;
                    g.setClip(r);
                    if (this.table.printing) {
                        g.translate(0, -(rect.y - vr.y - visTableHeight + heldRowBottomHeight));
                    }
                }
                BasicTableViewUI.heldClip.y = clipBounds.y;
                BasicTableViewUI.heldClip.height = heldRowTopHeight;
                if (heldRowTopCount > 0 && !(rect = heldClip.intersection(clipBounds)).isEmpty()) {
                    this.clipAndPaint(g, rect);
                    if (this.table.printing) {
                        g.translate(0, rect.y - vr.y);
                    }
                    this.paintCells(g, 0, heldRowTopCount - 1, Math.max(cMin, heldColumnLeftCount), Math.min(cMax, colCount - 1 - heldColumnRightCount));
                    this.paintGrid(g, 0, heldRowTopCount - 1, Math.max(cMin, heldColumnLeftCount), Math.min(cMax, colCount - 1 - heldColumnRightCount), true);
                    if (this.table.printing) {
                        g.translate(0, -(rect.y - vr.y));
                    }
                }
                BasicTableViewUI.heldClip.y = clipBounds.y + heldRowTopHeight;
                BasicTableViewUI.heldClip.height = clipBounds.height - heldRowTopHeight - heldRowBottomHeight;
                BasicTableViewUI.heldClip.width = rightHeldWidth;
                BasicTableViewUI.heldClip.x = startXRightHeldPos;
                if (heldColumnRightCount > 0 && !(rect = heldClip.intersection(clipBounds)).isEmpty()) {
                    this.clipAndPaint(g, rect);
                    if (this.table.printing) {
                        g.translate(rect.x - vr.x - visTableWidth + heldColumnRightWidth, 0);
                    }
                    this.paintCells(g, Math.max(rMin, heldRowTopCount), Math.min(rMax, rowCount - 1 - heldRowBottomCount), colCount - heldColumnRightCount, colCount - 1);
                    r = g.getClipBounds();
                    --r.x;
                    ++r.width;
                    g.setClip(r);
                    this.paintGrid(g, Math.max(rMin, heldRowTopCount), Math.min(rMax, rowCount - 1 - heldRowBottomCount), colCount - heldColumnRightCount, colCount - 1, true);
                    ++r.x;
                    --r.width;
                    g.setClip(r);
                    if (this.table.printing) {
                        g.translate(-(rect.x - vr.x - visTableWidth + heldColumnRightWidth), 0);
                    }
                }
                BasicTableViewUI.heldClip.x = clipBounds.x;
                BasicTableViewUI.heldClip.width = heldColumnLeftWidth;
                if (heldColumnLeftCount > 0 && !(rect = heldClip.intersection(clipBounds)).isEmpty()) {
                    this.clipAndPaint(g, rect);
                    if (this.table.printing) {
                        g.translate(rect.x - vr.x, 0);
                    }
                    this.paintCells(g, Math.max(rMin, heldRowTopCount), Math.min(rMax, rowCount - 1 - heldRowBottomCount), 0, heldColumnLeftCount - 1);
                    this.paintGrid(g, Math.max(rMin, heldRowTopCount), Math.min(rMax, rowCount - 1 - heldRowBottomCount), 0, heldColumnLeftCount - 1, true);
                    if (this.table.printing) {
                        g.translate(-(rect.x - vr.x), 0);
                    }
                }
                if (heldRowBottomCount > 0 && heldColumnRightCount > 0) {
                    BasicTableViewUI.heldClip.height = bottomHeldHeight;
                    BasicTableViewUI.heldClip.y = startYBottomHeldPos;
                    BasicTableViewUI.heldClip.width = rightHeldWidth;
                    BasicTableViewUI.heldClip.x = startXRightHeldPos;
                    rect = heldClip.intersection(clipBounds);
                    if (!rect.isEmpty()) {
                        this.clipAndPaint(g, rect);
                        if (this.table.printing) {
                            g.translate(rect.x - vr.x - visTableWidth + heldColumnRightWidth, rect.y - vr.y - visTableHeight + heldRowBottomHeight);
                        }
                        this.paintCells(g, rowCount - heldRowBottomCount, rowCount - 1, colCount - heldColumnRightCount, colCount - 1);
                        r = g.getClipBounds();
                        --r.x;
                        ++r.width;
                        --r.y;
                        ++r.height;
                        g.setClip(r);
                        this.paintGrid(g, rowCount - heldRowBottomCount, rowCount - 1, colCount - heldColumnRightCount, colCount - 1, true);
                        ++r.x;
                        --r.width;
                        ++r.y;
                        --r.height;
                        g.setClip(r);
                        if (this.table.printing) {
                            g.translate(-(rect.x - vr.x - visTableWidth + heldColumnRightWidth), -(rect.y - vr.y - visTableHeight + heldRowBottomHeight));
                        }
                    }
                }
                if (heldRowBottomCount > 0 && heldColumnLeftCount > 0) {
                    BasicTableViewUI.heldClip.height = bottomHeldHeight;
                    BasicTableViewUI.heldClip.y = startYBottomHeldPos;
                    BasicTableViewUI.heldClip.x = clipBounds.x;
                    BasicTableViewUI.heldClip.width = heldColumnLeftWidth;
                    rect = heldClip.intersection(clipBounds);
                    if (!rect.isEmpty()) {
                        this.clipAndPaint(g, rect);
                        if (this.table.printing) {
                            g.translate(rect.x - vr.x, rect.y - vr.y - visTableHeight + heldRowBottomHeight);
                        }
                        this.paintCells(g, rowCount - heldRowBottomCount, rowCount - 1, 0, heldColumnLeftCount - 1);
                        r = g.getClipBounds();
                        --r.y;
                        ++r.height;
                        g.setClip(r);
                        this.paintGrid(g, rowCount - heldRowBottomCount, rowCount - 1, 0, heldColumnLeftCount - 1, true);
                        ++r.y;
                        --r.height;
                        g.setClip(r);
                        if (this.table.printing) {
                            g.translate(-(rect.x - vr.x), -(rect.y - vr.y - visTableHeight + heldRowBottomHeight));
                        }
                    }
                }
                if (heldRowTopCount > 0 && heldColumnRightCount > 0) {
                    BasicTableViewUI.heldClip.y = clipBounds.y;
                    BasicTableViewUI.heldClip.height = heldRowTopHeight;
                    BasicTableViewUI.heldClip.width = rightHeldWidth;
                    BasicTableViewUI.heldClip.x = startXRightHeldPos;
                    rect = heldClip.intersection(clipBounds);
                    if (!rect.isEmpty()) {
                        this.clipAndPaint(g, rect);
                        if (this.table.printing) {
                            g.translate(rect.x - vr.x - visTableWidth + heldColumnRightWidth, rect.y - vr.y);
                        }
                        this.paintCells(g, 0, heldRowTopCount - 1, colCount - heldColumnRightCount, colCount - 1);
                        r = g.getClipBounds();
                        --r.x;
                        ++r.width;
                        g.setClip(r);
                        this.paintGrid(g, 0, heldRowTopCount - 1, colCount - heldColumnRightCount, colCount - 1, true);
                        ++r.x;
                        --r.width;
                        g.setClip(r);
                        if (this.table.printing) {
                            g.translate(-(rect.x - vr.x - visTableWidth + heldColumnRightWidth), -(rect.y - vr.y));
                        }
                    }
                }
                if (heldRowTopCount > 0 && heldColumnLeftCount > 0) {
                    BasicTableViewUI.heldClip.y = clipBounds.y;
                    BasicTableViewUI.heldClip.height = heldRowTopHeight;
                    BasicTableViewUI.heldClip.x = clipBounds.x;
                    BasicTableViewUI.heldClip.width = heldColumnLeftWidth;
                    rect = heldClip.intersection(clipBounds);
                    if (!rect.isEmpty()) {
                        this.clipAndPaint(g, rect);
                        if (this.table.printing) {
                            g.translate(rect.x - vr.x, rect.y - vr.y);
                        }
                        this.paintCells(g, 0, heldRowTopCount - 1, 0, heldColumnLeftCount - 1);
                        this.paintGrid(g, 0, heldRowTopCount - 1, 0, heldColumnLeftCount - 1, true);
                        if (this.table.printing) {
                            g.translate(-(rect.x - vr.x), -(rect.y - vr.y));
                        }
                    }
                }
                g.setClip(oldClipBounds);
            }
            JTableHeader header = this.table.getTableHeader();
            RowHeader rowHeader = this.table.getRowHeader();
            TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
            int draggedRowIndex = rowHeader.getDraggedRow();
            if (draggedColumn != null || draggedRowIndex != -1) {
                BasicTableViewUI.nonHeldRect.x = cellClipBounds.x + heldColumnLeftWidth;
                BasicTableViewUI.nonHeldRect.y = cellClipBounds.y + heldRowTopHeight;
                BasicTableViewUI.nonHeldRect.width = cellClipBounds.width - (heldColumnLeftWidth + heldColumnRightWidth);
                BasicTableViewUI.nonHeldRect.height = cellClipBounds.height - (heldRowTopHeight + heldRowBottomHeight);
            }
            if (draggedColumn != null) {
                this.paintDraggedColumn(g, rMin, rMax, draggedColumn, header.getDraggedDistance(), nonHeldRect);
                if (heldRowTopCount > 0) {
                    this.paintDraggedColumn(g, 0, heldRowTopCount - 1, draggedColumn, header.getDraggedDistance(), nonHeldRect);
                }
                if (heldRowBottomCount > 0) {
                    this.paintDraggedColumn(g, rowCount - heldRowBottomCount, rowCount - 1, draggedColumn, header.getDraggedDistance(), nonHeldRect);
                }
            }
            if (draggedRowIndex != -1) {
                this.paintDraggedRow(g, draggedRowIndex, cMin, cMax, rowHeader.getDraggedDistance(), nonHeldRect);
                if (heldColumnLeftCount > 0) {
                    this.paintDraggedRow(g, draggedRowIndex, 0, heldColumnLeftCount - 1, rowHeader.getDraggedDistance(), nonHeldRect);
                }
                if (heldColumnRightCount > 0) {
                    this.paintDraggedRow(g, draggedRowIndex, colCount - heldColumnRightCount, colCount - 1, rowHeader.getDraggedDistance(), nonHeldRect);
                }
            }
            this.rendererPane.removeAll();
        }
    }

    private void clipAndPaint(Graphics g, Rectangle r) {
        g.setClip(r);
        g.setColor(this.table.getBackground());
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax, boolean bothSides) {
        block19: {
            int i;
            int max;
            int i2;
            int index;
            int i3;
            int max2;
            g.setColor(this.table.getGridColor());
            Rectangle rect = g.getClipBounds();
            TableColumnModel cm = this.table.getColumnModel();
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            int tableWidth = damagedArea.x + damagedArea.width;
            int tableHeight = damagedArea.y + damagedArea.height;
            int y = minCell.y;
            int x = minCell.x;
            int gridWidth = Math.min(this.table.getGridWidth(), cm.getColumnMargin());
            int gridHeight = Math.min(this.table.getGridWidth(), this.table.getRowMargin());
            if (this.table.getShowHorizontalLines()) {
                if (bothSides) {
                    max2 = gridHeight / 2 + gridHeight % 2;
                    for (i3 = 0; i3 < max2; ++i3) {
                        g.drawLine(rect.x, y - max2 + i3, tableWidth - 1, y - max2 + i3);
                    }
                }
                for (index = rMin; index <= rMax; ++index) {
                    if (y >= rect.y && y <= rect.y + rect.height) {
                        max2 = gridHeight / 2;
                        for (i2 = 0; i2 < max2; ++i2) {
                            g.drawLine(rect.x, y + i2, tableWidth - 1, y + i2);
                        }
                    }
                    if ((y += this.table.getRowHeight(index)) < rect.y || y > rect.y + rect.height) continue;
                    max = gridHeight / 2 + gridHeight % 2;
                    for (i = 0; i < max; ++i) {
                        g.drawLine(rect.x, y - max + i, tableWidth - 1, y - max + i);
                    }
                }
            }
            if (!this.table.getShowVerticalLines()) break block19;
            if (bothSides) {
                max2 = gridWidth / 2 + gridWidth % 2;
                for (i3 = 0; i3 < max2; ++i3) {
                    g.drawLine(x - max2 + i3, rect.y, x - max2 + i3, tableHeight - 1);
                }
            }
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (index = cMin; index <= cMax; ++index) {
                    if (x >= rect.x && x <= rect.x + rect.width) {
                        max2 = gridWidth / 2;
                        for (i2 = 0; i2 < max2; ++i2) {
                            g.drawLine(x + i2, rect.y, x + i2, tableHeight - 1);
                        }
                    }
                    if ((x += this.table.getColumnModel().getColumn(index).getWidth()) < rect.x || x > rect.x + rect.width) continue;
                    max = gridWidth / 2 + gridWidth % 2;
                    for (i = 0; i < max; ++i) {
                        g.drawLine(x - max + i, rect.y, x - max + i, tableHeight - 1);
                    }
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    if (x >= rect.x && x <= rect.x + rect.width) {
                        max = gridWidth / 2;
                        for (int i4 = 0; i4 < max; ++i4) {
                            g.drawLine(x - i4 - 1, rect.y, x - i4 - 1, tableHeight - 1);
                        }
                    }
                    if ((x -= w) < rect.x || x > rect.x + rect.width) continue;
                    int max3 = gridWidth / 2 + gridWidth % 2;
                    for (i2 = 0; i2 < max3; ++i2) {
                        g.drawLine(x + max3 - i2 - 1, rect.y, x + max3 - i2 - 1, tableHeight - 1);
                    }
                }
            }
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        RowHeader rowHeader = this.table.getRowHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        int draggedRowIndex = rowHeader.getDraggedRow();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        int rowMargin = this.table.getRowMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            int rowHeight = this.table.getRowHeight(rMin);
            Rectangle cellRect = this.table.getCellRect(rMin, cMin, false);
            int initx = cellRect.x;
            for (int row = rMin; row <= rMax; ++row) {
                if (row != rMin) {
                    cellRect.x = initx;
                    cellRect.y += rowHeight;
                    rowHeight = this.table.getRowHeight(row);
                    cellRect.height = rowHeight - rowMargin;
                }
                if (row == draggedRowIndex) continue;
                cMax = Math.min(cMax, this.table.getColumnCount() - 1);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            int rowHeight = this.table.getRowHeight(rMin);
            Rectangle cellRect = this.table.getCellRect(rMin, cMin, false);
            int initx = cellRect.x;
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                if (row != rMin) {
                    cellRect.x = initx;
                    cellRect.y += rowHeight;
                    rowHeight = this.table.getRowHeight(row);
                    cellRect.height = rowHeight - rowMargin;
                }
                if (row == draggedRowIndex) continue;
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column);
                }
            }
        }
    }

    private void paintDraggedColumn(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance, Rectangle nonHeldRect) {
        int draggedColumnIndex = this.table.convertColumnIndexToView(draggedColumn.getModelIndex());
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        Rectangle backgroundRect = vacatedColumnRect.intersection(nonHeldRect);
        backgroundRect.y = vacatedColumnRect.y;
        backgroundRect.height = vacatedColumnRect.height;
        int verticalGridSize = 0;
        int horizontalGridSize = 0;
        if (this.table.getShowVerticalLines()) {
            verticalGridSize = Math.min(this.table.getGridWidth(), this.table.getColumnModel().getColumnMargin());
        }
        if (this.table.getShowHorizontalLines()) {
            horizontalGridSize = Math.min(this.table.getGridWidth(), this.table.getRowMargin());
        }
        g.setColor(this.table.getParent().getBackground());
        if (draggedColumnIndex == this.table.getColumnCount() - 1) {
            g.fillRect(backgroundRect.x, backgroundRect.y, backgroundRect.width, backgroundRect.height);
        } else {
            g.fillRect(backgroundRect.x, backgroundRect.y, backgroundRect.width - (verticalGridSize / 2 + verticalGridSize % 2), backgroundRect.height);
        }
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        for (int row = rMin; row <= rMax; ++row) {
            int i;
            int max;
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            if (row == rMin) {
                max = horizontalGridSize / 2 + horizontalGridSize % 2;
                for (i = 0; i < max; ++i) {
                    g.drawLine(x1, y1 - max + i, x2, y1 - max + i);
                }
            }
            max = horizontalGridSize / 2;
            for (i = 0; i < max; ++i) {
                g.drawLine(x1, y1 + i, x2, y1 + i);
            }
            max = horizontalGridSize / 2 + horizontalGridSize % 2;
            for (i = 0; i < max; ++i) {
                g.drawLine(x1, y2 - i, x2, y2 - i);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int i;
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            int max = Math.max(verticalGridSize / 2, 1);
            for (i = 0; i < max; ++i) {
                g.drawLine(x1 + i, y1, x1 + i, y2);
            }
            max = verticalGridSize / 2 + verticalGridSize % 2;
            for (i = 0; i < max; ++i) {
                g.drawLine(x2 - i, y1, x2 - i, y2);
            }
        }
    }

    private void paintDraggedRow(Graphics g, int draggedRow, int cMin, int cMax, int distance, Rectangle nonHeldRect) {
        int draggedRowIndex = draggedRow;
        Rectangle minCell = this.table.getCellRect(draggedRowIndex, cMin, true);
        Rectangle maxCell = this.table.getCellRect(draggedRowIndex, cMax, true);
        Rectangle vacatedRowRect = minCell.union(maxCell);
        Rectangle backgroundRect = vacatedRowRect.intersection(nonHeldRect);
        backgroundRect.x = vacatedRowRect.x;
        backgroundRect.width = vacatedRowRect.width;
        int verticalGridSize = 0;
        int horizontalGridSize = 0;
        if (this.table.getShowVerticalLines()) {
            verticalGridSize = Math.min(this.table.getGridWidth(), this.table.getColumnModel().getColumnMargin());
        }
        if (this.table.getShowHorizontalLines()) {
            horizontalGridSize = Math.min(this.table.getGridWidth(), this.table.getRowMargin());
        }
        g.setColor(this.table.getParent().getBackground());
        if (draggedRow == this.table.getRowCount() - 1) {
            g.fillRect(backgroundRect.x, backgroundRect.y, backgroundRect.width, backgroundRect.height);
        } else {
            g.fillRect(backgroundRect.x, backgroundRect.y, backgroundRect.width, backgroundRect.height - (horizontalGridSize / 2 + horizontalGridSize % 2));
        }
        vacatedRowRect.y += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedRowRect.x, vacatedRowRect.y, vacatedRowRect.width, vacatedRowRect.height);
        for (int col = cMin; col <= cMax; ++col) {
            int i;
            int max;
            Rectangle r = this.table.getCellRect(draggedRowIndex, col, false);
            r.y += distance;
            this.paintCell(g, r, draggedRowIndex, col);
            if (!this.table.getShowVerticalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(draggedRowIndex, col, true);
            rcr.y += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            if (col == cMin) {
                max = verticalGridSize / 2 + verticalGridSize % 2;
                for (i = 0; i < max; ++i) {
                    g.drawLine(x1 - max + i, y1, x1 - max + i, y2);
                }
            }
            max = verticalGridSize / 2;
            for (i = 0; i < max; ++i) {
                g.drawLine(x1 + i, y1, x1 + i, y2);
            }
            max = verticalGridSize / 2 + verticalGridSize % 2;
            for (i = 0; i < max; ++i) {
                g.drawLine(x2 - i, y1, x2 - i, y2);
            }
        }
        if (this.table.getShowHorizontalLines()) {
            int i;
            g.setColor(this.table.getGridColor());
            int x1 = vacatedRowRect.x;
            int y1 = vacatedRowRect.y - 1;
            int x2 = x1 + vacatedRowRect.width - 1;
            int y2 = y1 + vacatedRowRect.height;
            int max = Math.max(horizontalGridSize / 2, 1);
            for (i = 0; i < max; ++i) {
                g.drawLine(x1, y1 + i, x2, y1 + i);
            }
            max = horizontalGridSize / 2 + horizontalGridSize % 2;
            for (i = 0; i < max; ++i) {
                g.drawLine(x1, y2 - i, x2, y2 - i);
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String changeName = event.getPropertyName();
            if (changeName.equals("componentOrientation") && BasicTableViewUI.this.table instanceof TableView) {
                JScrollPane pane;
                JComponent origin;
                RowHeader rowHeader = BasicTableViewUI.this.table.getRowHeader();
                if (rowHeader != null) {
                    rowHeader.setComponentOrientation((ComponentOrientation)event.getNewValue());
                }
                if ((origin = BasicTableViewUI.this.table.getOriginComponent()) != null) {
                    origin.setComponentOrientation((ComponentOrientation)event.getNewValue());
                }
                if (origin.isVisible() && (pane = BasicTableViewUI.this.table.getScrollPane()) != null) {
                    if (BasicTableViewUI.this.table.getComponentOrientation().isLeftToRight()) {
                        Component comp = pane.getCorner("UPPER_LEFT_CORNER");
                        pane.setCorner("UPPER_LEFT_CORNER", origin);
                        if (comp != origin && comp != null) {
                            pane.setCorner("UPPER_RIGHT_CORNER", comp);
                        }
                    } else {
                        Component comp = pane.getCorner("UPPER_RIGHT_CORNER");
                        pane.setCorner("UPPER_RIGHT_CORNER", origin);
                        if (comp != origin && comp != null) {
                            pane.setCorner("UPPER_LEFT_CORNER", comp);
                        }
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JScrollPane pane = BasicTableViewUI.this.table.getScrollPane();
                        if (pane != null) {
                            pane.repaint();
                        }
                    }
                });
            }
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean inside;

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = BasicTableViewUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(BasicTableViewUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !BasicTableViewUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(BasicTableViewUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            BasicTableViewUI.this.table.getRowModel().getSelectionModel().setValueIsAdjusting(flag);
            BasicTableViewUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
            BasicTableViewUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !BasicTableViewUI.this.table.isEnabled();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.inside = false;
            if (!BasicTableViewUI.this.table.isEnabled()) {
                return;
            }
            Point p = e.getPoint();
            int row = BasicTableViewUI.this.table.rowAtPoint(p);
            int column = BasicTableViewUI.this.table.columnAtPoint(p);
            if (column != -1 && row != -1) {
                this.inside = true;
                if (BasicTableViewUI.this.table.editCellAt(row, column, e)) {
                    this.setDispatchComponent(e);
                    this.repostEvent(e);
                } else if (BasicTableViewUI.this.table.isRequestFocusEnabled()) {
                    BasicTableViewUI.this.table.requestFocus();
                }
                TableCellEditor editor = BasicTableViewUI.this.table.getCellEditor();
                if (!(editor != null && !editor.shouldSelectCell(e) || !SwingUtilities.isLeftMouseButton(e) && BasicTableViewUI.this.table.isCellSelected(row, column))) {
                    boolean adjusting = e.getID() == 501;
                    this.setValueIsAdjusting(adjusting);
                    BasicTableViewUI.this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
                }
            }
            if (this.shouldIgnore(e)) {
                if (BasicTableViewUI.this.table.isPopupMenuEnabled() && (!SwingUtilities.isLeftMouseButton(e) || e.isPopupTrigger())) {
                    BasicTableViewUI.this.table.showPopup(p);
                }
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.inside = false;
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            TableCellEditor editor = BasicTableViewUI.this.table.getCellEditor();
            if ((editor == null || editor.shouldSelectCell(e)) && this.inside) {
                Point p = e.getPoint();
                int row = BasicTableViewUI.this.calculateRowIndex(p);
                int column = BasicTableViewUI.this.calculateColumnIndex(p);
                BasicTableViewUI.this.table.changeSelection(row, column, e.isControlDown(), true);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int ar = 0;
            int ac = 0;
            if (BasicTableViewUI.this.table instanceof TableView) {
                BasicTableViewUI.this.table.repaintCurrentCell();
                return;
            }
            ar = BasicTableViewUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            ac = BasicTableViewUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            int rowCount = BasicTableViewUI.this.table.getRowCount();
            int colCount = BasicTableViewUI.this.table.getColumnCount();
            if (ar < 0 || ar >= rowCount || ac < 0 || ac >= colCount) {
                return;
            }
            Rectangle dirtyRect = BasicTableViewUI.this.table.getCellRect(ar, ac, false);
            BasicTableViewUI.this.table.repaint(dirtyRect);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintAnchorCell();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (BasicTableViewUI.this.table != null && BasicTableViewUI.this.table.isShowing()) {
                this.repaintAnchorCell();
            }
        }
    }
}

